/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soyparse.Tokens;
import java.util.List;

final class ParseErrors {
    private ParseErrors() {
    }

    static void reportSoyFileParseException(ErrorReporter reporter, String filePath, ParseException e) {
        Token errorToken = e.currentToken;
        if (errorToken.next != null) {
            errorToken = errorToken.next;
        }
        ImmutableSet.Builder expectedTokenImages = ImmutableSet.builder();
        for (int[] expected : e.expectedTokenSequences) {
            expectedTokenImages.add((Object)ParseErrors.getSoyFileParserTokenDisplayName(expected[0]));
        }
        reporter.report(Tokens.createSrcLoc(filePath, errorToken, new Token[0]), SoyErrorKind.of("{0}"), BaseUtils.formatParseExceptionDetails(errorToken.image, (List<String>)expectedTokenImages.build().asList()));
    }

    private static String getSoyFileParserTokenDisplayName(int tokenId) {
        switch (tokenId) {
            case 18: {
                return "attribute-value";
            }
            case 21: {
                return "{deltemplate";
            }
            case 22: {
                return "{template";
            }
            case 47: {
                return "{(del)call";
            }
            case 48: {
                return "{/(del)call}";
            }
            case 19: {
                return "identifier";
            }
            case 0: {
                return "eof";
            }
            case 49: {
                return "{param";
            }
            case 51: {
                return "{msg";
            }
            case 52: {
                return "{fallbackmsg";
            }
            case 54: {
                return "{print";
            }
            case 55: {
                return "{xid";
            }
            case 56: {
                return "{css";
            }
            case 57: {
                return "{if";
            }
            case 58: {
                return "{elseif";
            }
            case 61: {
                return "{let";
            }
            case 63: {
                return "{for";
            }
            case 65: {
                return "{plural";
            }
            case 67: {
                return "{select";
            }
            case 69: {
                return "{switch";
            }
            case 72: {
                return "{case";
            }
            case 73: {
                return "{foreach";
            }
            case 26: {
                throw new AssertionError((Object)"we should never expect the unexpected token");
            }
        }
        return SoyFileParserConstants.tokenImage[tokenId];
    }

    static void report(ErrorReporter reporter, String filePath, LegacyInternalSyntaxException exception) {
        SourceLocation sourceLocation = exception.getSourceLocation();
        if (!sourceLocation.isKnown()) {
            sourceLocation = new SourceLocation(filePath);
        }
        reporter.report(sourceLocation, SoyErrorKind.of("{0}"), exception.getOriginalMessage());
    }

    static void reportUnexpected(ErrorReporter reporter, String filePath, TokenMgrError exception) {
        reporter.report(new SourceLocation(filePath), SoyErrorKind.of("Unexpected fatal Soy error.  Please file a bug with your Soy file and we''ll take a look.  {0}"), exception.getMessage());
    }
}

