/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

final class CheckCallsVisitor
extends AbstractSoyNodeVisitor<List<String>> {
    private static final SoyErrorKind MISSING_PARAM = SoyErrorKind.of("Call missing required {0}.");
    private final TemplateRegistry templateRegistry;
    private final ErrorReporter errorReporter;

    CheckCallsVisitor(TemplateRegistry templateRegistry, ErrorReporter errorReporter) {
        this.templateRegistry = templateRegistry;
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitCallNode(CallNode node) {
        this.visitChildren(node);
        if (!node.dataAttribute().isPassingData()) {
            TemplateNode callee = null;
            if (node instanceof CallBasicNode) {
                callee = this.templateRegistry.getBasicTemplate(((CallBasicNode)node).getCalleeName());
            } else {
                String delTemplateName = ((CallDelegateNode)node).getDelCalleeName();
                ImmutableList potentialCallees = this.templateRegistry.getDelTemplateSelector().delTemplateNameToValues().get((Object)delTemplateName);
                if (!potentialCallees.isEmpty()) {
                    callee = (TemplateNode)potentialCallees.get(0);
                }
            }
            if (callee != null && callee.getParams() != null) {
                HashSet callerParamKeys = Sets.newHashSet();
                for (CallParamNode callerParam : node.getChildren()) {
                    callerParamKeys.add(callerParam.getKey());
                }
                ArrayList missingParamKeys = Lists.newArrayListWithCapacity((int)2);
                for (TemplateParam calleeParam : callee.getParams()) {
                    if (!calleeParam.isRequired() || callerParamKeys.contains(calleeParam.name())) continue;
                    missingParamKeys.add(calleeParam.name());
                }
                if (!missingParamKeys.isEmpty()) {
                    String errorMsgEnd = missingParamKeys.size() == 1 ? "param '" + (String)missingParamKeys.get(0) + "'" : "params " + missingParamKeys;
                    this.errorReporter.report(node.getSourceLocation(), MISSING_PARAM, errorMsgEnd);
                }
            }
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

