/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.Sets;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoytreeUtils;
import java.util.SortedSet;

final class GenFunctionPluginRequiresVisitor {
    private SortedSet<String> requiredJsLibNames;

    GenFunctionPluginRequiresVisitor() {
    }

    SortedSet<String> exec(SoyFileNode soyFile) {
        this.requiredJsLibNames = Sets.newTreeSet();
        GenFunctionPluginRequiresHelperVisitor helperVisitor = new GenFunctionPluginRequiresHelperVisitor();
        SoytreeUtils.execOnAllV2Exprs(soyFile, helperVisitor);
        return this.requiredJsLibNames;
    }

    private final class GenFunctionPluginRequiresHelperVisitor
    extends AbstractExprNodeVisitor<SortedSet<String>> {
        private GenFunctionPluginRequiresHelperVisitor() {
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            SoyFunction soyFunction = node.getSoyFunction();
            if (soyFunction instanceof SoyLibraryAssistedJsSrcFunction) {
                GenFunctionPluginRequiresVisitor.this.requiredJsLibNames.addAll(((SoyLibraryAssistedJsSrcFunction)soyFunction).getRequiredJsLibNames());
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }
    }
}

