/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;

public final class SoyErrorKind {
    private final MessageFormat messageFormat;
    private final int requiredArgs;

    private SoyErrorKind(MessageFormat messageFormat) {
        this.messageFormat = messageFormat;
        this.requiredArgs = messageFormat.getFormatsByArgumentIndex().length;
    }

    public String format(Object ... args) {
        Preconditions.checkState((args.length == this.requiredArgs ? 1 : 0) != 0, (String)"Error format required %s parameters, %s were supplied.", (Object[])new Object[]{this.requiredArgs, args.length});
        return this.messageFormat.format(args);
    }

    public static SoyErrorKind of(String format) {
        SoyErrorKind.checkFormat(format);
        return new SoyErrorKind(new MessageFormat(format));
    }

    private static void checkFormat(String format) {
        int index = 0;
        int singleQuote = 39;
        while ((index = format.indexOf(singleQuote, index)) != -1) {
            int nextIndex = format.indexOf(singleQuote, index + 1);
            if (nextIndex == -1) {
                throw new IllegalArgumentException("Found an unmatched single quote at char: " + index + " in '" + format + "'");
            }
            index = nextIndex + 1;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.messageFormat.toPattern() + "}";
    }
}

