/* Generated By:JavaCC: Do not edit this line. TypeParser.java */
package com.google.template.soy.types.parse;

import com.google.common.collect.Maps;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.aggregate.MapType;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.aggregate.RecordType;
import com.google.template.soy.types.primitive.UnknownType;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * This parser's specification is in TypeParser.jj, which is read by JavaCC and transformed
 * into TypeParser.java. To modify this parser, please edit TypeParser.jj. Do not edit
 * TypeParser.java directly.
 *
 * <p> Important: Do not use outside of Soy code (treat as superpackage-private).
 *
 */
public class TypeParser implements TypeParserConstants {

  /** Private constant used by some parse rules. */
  private static final List<SoyType> EMPTY_TYPE_ARGS = Collections.emptyList();

  private SoyTypeRegistry typeRegistry;

  private SourceLocation sourceLocation;

  /**
   * Constructor that takes a string input.
   * @param input The input to parse.
   * @param sourceLocation The location.
   * @param typeRegistry The type registry.
   */
  public TypeParser(
      String input,
      SourceLocation sourceLocation,
      SoyTypeRegistry typeRegistry) {
    this(new StringReader(input));
    this.sourceLocation = sourceLocation;
    this.typeRegistry = typeRegistry;
  }

  /**
   * Attempts to parse the input as a type declaration.
   * @throws TokenMgrError When the input has a token error.
   * @throws SoySyntaxException When the input has a parse error.
   */
  public SoyType parseTypeDeclaration() {
    try {
      return TypeDecl();
    } catch (ParseException e) {
      // TODO(lukes): we need to 'offset' the source location, however this is
      // essentially impossible because the TemplateParser/TemplateNodeBuilder
      // has 'pre stripped' whitespace then so anything we do here would be
      // wrong  ... so we don't try :(
      throw LegacyInternalSyntaxException.createWithMetaInfo(
          ParseErrors.formatParseException(e),
          sourceLocation);
    }
  }

  final private SoyType TypeDecl() throws ParseException {
  SoyType type;
    type = TypeExpr();
    jj_consume_token(0);
    {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

  final private SoyType TypeExpr() throws ParseException {
  SoyType type;
    type = UnionTypeExpr();
    {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

  final private SoyType UnionTypeExpr() throws ParseException {
  SoyType type;
    List<SoyType> members = new ArrayList<SoyType>();
    type = Primary();
    members.add(type);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VBAR:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      jj_consume_token(VBAR);
      type = Primary();
      members.add(type);
    }
    {if (true) return UnionType.of(members);}
    throw new Error("Missing return statement in function");
  }

  final private SoyType Primary() throws ParseException {
  SoyType type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      type = TypeName();
      break;
    case QMARK:
      type = UnknownType();
      break;
    case GENERIC_LIST:
      type = ListType();
      break;
    case GENERIC_MAP:
      type = MapType();
      break;
    case LBRACKET:
      type = RecordType();
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

  final private SoyType ListType() throws ParseException {
  SoyType typeArg;
    jj_consume_token(GENERIC_LIST);
    jj_consume_token(LANGLE);
    typeArg = TypeExpr();
    jj_consume_token(RANGLE);
    {if (true) return typeRegistry.getOrCreateListType(typeArg);}
    throw new Error("Missing return statement in function");
  }

  final private SoyType MapType() throws ParseException {
  SoyType key, value;
    jj_consume_token(GENERIC_MAP);
    jj_consume_token(LANGLE);
    key = TypeExpr();
    jj_consume_token(COMMA);
    value = TypeExpr();
    jj_consume_token(RANGLE);
    {if (true) return typeRegistry.getOrCreateMapType(key, value);}
    throw new Error("Missing return statement in function");
  }

  final private SoyType RecordType() throws ParseException {
  Map<String, SoyType> fields = Maps.newHashMap();
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      RecordField(fields);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[2] = jj_gen;
          break label_2;
        }
        jj_consume_token(COMMA);
        RecordField(fields);
      }
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
   {if (true) return typeRegistry.getOrCreateRecordType(fields);}
    throw new Error("Missing return statement in function");
  }

  final private void RecordField(Map<String, SoyType> fields) throws ParseException {
  Token fieldName;
  SoyType fieldType;
    fieldName = jj_consume_token(IDENT);
    jj_consume_token(COLON);
    fieldType = TypeExpr();
    if (fields.containsKey(fieldName.image)) {
      {if (true) throw LegacyInternalSyntaxException.createWithMetaInfo(
          "Duplicate field definition for record: " + fieldName.image,
          sourceLocation);}
    }
    fields.put(fieldName.image, fieldType);
  }

  final private SoyType TypeName() throws ParseException {
  String ident;
    SoyType typeName;
    ident = DottedIdent();
    typeName = typeRegistry.getType(ident);
    if (typeName == null) {
      // TODO(lukes): typo detection/suggestions would be nice here
      {if (true) throw LegacyInternalSyntaxException.createWithMetaInfo(
          "Unknown type '" + ident + "'.",
          sourceLocation);}
    }
    {if (true) return typeName;}
    throw new Error("Missing return statement in function");
  }

  final private SoyType UnknownType() throws ParseException {
    jj_consume_token(QMARK);
    {if (true) return UnknownType.getInstance();}
    throw new Error("Missing return statement in function");
  }

  final private String DottedIdent() throws ParseException {
  StringBuilder sb = new StringBuilder();
  Token ident;
    ident = jj_consume_token(IDENT);
    sb.append(ident.image);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_3;
      }
      jj_consume_token(DOT);
      ident = jj_consume_token(IDENT);
      sb.append('.');
      sb.append(ident.image);
    }
    {if (true) return sb.toString();}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public TypeParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[5];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x40,0x1e08,0x20,0x1000,0x100,};
   }

  /** Constructor with InputStream. */
  public TypeParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public TypeParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new TypeParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public TypeParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new TypeParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public TypeParser(TypeParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(TypeParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[15];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 5; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 15; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
