
package com.google.template.soy.jbcsrc;

import com.google.template.soy.jbcsrc.shared.TemplateMetadata;
import com.google.template.soy.jbcsrc.shared.TemplateMetadata.DelTemplateMetadata;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoAnnotationProcessor")
final class AutoAnnotation_TemplateCompiler_createTemplateMetadata implements TemplateMetadata {

  private final String contentKind;

  private final String[] injectedParams;

  private final String[] callees;

  private final String[] delCallees;

  private final DelTemplateMetadata deltemplateMetadata;

  AutoAnnotation_TemplateCompiler_createTemplateMetadata(
      String contentKind,
      Set<String> injectedParams,
      Set<String> callees,
      Set<String> delCallees,
      DelTemplateMetadata deltemplateMetadata) {
    if (contentKind == null) {
      throw new NullPointerException("Null contentKind");
    }
    this.contentKind = contentKind;
    if (injectedParams == null) {
      throw new NullPointerException("Null injectedParams");
    }
    this.injectedParams = injectedParams.toArray(new String[injectedParams.size()]);
    if (callees == null) {
      throw new NullPointerException("Null callees");
    }
    this.callees = callees.toArray(new String[callees.size()]);
    if (delCallees == null) {
      throw new NullPointerException("Null delCallees");
    }
    this.delCallees = delCallees.toArray(new String[delCallees.size()]);
    if (deltemplateMetadata == null) {
      throw new NullPointerException("Null deltemplateMetadata");
    }
    this.deltemplateMetadata = deltemplateMetadata;
  }

  @Override
  public Class<? extends TemplateMetadata> annotationType() {
    return TemplateMetadata.class;
  }

  @Override
  public String contentKind() {
    return contentKind;
  }

  @Override
  public String[] injectedParams() {
    return injectedParams.clone();
  }

  @Override
  public String[] callees() {
    return callees.clone();
  }

  @Override
  public String[] delCallees() {
    return delCallees.clone();
  }

  @Override
  public DelTemplateMetadata deltemplateMetadata() {
    return deltemplateMetadata;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("@com.google.template.soy.jbcsrc.shared.TemplateMetadata(");
    sb.append("contentKind=");
    appendQuoted(sb, contentKind);
    sb.append(", ");
    sb.append("injectedParams=");
    appendQuoted(sb, injectedParams);
    sb.append(", ");
    sb.append("callees=");
    appendQuoted(sb, callees);
    sb.append(", ");
    sb.append("delCallees=");
    appendQuoted(sb, delCallees);
    sb.append(", ");
    sb.append("deltemplateMetadata=");
    sb.append(deltemplateMetadata);
    return sb.append(')').toString();
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TemplateMetadata) {
      TemplateMetadata that = (TemplateMetadata) o;
      return (contentKind.equals(that.contentKind()))
           && (Arrays.equals(injectedParams,
        (that instanceof AutoAnnotation_TemplateCompiler_createTemplateMetadata)
            ? ((AutoAnnotation_TemplateCompiler_createTemplateMetadata) that).injectedParams
            : that.injectedParams()))
           && (Arrays.equals(callees,
        (that instanceof AutoAnnotation_TemplateCompiler_createTemplateMetadata)
            ? ((AutoAnnotation_TemplateCompiler_createTemplateMetadata) that).callees
            : that.callees()))
           && (Arrays.equals(delCallees,
        (that instanceof AutoAnnotation_TemplateCompiler_createTemplateMetadata)
            ? ((AutoAnnotation_TemplateCompiler_createTemplateMetadata) that).delCallees
            : that.delCallees()))
           && (deltemplateMetadata.equals(that.deltemplateMetadata()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    return
        ((127 * -389414995) ^ (contentKind.hashCode())) +
        ((127 * -380876906) ^ (Arrays.hashCode(injectedParams))) +
        ((127 * 548636853) ^ (Arrays.hashCode(callees))) +
        ((127 * 1117456938) ^ (Arrays.hashCode(delCallees))) +
        ((127 * -585523244) ^ (deltemplateMetadata.hashCode()));
    // -389414995 is "contentKind".hashCode()
    // -380876906 is "injectedParams".hashCode()
    // 548636853 is "callees".hashCode()
    // 1117456938 is "delCallees".hashCode()
    // -585523244 is "deltemplateMetadata".hashCode()
  }

  private static void appendQuoted(StringBuilder sb, String[] strings) {
    sb.append('[');
    String sep = "";
    for (String s : strings) {
      sb.append(sep);
      sep = ", ";
      appendQuoted(sb, s);
    }
    sb.append(']');
  }

  private static void appendQuoted(StringBuilder sb, String s) {
    sb.append('"');
    for (int i = 0; i < s.length(); i++) {
      appendEscaped(sb, s.charAt(i));
    }
    sb.append('"');
  }

  private static void appendEscaped(StringBuilder sb, char c) {
    switch (c) {
    case '\\':
    case '"':
    case '\'':
      sb.append('\\').append(c);
      break;
    case '\n':
      sb.append("\\n");
      break;
    case '\r':
      sb.append("\\r");
      break;
    case '\t':
      sb.append("\\t");
      break;
    default:
      if (c < 0x20) {
        sb.append(String.format("\\%03o", (int) c));
      } else if (c < 0x7f || Character.isLetter(c)) {
        sb.append(c);
      } else {
        sb.append(String.format("\\u%04x", (int) c));
      }
      break;
    }
  }
}
