/* Generated By:JavaCC: Do not edit this line. ExpressionParser.java */
package com.google.template.soy.exprparse;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprNode.OperatorNode;
import com.google.template.soy.exprtree.ExprNode.PrimitiveNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.internal.base.UnescapeUtils;

import java.io.StringReader;
import java.util.List;


/**
 * This parser's specification is in ExpressionParser.jj, which is read by JavaCC and transformed
 * into ExpressionParser.java. To modify this parser, please edit ExpressionParser.jj. Do not edit
 * ExpressionParser.java directly.
 *
 * <p> Important: Do not use outside of Soy code (treat as superpackage-private).
 *
 * <pre>
 * This parser parses several related things: variables, data references, globals, expression lists,
 * and expressions.
 *
 * A. Variable:
 *    + A dollar sign "$" followed by an identifier (no space between).
 *
 * B. Data reference:
 *    + The first part must be "$" followed by the first key name (no space between).
 *    + The first key name cannot be a number.
 *    + A variable will only have the first part. A data reference may have subsequent parts.
 *    + Subsequent parts may be:
 *       - A dot "." or question-dot "?." followed by a key name or array index (spaces between are
 *         allowed).
 *       - Brackets "[ ]" or question-brackets "?[ ]" with any expression inside the brackets (see
 *         below for definition of expression).
 *    + A special case is when the first key name is "ij". In this case, it's a reference to
 *      injected data, and the reference is considered to start from the second key (i.e. the second
 *      key actually becomes the first key in the parsed node).
 *    Examples:   $aaa   $ij.aaa   $aaa.bbb.0.ccc.12   $aaa[0]['bbb'].ccc   $aaa[$bbb + $ccc]
 *
 * C. Global:
 *    + One or more identifiers. If more than one, a dot "." is used to separate them.
 *    + Must not be preceded by a dollar sign "$".
 *    Examples:   AAA   aaa.bbb.CCC   a22.b88_
 *
 * D. Expression list:
 *    + A comma-separated list of one or more expressions (see below for definition of expression).
 *    Example:   $aaa, $bbb.ccc + 1, round(3.14)
 *
 * E. Expression:
 *
 *    1. Data reference:
 *       + See above for definition.
 *
 *    2. Global:
 *       + See above for definition.
 *
 *    3. Null:   null
 *
 *    4. Boolean:   false   true
 *
 *    5. Integer:
 *       + No octal numbers.
 *       + Hex numbers have strict lower case "x" in "0x" and "A-F" or "a-f".
 *       Examples:   0   26   -729   0x1a2B
 *
 *    6. Float:
 *       + Decimal numbers only.
 *       + Must have digits on both sides of decimal point.
 *       + Exponents have strict lower case "e".
 *       Examples:   0.0   3.14159   -20.0   6.03e23   -3e-3
 *
 *    7. String:
 *       + Single quotes only.
 *       + Escape sequences:   \\   \'   \"   \n   \r   \t   \b   \f
 *       + Unicode escape:   \ u ####   (backslash, "u", four hex digits -- no spaces in between)
 *       Examples:   ''   'abc'   'blah bleh bluh'   'aa\\bb\'cc\ndd'
 *
 *    8. List literal:
 *       + Delimited by brackets.
 *       Examples:   []   ['blah', 123, $foo]
 *
 *    9. Map literal:
 *       + Delimited by brackets.
 *       + Empty map has a single colon within the brackets (to distinguish from empty list).
 *       + Keys must be strings (or expressions that will evaluate to strings).
 *       Examples:   [:]   ['aaa': 'blah', 'bbb': 123, $boo: $foo]
 *
 *    10. Operators:
 *       + Parentheses can be used to override precedence rules:   ( )
 *       + Precedence 8:   - (unary)   not
 *       + Precedence 7:   *   /   %
 *       + Precedence 6:   +   - (binary)
 *       + Precedence 5:   <   >   <=   >=
 *       + Precedence 4:   ==   !=
 *       + Precedence 3:   and
 *       + Precedence 2:   or
 *       + Precedence 1:   ?: (binary)   ? : (ternary)
 *
 *    11. Functions:
 *       + Function name, open parenthesis, optional expression list, close parenthesis.
 *       + The function name is one identifier.
 *       + See above for the definition of an expression list.
 *       Examples:   isFirst($item)   foo()   myFunction(2, 'aa')
 * </pre>
 *
 */
public final class ExpressionParser implements ExpressionParserConstants {

  public static final SoyErrorKind INVALID_EXPRESSION_LIST
      = SoyErrorKind.of("Invalid expression list");
  private static final SoyErrorKind INVALID_PARAM_NAME_IJ
      = SoyErrorKind.of("Invalid param name ''ij'' (''ij'' is for injected data ref).");
  public static final SoyErrorKind INVALID_VAR_NAME
      = SoyErrorKind.of("Invalid var name ''{0}''");
  private static final SoyErrorKind INVALID_VAR_NAME_IJ
      = SoyErrorKind.of("Invalid var name ''ij'' (''ij'' is for injected data ref).");

  private static final SoyErrorKind SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL
      = SoyErrorKind.of("Disallowed single-identifier key \u005c"{0}\u005c" in map literal "
          + "(please surround with single quotes for string or parentheses for global).");

  private static final SoyErrorKind PARSE_ERROR = SoyErrorKind.of("{0}");

  private String input;
  private SourceLocation parentSourceLocation;
  private ErrorReporter errorReporter;

  private SoyParsingContext context;

  /**
   * Constructor that takes a string input.
   * @param input The input to parse.
   * @param parentSourceLocation the source location associated with the input.
   * @param errorReporter For reporting syntax errors.
   */
  public ExpressionParser(
      String input, SourceLocation parentSourceLocation, SoyParsingContext context) {
    this(new StringReader(input));
    this.input = input;
    this.parentSourceLocation = parentSourceLocation;
    this.errorReporter = context.errorReporter();
    this.context = context;
  }


  /**
   * Parses the input as a comma-separated list of expressions.
   *
   * <p>Maintains the following invariant: an empty list is returned if and only if
   * an error is reported to the parser's {@link ErrorReporter}.
   */
  public List<ExprNode> parseExpressionList() {
    try {
      return ExprListInput();
    } catch (ParseException e) {
      ParseErrors.reportExprParseException(errorReporter, parentSourceLocation, e);
      return ImmutableList.of();
    }
  }


  /**
   * Parses the input as an expression.
   *
   * <p>Maintains the following invariant: an error node is returned if and only if an error
   * is reported to the parser's {@link ErrorReporter}.
   */
  public ExprNode parseExpression() {
    try {
      return ExprInput();
    } catch (ParseException e) {
      ParseErrors.reportExprParseException(errorReporter, parentSourceLocation, e);
      return VarRefNode.ERROR;
    }
  }


  /**
   * Parses the input as a variable name.
   *
   * <p>Maintains the following invariant: an error node is returned if and only if an error
   * is reported to the parser's {@link ErrorReporter}.
   */
  public VarNode parseVariable() {
    try {
      return VarInput();
    } catch (ParseException e) {
      ParseErrors.reportExprParseException(errorReporter, "Expected a variable name ", parentSourceLocation, e);
      return VarNode.ERROR;
    }
  }

  /**
   * Private helper to create an operator node.
   */
  private static final OperatorNode createOperatorNode(
      String op, int prec, ExprNode ...children) {
    Operator operator = Operator.of(op, children.length);
    if (operator.getPrecedence() != prec) {
      throw new IllegalArgumentException("invalid precedence " + prec + " for operator " + op);
    }
    return operator.createNode(children);
  }

  private SourceLocation createSrcLoc(Token token) {
    // TODO(brndn): The Math.max fiddling is required because some callers instantiate
    // the expression parser with SourceLocation.UNKNOWN (for example, ExprParseUtils).
    return new SourceLocation(
        parentSourceLocation.getFilePath(),
        Math.max(1, parentSourceLocation.getLineNumber()),
        Math.max(1, parentSourceLocation.getBeginColumn() + token.beginColumn),
        Math.max(1, parentSourceLocation.getLineNumber()),
        Math.max(1, parentSourceLocation.getBeginColumn() + token.endColumn));
  }

  final private PrimitiveNode Primitive() throws ParseException {
  Token b, i, f, str;
    PrimitiveNode primitive;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
      primitive = new NullNode(SourceLocation.UNKNOWN /* TODO(brndn) */);
      break;
    case BOOLEAN:
      b = jj_consume_token(BOOLEAN);
      primitive = new BooleanNode(b.image.equals("true"), createSrcLoc(b));
      break;
    case INTEGER:
      i = jj_consume_token(INTEGER);
      if (i.image.startsWith("0x")) {
        primitive = new IntegerNode(Integer.parseInt(i.image.substring(2), 16), createSrcLoc(i));
      } else {
        primitive = new IntegerNode(Integer.parseInt(i.image, 10), createSrcLoc(i));
      }
      break;
    case FLOAT:
      f = jj_consume_token(FLOAT);
      primitive = new FloatNode(Double.parseDouble(f.image), createSrcLoc(f));
      break;
    case STRING:
      str = jj_consume_token(STRING);
      String strNoQuotes = str.image.substring(1, str.image.length() - 1);
      primitive = new StringNode(UnescapeUtils.unescapeJs(strNoQuotes), createSrcLoc(str));
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return primitive;}
    throw new Error("Missing return statement in function");
  }

  final private List<ExprNode> ExprListInput() throws ParseException {
  List<ExprNode> exprList;
    exprList = ExprList();
    List<ExprNode> rootedExprList = Lists.newArrayList();
    for (ExprNode expr : exprList) {
      rootedExprList.add(expr);
    }
    jj_consume_token(0);
    {if (true) return rootedExprList;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode ExprInput() throws ParseException {
  ExprNode expr;
    expr = Expr();
    jj_consume_token(0);
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private VarNode VarInput() throws ParseException {
  VarNode var;
    var = Var();
    jj_consume_token(0);
    {if (true) return var;}
    throw new Error("Missing return statement in function");
  }

  final private GlobalNode GlobalInput() throws ParseException {
  GlobalNode global;
    global = Global();
    jj_consume_token(0);
    {if (true) return global;}
    throw new Error("Missing return statement in function");
  }

  final private List<ExprNode> ExprList() throws ParseException {
  ExprNode expr;
    List<ExprNode> exprList = Lists.newArrayList();
    expr = Expr();
    exprList.add(expr);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 20:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      jj_consume_token(20);
      expr = Expr();
      exprList.add(expr);
    }
    {if (true) return exprList;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode Expr() throws ParseException {
  ExprNode expr;
    expr = PrecExpr1();
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr1() throws ParseException {
  ExprNode expr1, expr2;
    ExprNode expr;
    expr = PrecExpr2();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 21:
    case 22:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 21:
        jj_consume_token(21);
        expr1 = PrecExpr1();
      expr = Operator.NULL_COALESCING.createNode(expr, expr1);
        break;
      case 22:
        jj_consume_token(22);
        expr1 = PrecExpr1();
        jj_consume_token(23);
        expr2 = PrecExpr1();
      expr = Operator.CONDITIONAL.createNode(expr, expr1, expr2);
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr2() throws ParseException {
  ExprNode rightHand;
  Token op;
    ExprNode expr;
    expr = PrecExpr3();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECEDENCE_2_OP:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_2;
      }
      op = jj_consume_token(PRECEDENCE_2_OP);
      rightHand = PrecExpr3();
      expr = createOperatorNode(op.image, 2, expr, rightHand);
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr3() throws ParseException {
  ExprNode rightHand;
  Token op;
    ExprNode expr;
    expr = PrecExpr4();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECEDENCE_3_OP:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      op = jj_consume_token(PRECEDENCE_3_OP);
      rightHand = PrecExpr4();
      expr = createOperatorNode(op.image, 3, expr, rightHand);
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr4() throws ParseException {
  ExprNode rightHand;
  Token op;
    ExprNode expr;
    expr = PrecExpr5();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECEDENCE_4_OP:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      op = jj_consume_token(PRECEDENCE_4_OP);
      rightHand = PrecExpr5();
      expr = createOperatorNode(op.image, 4, expr, rightHand);
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr5() throws ParseException {
  ExprNode rightHand;
  Token op;
    ExprNode expr;
    expr = PrecExpr6();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECEDENCE_5_OP:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_5;
      }
      op = jj_consume_token(PRECEDENCE_5_OP);
      rightHand = PrecExpr6();
      expr = createOperatorNode(op.image, 5, expr, rightHand);
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr6() throws ParseException {
  ExprNode rightHand;
  Token op;
    ExprNode expr;
    expr = PrecExpr7();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECEDENCE_6_OP:
      case 24:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECEDENCE_6_OP:
        op = jj_consume_token(PRECEDENCE_6_OP);
        rightHand = PrecExpr7();
      expr = createOperatorNode(op.image, 6, expr, rightHand);
        break;
      case 24:
        jj_consume_token(24);
        rightHand = PrecExpr7();
      expr = Operator.MINUS.createNode(expr, rightHand);
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr7() throws ParseException {
  ExprNode rightHand;
  Token op;
    ExprNode expr;
    expr = PrecExpr8();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECEDENCE_7_OP:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_7;
      }
      op = jj_consume_token(PRECEDENCE_7_OP);
      rightHand = PrecExpr8();
      expr = createOperatorNode(op.image, 7, expr, rightHand);
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr8() throws ParseException {
  Token unaryOp;
    ExprNode expr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
    case BOOLEAN:
    case INTEGER:
    case FLOAT:
    case STRING:
    case IDENT:
    case DOLLAR_IDENT:
    case 25:
    case 28:
    case 30:
      expr = PrecExpr9();
      break;
    case UNARY_OP:
      unaryOp = jj_consume_token(UNARY_OP);
      expr = PrecExpr8();
    expr = createOperatorNode(unaryOp.image, 8, expr);
      break;
    case 24:
      jj_consume_token(24);
      expr = PrecExpr8();
      expr = Operator.NEGATIVE.createNode(expr);
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr9() throws ParseException {
  Token tok;
  ExprNode keyExpr;
  Token op;
      ExprNode expr;
    expr = Primary();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT_IDENT:
      case QUESTION_DOT_IDENT:
      case 25:
      case 27:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_8;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT_IDENT:
        tok = jj_consume_token(DOT_IDENT);
         expr = new FieldAccessNode(expr, tok.image.substring(1), false) /* null safe */;
        break;
      case QUESTION_DOT_IDENT:
        tok = jj_consume_token(QUESTION_DOT_IDENT);
         expr = new FieldAccessNode(expr, tok.image.substring(2), true /* null safe */);
        break;
      case 25:
        jj_consume_token(25);
        keyExpr = Expr();
        jj_consume_token(26);
         expr = new ItemAccessNode(expr, keyExpr, false /* null safe */);
        break;
      case 27:
        jj_consume_token(27);
        keyExpr = Expr();
        jj_consume_token(26);
         expr = new ItemAccessNode(expr, keyExpr, true /* null safe */);
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode Primary() throws ParseException {
    ExprNode primary;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 28:
      jj_consume_token(28);
      primary = Expr();
      jj_consume_token(29);
      break;
    default:
      jj_la1[14] = jj_gen;
      if (jj_2_1(2147483647)) {
        primary = FunctionCall();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOLLAR_IDENT:
        case 30:
          primary = DataRef();
          break;
        case IDENT:
          primary = Global();
          break;
        default:
          jj_la1[15] = jj_gen;
          if (jj_2_2(2147483647)) {
            primary = ListLiteral();
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case 25:
              primary = MapLiteral();
              break;
            case NULL:
            case BOOLEAN:
            case INTEGER:
            case FLOAT:
            case STRING:
              primary = Primitive();
              break;
            default:
              jj_la1[16] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
    {if (true) return primary;}
    throw new Error("Missing return statement in function");
  }

  final private VarNode Var() throws ParseException {
  Token dollarIdent;
    dollarIdent = jj_consume_token(DOLLAR_IDENT);
    String identStr = dollarIdent.image.substring(1);
    if (identStr.equals("ij")) {
      errorReporter.report(createSrcLoc(dollarIdent), INVALID_VAR_NAME_IJ);
    }
    {if (true) return new VarNode(identStr, createSrcLoc(dollarIdent));}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode DataRef() throws ParseException {
  Token ident;
  VarNode varNode;
  ExprNode expr;
    ExprNode dataRef;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 30:
      jj_consume_token(30);
      ident = jj_consume_token(IDENT);
      dataRef = new VarRefNode(ident.image, createSrcLoc(ident), true, null);
      break;
    case DOLLAR_IDENT:
      varNode = Var();
      dataRef = new VarRefNode(varNode.getName(), varNode.getSourceLocation(), false, null);
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return dataRef;}
    throw new Error("Missing return statement in function");
  }

  final private GlobalNode Global() throws ParseException {
  Token ident;
  SourceLocation loc;
     StringBuilder globalNameSb = new StringBuilder();
    ident = jj_consume_token(IDENT);
    loc = createSrcLoc(ident);
    globalNameSb.append(context.resolveAlias(ident.image));
    label_9:
    while (true) {
      if (jj_2_3(2)) {
        ;
      } else {
        break label_9;
      }
      ident = jj_consume_token(DOT_IDENT);
      loc = loc.extend(createSrcLoc(ident));
      globalNameSb.append(ident.image);
    }
    {if (true) return new GlobalNode(globalNameSb.toString(), loc);}
    throw new Error("Missing return statement in function");
  }

  final private FunctionNode FunctionCall() throws ParseException {
  Token ident;
  List<ExprNode> exprList;
    ident = jj_consume_token(IDENT);
    jj_consume_token(28);
    exprList = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
    case BOOLEAN:
    case INTEGER:
    case FLOAT:
    case STRING:
    case UNARY_OP:
    case IDENT:
    case DOLLAR_IDENT:
    case 24:
    case 25:
    case 28:
    case 30:
      exprList = ExprList();
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    jj_consume_token(29);
    FunctionNode fnNode = new FunctionNode(ident.image, createSrcLoc(ident));
    if (exprList != null) {
      fnNode.addChildren(exprList);
    }
    {if (true) return fnNode;}
    throw new Error("Missing return statement in function");
  }

  final private ListLiteralNode ListLiteral() throws ParseException {
  ExprNode itemExpr;
    List<ExprNode> items = Lists.newArrayList();
    jj_consume_token(25);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
    case BOOLEAN:
    case INTEGER:
    case FLOAT:
    case STRING:
    case UNARY_OP:
    case IDENT:
    case DOLLAR_IDENT:
    case 24:
    case 25:
    case 28:
    case 30:
      itemExpr = Expr();
      items.add(itemExpr);
      label_10:
      while (true) {
        if (jj_2_4(2147483647)) {
          ;
        } else {
          break label_10;
        }
        jj_consume_token(20);
        itemExpr = Expr();
        items.add(itemExpr);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 20:
        jj_consume_token(20);
        break;
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    jj_consume_token(26);
    {if (true) return new ListLiteralNode(items, SourceLocation.UNKNOWN /* TODO(brndn) */);}
    throw new Error("Missing return statement in function");
  }

  final private MapLiteralNode MapLiteral() throws ParseException {
  Token ident;
  ExprNode keyExpr, valueExpr;
  SourceLocation begin, end;
    List<ExprNode> alternatingKeysAndValues = Lists.newArrayList();
    jj_consume_token(25);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 23:
      jj_consume_token(23);
      break;
    case NULL:
    case BOOLEAN:
    case INTEGER:
    case FLOAT:
    case STRING:
    case UNARY_OP:
    case IDENT:
    case DOLLAR_IDENT:
    case 24:
    case 25:
    case 28:
    case 30:
      if (jj_2_5(2147483647)) {
        ident = jj_consume_token(IDENT);
        errorReporter.report(
            createSrcLoc(ident), SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL, ident.image);
      } else {
        ;
      }
      keyExpr = Expr();
      alternatingKeysAndValues.add(keyExpr);
      jj_consume_token(23);
      valueExpr = Expr();
      alternatingKeysAndValues.add(valueExpr);
      label_11:
      while (true) {
        if (jj_2_6(2147483647)) {
          ;
        } else {
          break label_11;
        }
        jj_consume_token(20);
        if (jj_2_7(2147483647)) {
          ident = jj_consume_token(IDENT);
          errorReporter.report(
              createSrcLoc(ident), SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL, ident.image);
        } else {
          ;
        }
        keyExpr = Expr();
        alternatingKeysAndValues.add(keyExpr);
        jj_consume_token(23);
        valueExpr = Expr();
        alternatingKeysAndValues.add(valueExpr);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 20:
        jj_consume_token(20);
        break;
      default:
        jj_la1[21] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(26);
    {if (true) return new MapLiteralNode(alternatingKeysAndValues, SourceLocation.UNKNOWN /* TODO(brndn) */);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_3R_47() {
    if (jj_scan_token(QUESTION_DOT_IDENT)) return true;
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_3R_27()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_28()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(20)) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_scan_token(DOT_IDENT)) return true;
    return false;
  }

  private boolean jj_3R_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_3R_37()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_38()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(20)) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_scan_token(30)) return true;
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_20() {
    if (jj_scan_token(22)) return true;
    if (jj_3R_14()) return true;
    if (jj_scan_token(23)) return true;
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_scan_token(PRECEDENCE_5_OP)) return true;
    if (jj_3R_25()) return true;
    return false;
  }

  private boolean jj_3R_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    }
    return false;
  }

  private boolean jj_3R_19() {
    if (jj_scan_token(21)) return true;
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_16() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) return true;
    }
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_3R_13()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_68()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(20)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_3R_25()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_26()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_scan_token(25)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) jj_scanpos = xsp;
    if (jj_scan_token(26)) return true;
    return false;
  }

  private boolean jj_3R_14() {
    if (jj_3R_15()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_16()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_scan_token(24)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_12() {
    if (jj_3R_13()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) return true;
    }
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_scan_token(DOLLAR_IDENT)) return true;
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_scan_token(PRECEDENCE_4_OP)) return true;
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_scan_token(UNARY_OP)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_scan_token(IDENT)) return true;
    if (jj_scan_token(23)) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3R_29() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_3R_23()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_24()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_6() {
    if (jj_scan_token(20)) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_scan_token(25)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_3R_12()) return true;
    }
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_scan_token(IDENT)) return true;
    if (jj_scan_token(28)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) jj_scanpos = xsp;
    if (jj_scan_token(29)) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_scan_token(IDENT)) return true;
    if (jj_scan_token(28)) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(20)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) jj_scanpos = xsp;
    if (jj_3R_13()) return true;
    if (jj_scan_token(23)) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_scan_token(IDENT)) return true;
    if (jj_scan_token(23)) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_scan_token(PRECEDENCE_3_OP)) return true;
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_scan_token(PRECEDENCE_7_OP)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_13() {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_17() {
    if (jj_3R_21()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_22()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_3R_29()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_30()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_3() {
    if (jj_scan_token(DOT_IDENT)) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_scan_token(28)) return true;
    if (jj_3R_13()) return true;
    if (jj_scan_token(29)) return true;
    return false;
  }

  private boolean jj_3R_60() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) jj_scanpos = xsp;
    if (jj_3R_13()) return true;
    if (jj_scan_token(23)) return true;
    if (jj_3R_13()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_70()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(20)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_37() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_scan_token(20)) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_scan_token(25)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    }
    if (jj_scan_token(26)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_scan_token(24)) return true;
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_scan_token(PRECEDENCE_2_OP)) return true;
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_3R_13()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_71()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_scan_token(27)) return true;
    if (jj_3R_13()) return true;
    if (jj_scan_token(26)) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_scan_token(IDENT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_3()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) return true;
    }
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_scan_token(PRECEDENCE_6_OP)) return true;
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_15() {
    if (jj_3R_17()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_18()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_scan_token(25)) return true;
    if (jj_3R_13()) return true;
    if (jj_scan_token(26)) return true;
    return false;
  }

  private boolean jj_3R_63() {
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ExpressionParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[23];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x3e,0x100000,0x600000,0x600000,0x200,0x400,0x800,0x1000,0x1002000,0x1002000,0x4000,0x5301813e,0xa060000,0xa060000,0x10000000,0x40018000,0x200003e,0x40010000,0x5301813e,0x100000,0x5301813e,0x100000,0x5381813e,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public ExpressionParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public ExpressionParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new ExpressionParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 23; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 23; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ExpressionParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ExpressionParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 23; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 23; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ExpressionParser(ExpressionParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 23; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ExpressionParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 23; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[36];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 23; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 36; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 7; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
