/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class SoyFileNode
extends AbstractParentSoyNode<TemplateNode>
implements SoyNode.SplitLevelTopNode<TemplateNode> {
    private static final SoyErrorKind ALIAS_USED_WITHOUT_NAMESPACE = SoyErrorKind.of("''{alias...'' can only be used in files with valid ''{namespace ...'' declarations");
    private static final SoyErrorKind INVALID_ALIAS_FOR_LAST_PART_OF_NAMESPACE = SoyErrorKind.of("Not allowed to alias the last part of the file''s namespace ({0}) to another namespace ({1}).");
    private static final SoyErrorKind DIFFERENT_NAMESPACES_WITH_SAME_ALIAS = SoyErrorKind.of("Found two namespaces with the same alias (''{0}'' and ''{1}'').");
    public static final Predicate<SoyFileNode> MATCH_SRC_FILENODE = new Predicate<SoyFileNode>(){

        public boolean apply(@Nullable SoyFileNode input) {
            return input != null && input.getSoyFileKind() == SoyFileKind.SRC;
        }
    };
    private final SoyFileKind soyFileKind;
    @Nullable
    private final String delPackageName;
    private final NamespaceDeclaration namespaceDeclaration;
    private final ImmutableMap<String, String> aliasToNamespaceMap;

    public SoyFileNode(int id, String filePath, SoyFileKind soyFileKind, ErrorReporter errorReporter, @Nullable String delPackageName, NamespaceDeclaration namespaceDeclaration, Collection<AliasDeclaration> aliases) {
        super(id, new SourceLocation(filePath));
        this.soyFileKind = soyFileKind;
        this.delPackageName = delPackageName;
        this.namespaceDeclaration = namespaceDeclaration;
        LinkedHashMap tempAliasToNamespaceMap = Maps.newLinkedHashMap();
        String aliasForFileNamespace = namespaceDeclaration.isDefined() ? BaseUtils.extractPartAfterLastDot(namespaceDeclaration.getNamespace()) : null;
        for (AliasDeclaration aliasDeclaration : aliases) {
            if (!namespaceDeclaration.isDefined()) {
                errorReporter.report(aliasDeclaration.getLocation(), ALIAS_USED_WITHOUT_NAMESPACE, new Object[0]);
            }
            String aliasNamespace = aliasDeclaration.getNamespace();
            String alias = aliasDeclaration.getAlias();
            if (alias.equals(aliasForFileNamespace) && !aliasNamespace.equals(namespaceDeclaration.getNamespace())) {
                errorReporter.report(aliasDeclaration.getLocation(), INVALID_ALIAS_FOR_LAST_PART_OF_NAMESPACE, namespaceDeclaration.getNamespace(), aliasNamespace);
            }
            if (tempAliasToNamespaceMap.containsKey(alias)) {
                errorReporter.report(this.getSourceLocation(), DIFFERENT_NAMESPACES_WITH_SAME_ALIAS, tempAliasToNamespaceMap.get(alias), aliasNamespace);
            }
            tempAliasToNamespaceMap.put(alias, aliasNamespace);
        }
        this.aliasToNamespaceMap = ImmutableMap.copyOf((Map)tempAliasToNamespaceMap);
    }

    private SoyFileNode(SoyFileNode orig, CopyState copyState) {
        super(orig, copyState);
        this.soyFileKind = orig.soyFileKind;
        this.delPackageName = orig.delPackageName;
        this.namespaceDeclaration = orig.namespaceDeclaration;
        this.aliasToNamespaceMap = orig.aliasToNamespaceMap;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SOY_FILE_NODE;
    }

    public SoyFileKind getSoyFileKind() {
        return this.soyFileKind;
    }

    @Nullable
    public String getDelPackageName() {
        return this.delPackageName;
    }

    @Nullable
    public String getNamespace() {
        return this.namespaceDeclaration.getNamespace();
    }

    public AutoescapeMode getDefaultAutoescapeMode() {
        return this.namespaceDeclaration.getDefaultAutoescapeMode();
    }

    public ImmutableList<String> getRequiredCssNamespaces() {
        return this.namespaceDeclaration.getRequiredCssNamespaces();
    }

    @Nullable
    public String getCssBaseNamespace() {
        return this.namespaceDeclaration.getCssBaseNamespace();
    }

    public ImmutableMap<String, String> getAliasToNamespaceMap() {
        return this.aliasToNamespaceMap;
    }

    public String getFilePath() {
        return this.getSourceLocation().getFilePath();
    }

    @Nullable
    public String getFileName() {
        return this.getSourceLocation().getFileName();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        if (this.delPackageName != null) {
            sb.append("{delpackage ").append(this.delPackageName).append("}\n");
        }
        if (this.namespaceDeclaration.isDefined()) {
            sb.append("{namespace ").append(this.namespaceDeclaration.getNamespace());
            if (this.namespaceDeclaration.getAutoescapeMode().isPresent()) {
                sb.append(" autoescape=\"").append(((AutoescapeMode)((Object)this.namespaceDeclaration.getAutoescapeMode().get())).getAttributeValue()).append("\"");
            }
            sb.append("}\n");
        }
        if (!this.aliasToNamespaceMap.isEmpty()) {
            sb.append("\n");
            for (Map.Entry entry : this.aliasToNamespaceMap.entrySet()) {
                String alias = (String)entry.getKey();
                String aliasNamespace = (String)entry.getValue();
                if (aliasNamespace.equals(alias) || aliasNamespace.endsWith("." + alias)) {
                    sb.append("{alias ").append(aliasNamespace).append("}\n");
                    continue;
                }
                sb.append("{alias ").append(aliasNamespace).append(" as ").append(alias).append("}\n");
            }
        }
        for (SoyNode child : this.getChildren()) {
            sb.append("\n");
            sb.append(child.toSourceString());
        }
        return sb.toString();
    }

    @Override
    public SoyFileSetNode getParent() {
        return (SoyFileSetNode)super.getParent();
    }

    @Override
    public SoyFileNode copy(CopyState copyState) {
        return new SoyFileNode(this, copyState);
    }
}

