/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.AbstractErrorReporter;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AutoValue_ExprUnion_DelayedErrorReport;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class ExprUnion {
    @Nullable
    private final ExprRootNode expr;
    @Nullable
    private final String exprText;
    private final ImmutableList<DelayedErrorReport> delayedErrorReports;

    static ExprUnion parseWithV1Fallback(String exprText, SourceLocation location) {
        DelayedErrorReporter errorReporter = new DelayedErrorReporter();
        ErrorReporter.Checkpoint checkpoint = errorReporter.checkpoint();
        ExprNode expr = new ExpressionParser(exprText, location, errorReporter).parseExpression();
        return errorReporter.errorsSince(checkpoint) ? new ExprUnion(exprText, errorReporter.reports) : new ExprUnion(expr);
    }

    public static List<ExprUnion> createList(List<? extends ExprRootNode> exprs) {
        ArrayList exprUnions = Lists.newArrayListWithCapacity((int)exprs.size());
        for (ExprRootNode exprRootNode : exprs) {
            exprUnions.add(new ExprUnion(exprRootNode));
        }
        return exprUnions;
    }

    public ExprUnion(ExprNode expr) {
        this(new ExprRootNode(expr));
    }

    public ExprUnion(ExprRootNode expr) {
        this.expr = expr;
        this.exprText = null;
        this.delayedErrorReports = ImmutableList.of();
    }

    private ExprUnion(String exprTextV1, List<DelayedErrorReport> delayedErrorReports) {
        Preconditions.checkArgument((!delayedErrorReports.isEmpty() ? 1 : 0) != 0);
        this.expr = null;
        this.exprText = exprTextV1;
        this.delayedErrorReports = ImmutableList.copyOf(delayedErrorReports);
    }

    private ExprUnion(ExprUnion orig, CopyState copyState) {
        this.expr = orig.expr != null ? orig.expr.copy(copyState) : null;
        this.exprText = orig.exprText;
        this.delayedErrorReports = orig.delayedErrorReports;
    }

    public ExprRootNode getExpr() {
        return this.expr;
    }

    public String getExprText() {
        return this.expr != null ? this.expr.toSourceString() : this.exprText;
    }

    public ExprUnion copy(CopyState copyState) {
        return new ExprUnion(this, copyState);
    }

    public void reportV2ParseErrors(ErrorReporter reporter) {
        for (DelayedErrorReport report : this.delayedErrorReports) {
            reporter.report(report.location(), report.error(), report.args().toArray());
        }
    }

    static abstract class DelayedErrorReport {
        DelayedErrorReport() {
        }

        abstract SourceLocation location();

        abstract SoyErrorKind error();

        abstract List<?> args();
    }

    private static final class DelayedErrorReporter
    extends AbstractErrorReporter {
        final List<DelayedErrorReport> reports = new ArrayList<DelayedErrorReport>();

        private DelayedErrorReporter() {
        }

        @Override
        public void report(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
            this.reports.add(new AutoValue_ExprUnion_DelayedErrorReport(sourceLocation, error, (List<?>)ImmutableList.copyOf((Object[])args)));
        }

        @Override
        protected int getCurrentNumberOfErrors() {
            return this.reports.size();
        }
    }
}

