/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.soytree.SoyFileNode;
import java.io.File;
import javax.annotation.Nullable;

public class MainEntryPointUtils {
    private MainEntryPointUtils() {
    }

    public static Multimap<String, Integer> mapOutputsToSrcs(@Nullable String locale, String outputPathFormat, String inputPathsPrefix, ImmutableList<SoyFileNode> fileNodes) {
        ArrayListMultimap outputs = ArrayListMultimap.create();
        for (int i = 0; i < fileNodes.size(); ++i) {
            SoyFileNode inputFile = (SoyFileNode)fileNodes.get(i);
            String inputFilePath = inputFile.getFilePath();
            String outputFilePath = MainEntryPointUtils.buildFilePath(outputPathFormat, locale, inputFilePath, inputPathsPrefix);
            BaseUtils.ensureDirsExistInPath(outputFilePath);
            outputs.put((Object)outputFilePath, (Object)i);
        }
        return outputs;
    }

    public static String buildFilePath(String filePathFormat, @Nullable String locale, @Nullable String inputFilePath, String inputPathPrefix) {
        String path = filePathFormat;
        if (locale != null) {
            path = path.replace("{LOCALE}", locale);
            path = path.replace("{LOCALE_LOWER_CASE}", locale.toLowerCase().replace('-', '_'));
        }
        path = path.replace("{INPUT_PREFIX}", inputPathPrefix);
        if (inputFilePath != null) {
            inputFilePath = inputFilePath.substring(inputPathPrefix.length());
            int lastSlashIndex = inputFilePath.lastIndexOf(File.separatorChar);
            String directory = inputFilePath.substring(0, lastSlashIndex + 1);
            String fileName = inputFilePath.substring(lastSlashIndex + 1);
            int lastDotIndex = fileName.lastIndexOf(46);
            if (lastDotIndex == -1) {
                lastDotIndex = fileName.length();
            }
            String fileNameNoExt = fileName.substring(0, lastDotIndex);
            path = path.replace("{INPUT_DIRECTORY}", directory);
            path = path.replace("{INPUT_FILE_NAME}", fileName);
            path = path.replace("{INPUT_FILE_NAME_NO_EXT}", fileNameNoExt);
        }
        path = path.replaceAll("//", "/");
        return path;
    }
}

