/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyListExpr;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.shared.internal.CodeBuilder;
import java.util.List;

final class PyCodeBuilder
extends CodeBuilder<PyExpr> {
    PyCodeBuilder() {
    }

    @Override
    public void initOutputVarIfNecessary() {
        if (this.getOutputVarIsInited()) {
            return;
        }
        this.appendLine(this.getOutputVarName(), " = []");
        this.setOutputVarInited();
    }

    @Override
    public void addToOutputVar(List<? extends PyExpr> pyExprs) {
        this.addToOutputVar(PyExprUtils.concatPyExprs(pyExprs));
    }

    public void addToOutputVar(PyExpr pyExpr) {
        boolean isList = pyExpr instanceof PyListExpr;
        if (isList && !this.getOutputVarIsInited()) {
            this.appendLine(this.getOutputVarName(), " = ", pyExpr.getText());
        } else {
            this.initOutputVarIfNecessary();
            String function = isList ? ".extend(" : ".append(";
            this.appendLine(this.getOutputVarName(), function, pyExpr.getText(), ")");
        }
        this.setOutputVarInited();
    }

    public PyStringExpr getOutputAsString() {
        Preconditions.checkState((this.getOutputVarName() != null ? 1 : 0) != 0);
        this.initOutputVarIfNecessary();
        return new PyListExpr(this.getOutputVarName(), Integer.MAX_VALUE).toPyString();
    }
}

