/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsCodeUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyObjectType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.primitive.UnknownType;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class TranslateToJsExprVisitor
extends AbstractReturningExprNodeVisitor<JsExpr> {
    private static final SoyErrorKind CONSTANT_USED_AS_KEY_IN_MAP_LITERAL = SoyErrorKind.of("Keys in map literals cannot be constants (found constant ''{0}'').");
    private static final SoyErrorKind EXPR_IN_MAP_LITERAL_REQUIRES_QUOTE_KEYS_IF_JS = SoyErrorKind.of("Expression key ''{0}'' in map literal must be wrapped in quoteKeysIfJs().");
    private static final SoyErrorKind MAP_LITERAL_WITH_NON_ID_KEY_REQUIRES_QUOTE_KEYS_IF_JS = SoyErrorKind.of("Map literal with non-identifier key {0} must be wrapped in quoteKeysIfJs().");
    private static final SoyErrorKind SOY_JS_SRC_FUNCTION_NOT_FOUND = SoyErrorKind.of("Failed to find SoyJsSrcFunction ''{0}''.");
    private static final SoyErrorKind UNION_ACCESSOR_MISMATCH = SoyErrorKind.of("Cannot access field ''{0}'' of type ''{1}'', because the different union member types have different access methods.");
    private static final JsExpr ERROR = new JsExpr("(function() { throw new Error('Soy compilation failed'); })();", Integer.MAX_VALUE);
    private final SoyJsSrcOptions jsSrcOptions;
    private final Deque<Map<String, JsExpr>> localVarTranslations;
    private final ErrorReporter errorReporter;

    @AssistedInject
    TranslateToJsExprVisitor(SoyJsSrcOptions jsSrcOptions, @Assisted Deque<Map<String, JsExpr>> localVarTranslations, @Assisted ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.jsSrcOptions = jsSrcOptions;
        this.localVarTranslations = localVarTranslations;
    }

    static String genCodeForParamAccess(String paramName, boolean isInjected, SoyType type) {
        return TranslateToJsExprVisitor.genCodeForKeyAccess(UnknownType.getInstance(), type, isInjected ? "opt_ijData" : "opt_data", paramName);
    }

    @Override
    protected JsExpr visitExprRootNode(ExprRootNode node) {
        return (JsExpr)this.visit(node.getRoot());
    }

    @Override
    protected JsExpr visitStringNode(StringNode node) {
        return new JsExpr(BaseUtils.escapeToSoyString(node.getValue(), true), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        return new JsExpr(node.toSourceString(), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitListLiteralNode(ListLiteralNode node) {
        StringBuilder exprTextSb = new StringBuilder();
        exprTextSb.append('[');
        boolean isFirst = true;
        for (ExprNode child : node.getChildren()) {
            if (isFirst) {
                isFirst = false;
            } else {
                exprTextSb.append(", ");
            }
            exprTextSb.append(((JsExpr)this.visit(child)).getText());
        }
        exprTextSb.append(']');
        return new JsExpr(exprTextSb.toString(), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitMapLiteralNode(MapLiteralNode node) {
        return this.visitMapLiteralNodeHelper(node, false);
    }

    private JsExpr visitMapLiteralNodeHelper(MapLiteralNode node, boolean doQuoteKeys) {
        StringBuilder strKeysEntriesSnippet = new StringBuilder();
        StringBuilder nonstrKeysEntriesSnippet = new StringBuilder();
        boolean isProbablyUsingClosureCompiler = this.jsSrcOptions.shouldGenerateJsdoc() || this.jsSrcOptions.shouldProvideRequireSoyNamespaces() || this.jsSrcOptions.shouldProvideRequireJsFunctions();
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        int n = node.numChildren();
        for (int i = 0; i < n; i += 2) {
            ExprNode keyNode = node.getChild(i);
            ExprNode valueNode = node.getChild(i + 1);
            if (keyNode instanceof StringNode) {
                if (strKeysEntriesSnippet.length() > 0) {
                    strKeysEntriesSnippet.append(", ");
                }
                if (doQuoteKeys) {
                    strKeysEntriesSnippet.append(((JsExpr)this.visit(keyNode)).getText());
                } else {
                    String key = ((StringNode)keyNode).getValue();
                    if (BaseUtils.isIdentifier(key)) {
                        strKeysEntriesSnippet.append(key);
                    } else if (isProbablyUsingClosureCompiler) {
                        this.errorReporter.report(keyNode.getSourceLocation(), MAP_LITERAL_WITH_NON_ID_KEY_REQUIRES_QUOTE_KEYS_IF_JS, keyNode.toSourceString());
                    } else {
                        strKeysEntriesSnippet.append(((JsExpr)this.visit(keyNode)).getText());
                    }
                }
                strKeysEntriesSnippet.append(": ").append(((JsExpr)this.visit(valueNode)).getText());
                continue;
            }
            if (keyNode instanceof ExprNode.ConstantNode) {
                this.errorReporter.report(keyNode.getSourceLocation(), CONSTANT_USED_AS_KEY_IN_MAP_LITERAL, keyNode.toSourceString());
                continue;
            }
            if (isProbablyUsingClosureCompiler && !doQuoteKeys) {
                this.errorReporter.report(keyNode.getSourceLocation(), EXPR_IN_MAP_LITERAL_REQUIRES_QUOTE_KEYS_IF_JS, keyNode.toSourceString());
                return ERROR;
            }
            nonstrKeysEntriesSnippet.append(" map_s[soy.$$checkMapKey(").append(((JsExpr)this.visit(keyNode)).getText()).append(")] = ").append(((JsExpr)this.visit(valueNode)).getText()).append(';');
        }
        String fullExprText = nonstrKeysEntriesSnippet.length() == 0 ? "{" + strKeysEntriesSnippet + "}" : "(function() { var map_s = {" + strKeysEntriesSnippet + "};" + nonstrKeysEntriesSnippet + " return map_s; })()";
        return this.errorReporter.errorsSince(checkpoint) ? ERROR : new JsExpr(fullExprText, Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitVarRefNode(VarRefNode node) {
        return this.visitNullSafeNode(node);
    }

    @Override
    protected JsExpr visitDataAccessNode(DataAccessNode node) {
        return this.visitNullSafeNode(node);
    }

    private JsExpr visitNullSafeNode(ExprNode node) {
        StringBuilder nullSafetyPrefix = new StringBuilder();
        String refText = this.visitNullSafeNodeRecurse(node, nullSafetyPrefix);
        if (nullSafetyPrefix.length() == 0) {
            return new JsExpr(refText, Integer.MAX_VALUE);
        }
        return new JsExpr(nullSafetyPrefix + refText, Operator.CONDITIONAL.getPrecedence());
    }

    private String visitNullSafeNodeRecurse(ExprNode node, StringBuilder nullSafetyPrefix) {
        switch (node.getKind()) {
            case VAR_REF_NODE: {
                VarRefNode varRef = (VarRefNode)node;
                if (varRef.isDollarSignIjParameter()) {
                    SoyType type = node.getType();
                    return TranslateToJsExprVisitor.genCodeForKeyAccess(UnknownType.getInstance(), type, "opt_ijData", varRef.getName());
                }
                JsExpr translation = this.getLocalVarTranslation(varRef.getName());
                if (translation != null) {
                    return translation.getText();
                }
                String scope = "opt_data";
                VarDefn var = varRef.getDefnDecl();
                if (var.kind() == VarDefn.Kind.PARAM && ((TemplateParam)var).isInjected()) {
                    scope = "opt_ijData";
                }
                SoyType type = node.getType();
                return TranslateToJsExprVisitor.genCodeForKeyAccess(UnknownType.getInstance(), type, scope, varRef.getName());
            }
            case FIELD_ACCESS_NODE: 
            case ITEM_ACCESS_NODE: {
                DataAccessNode dataAccess = (DataAccessNode)node;
                String refText = this.visitNullSafeNodeRecurse(dataAccess.getBaseExprChild(), nullSafetyPrefix);
                if (dataAccess.isNullSafe()) {
                    nullSafetyPrefix.append("(" + refText + " == null) ? null : ");
                }
                if (node.getKind() == ExprNode.Kind.FIELD_ACCESS_NODE) {
                    FieldAccessNode fieldAccess = (FieldAccessNode)node;
                    return this.genCodeForFieldAccess(fieldAccess.getBaseExprChild().getType(), fieldAccess, refText, fieldAccess.getFieldName());
                }
                ItemAccessNode itemAccess = (ItemAccessNode)node;
                if (itemAccess.getKeyExprChild() instanceof IntegerNode) {
                    return refText + "[" + ((IntegerNode)itemAccess.getKeyExprChild()).getValue() + "]";
                }
                JsExpr keyJsExpr = (JsExpr)this.visit(itemAccess.getKeyExprChild());
                return refText + "[" + keyJsExpr.getText() + "]";
            }
        }
        JsExpr value = (JsExpr)this.visit(node);
        return TranslateToJsExprVisitor.genMaybeProtect(value, Integer.MAX_VALUE);
    }

    static String genCodeForKeyAccess(SoyType containerType, SoyType memberType, String containerExpr, String key) {
        Preconditions.checkNotNull((Object)containerType);
        Preconditions.checkNotNull((Object)memberType);
        return containerExpr + (JsSrcUtils.isReservedWord(key) ? "['" + key + "']" : "." + key);
    }

    private String genCodeForFieldAccess(SoyType baseType, FieldAccessNode fieldAccessNode, String containerExpr, String fieldName) {
        SoyObjectType objType;
        String accessExpr;
        Preconditions.checkNotNull((Object)baseType);
        SoyType fieldType = fieldAccessNode.getType();
        Preconditions.checkNotNull((Object)fieldType);
        if (baseType.getKind() == SoyType.Kind.UNION) {
            UnionType unionType = (UnionType)baseType;
            String fieldAccessCode = null;
            for (SoyType memberType : unionType.getMembers()) {
                if (memberType.getKind() == SoyType.Kind.NULL) continue;
                String fieldAccessForType = this.genCodeForFieldAccess(memberType, fieldAccessNode, containerExpr, fieldName);
                if (fieldAccessCode == null) {
                    fieldAccessCode = fieldAccessForType;
                    continue;
                }
                if (fieldAccessCode.equals(fieldAccessForType)) continue;
                this.errorReporter.report(fieldAccessNode.getSourceLocation(), UNION_ACCESSOR_MISMATCH, fieldName, baseType);
            }
            return fieldAccessCode;
        }
        if (baseType.getKind() == SoyType.Kind.OBJECT && (accessExpr = (objType = (SoyObjectType)baseType).getFieldAccessExpr(containerExpr, fieldName, SoyBackendKind.JS_SRC)) != null) {
            return accessExpr;
        }
        return TranslateToJsExprVisitor.genCodeForKeyAccess(baseType, fieldType, containerExpr, fieldName);
    }

    @Override
    protected JsExpr visitGlobalNode(GlobalNode node) {
        return new JsExpr(node.toSourceString(), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitNotOpNode(OperatorNodes.NotOpNode node) {
        return this.genJsExprUsingSoySyntaxWithNewToken(node, "!");
    }

    @Override
    protected JsExpr visitAndOpNode(OperatorNodes.AndOpNode node) {
        return this.genJsExprUsingSoySyntaxWithNewToken(node, "&&");
    }

    @Override
    protected JsExpr visitOrOpNode(OperatorNodes.OrOpNode node) {
        return this.genJsExprUsingSoySyntaxWithNewToken(node, "||");
    }

    @Override
    protected JsExpr visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        List operandJsExprs = this.visitChildren(node);
        return new JsExpr("($$temp = " + ((JsExpr)operandJsExprs.get(0)).getText() + ") == null ? " + ((JsExpr)operandJsExprs.get(1)).getText() + " : $$temp", Operator.CONDITIONAL.getPrecedence());
    }

    @Override
    protected JsExpr visitOperatorNode(ExprNode.OperatorNode node) {
        return this.genJsExprUsingSoySyntax(node);
    }

    @Override
    protected JsExpr visitFunctionNode(FunctionNode node) {
        SoyFunction soyFunction = node.getSoyFunction();
        if (soyFunction instanceof BuiltinFunction) {
            switch ((BuiltinFunction)soyFunction) {
                case IS_FIRST: {
                    return this.visitIsFirstFunction(node);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(node);
                }
                case INDEX: {
                    return this.visitIndexFunction(node);
                }
                case QUOTE_KEYS_IF_JS: {
                    return this.visitMapLiteralNodeHelper((MapLiteralNode)node.getChild(0), true);
                }
                case CHECK_NOT_NULL: {
                    return this.visitCheckNotNullFunction(node.getChild(0));
                }
            }
            throw new AssertionError();
        }
        if (soyFunction instanceof SoyJsSrcFunction) {
            List<JsExpr> args = this.visitChildren(node);
            return ((SoyJsSrcFunction)soyFunction).computeForJsSrc(args);
        }
        this.errorReporter.report(node.getSourceLocation(), SOY_JS_SRC_FUNCTION_NOT_FOUND, node.getFunctionName());
        return ERROR;
    }

    private JsExpr visitCheckNotNullFunction(ExprNode child) {
        return new JsExpr("soy.$$checkNotNull(" + ((JsExpr)this.visit(child)).getText() + ")", Integer.MAX_VALUE);
    }

    private JsExpr visitIsFirstFunction(FunctionNode node) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.getLocalVarTranslation(varName + "__isFirst");
    }

    private JsExpr visitIsLastFunction(FunctionNode node) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.getLocalVarTranslation(varName + "__isLast");
    }

    private JsExpr visitIndexFunction(FunctionNode node) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.getLocalVarTranslation(varName + "__index");
    }

    private JsExpr getLocalVarTranslation(String ident) {
        for (Map<String, JsExpr> localVarTranslationsFrame : this.localVarTranslations) {
            JsExpr translation = localVarTranslationsFrame.get(ident);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }

    private JsExpr genJsExprUsingSoySyntax(ExprNode.OperatorNode opNode) {
        return this.genJsExprUsingSoySyntaxWithNewToken(opNode, null);
    }

    private JsExpr genJsExprUsingSoySyntaxWithNewToken(ExprNode.OperatorNode opNode, String newToken) {
        List<JsExpr> operandJsExprs = this.visitChildren(opNode);
        return SoyJsCodeUtils.genJsExprUsingSoySyntaxWithNewToken(opNode.getOperator(), operandJsExprs, newToken);
    }

    public static String genMaybeProtect(JsExpr expr, int minSafePrecedence) {
        return expr.getPrecedence() >= minSafePrecedence ? expr.getText() : "(" + expr.getText() + ")";
    }

    public static interface TranslateToJsExprVisitorFactory {
        public TranslateToJsExprVisitor create(Deque<Map<String, JsExpr>> var1, ErrorReporter var2);
    }
}

