/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.primitive.BoolType;
import com.google.template.soy.types.primitive.FloatType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.NullType;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.primitive.UnknownType;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

class SoyExpression
extends Expression {
    private static final ImmutableSet<SoyType.Kind> STRING_KINDS = Sets.immutableEnumSet((Enum)SoyType.Kind.STRING, (Enum[])new SoyType.Kind[]{SoyType.Kind.HTML, SoyType.Kind.ATTRIBUTES, SoyType.Kind.JS, SoyType.Kind.CSS, SoyType.Kind.URI});
    static final SoyExpression NULL = new SoyExpression(NullType.getInstance(), Object.class, new Expression(BytecodeUtils.OBJECT.type(), Expression.Feature.CHEAP, new Expression.Feature[0]){

        @Override
        void doGen(CodeBuilder adapter) {
            adapter.visitInsn(1);
        }
    });
    static final SoyExpression TRUE = new SoyExpression((SoyType)BoolType.getInstance(), (Class)Boolean.TYPE, BytecodeUtils.constant(true)){

        @Override
        SoyExpression box() {
            return new DefaultBoxed((SoyType)BoolType.getInstance(), this, FieldRef.BOOLEAN_DATA_TRUE.accessor(), (Optional<Expression>)Optional.absent());
        }
    };
    static final SoyExpression FALSE = new SoyExpression((SoyType)BoolType.getInstance(), (Class)Boolean.TYPE, BytecodeUtils.constant(false)){

        @Override
        SoyExpression box() {
            return new DefaultBoxed((SoyType)BoolType.getInstance(), this, FieldRef.BOOLEAN_DATA_FALSE.accessor(), (Optional<Expression>)Optional.absent());
        }
    };
    private final Class<?> clazz;
    private final SoyType soyType;
    private final Expression delegate;
    private final Optional<Expression> renderContext;

    static SoyExpression forSoyValue(SoyType type, Expression delegate) {
        return new SoyExpression(type, type.javaType(), delegate, (Optional<Expression>)Optional.absent());
    }

    static SoyExpression forBool(Expression delegate) {
        return new SoyExpression(BoolType.getInstance(), Boolean.TYPE, delegate);
    }

    static SoyExpression forFloat(Expression delegate) {
        return new SoyExpression(FloatType.getInstance(), Double.TYPE, delegate);
    }

    static SoyExpression forInt(Expression delegate) {
        return new SoyExpression(IntType.getInstance(), Long.TYPE, delegate);
    }

    static SoyExpression forString(Expression delegate) {
        return new SoyExpression(StringType.getInstance(), String.class, delegate);
    }

    static SoyExpression forSanitizedString(Expression delegate, SanitizedContent.ContentKind kind) {
        return new SoyExpression(SanitizedType.getTypeForContentKind(kind), String.class, delegate);
    }

    static SoyExpression forList(ListType listType, Expression delegate) {
        return new SoyExpression(listType, List.class, delegate);
    }

    static Expression asBoxedList(List<SoyExpression> items) {
        ArrayList<SoyExpression> childExprs = new ArrayList<SoyExpression>(items.size());
        for (SoyExpression child : items) {
            childExprs.add(child.box());
        }
        return BytecodeUtils.asList(childExprs);
    }

    private SoyExpression(SoyType soyType, Class<?> clazz, Expression delegate) {
        this(soyType, clazz, delegate, (Optional<Expression>)Optional.absent());
    }

    private SoyExpression(SoyType soyType, Class<?> clazz, Expression delegate, Optional<Expression> renderContext) {
        super(delegate.resultType(), delegate.features());
        Preconditions.checkArgument((boolean)clazz.isAssignableFrom(BytecodeUtils.classFromAsmType(delegate.resultType())), (String)"delegate with type %s isn't compatible with asserted SoyExpression type %s", (Object[])new Object[]{delegate.resultType(), clazz});
        if (SoyValue.class.isAssignableFrom(clazz) && !soyType.javaType().isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not compatible with soy type: " + soyType);
        }
        this.soyType = soyType;
        this.clazz = clazz;
        this.delegate = delegate;
        this.renderContext = renderContext;
    }

    final SoyType soyType() {
        return this.soyType;
    }

    @Override
    final void doGen(CodeBuilder adapter) {
        this.delegate.gen(adapter);
    }

    boolean isKnownString() {
        return this.soyType.getKind() == SoyType.Kind.STRING;
    }

    boolean isKnownStringOrSanitizedContent() {
        return STRING_KINDS.contains((Object)this.soyType.getKind());
    }

    boolean isKnownSanitizedContent() {
        return this.soyType.getKind() != SoyType.Kind.STRING && STRING_KINDS.contains((Object)this.soyType.getKind());
    }

    boolean isKnownInt() {
        return this.soyType.getKind() == SoyType.Kind.INT;
    }

    boolean assignableToNullableInt() {
        return this.assignableToNullableType(IntType.getInstance());
    }

    boolean assignableToNullableFloat() {
        return this.assignableToNullableType(FloatType.getInstance());
    }

    boolean assignableToNullableNumber() {
        return this.assignableToNullableType(SoyTypes.NUMBER_TYPE);
    }

    private boolean assignableToNullableType(SoyType type) {
        return type.isAssignableFrom(this.soyType) || this.soyType.getKind() == SoyType.Kind.UNION && type.isAssignableFrom(SoyTypes.removeNull(this.soyType));
    }

    boolean isKnownFloat() {
        return this.soyType.getKind() == SoyType.Kind.FLOAT;
    }

    boolean isKnownList() {
        return this.soyType.getKind() == SoyType.Kind.LIST;
    }

    boolean isKnownMap() {
        return this.soyType.getKind() == SoyType.Kind.MAP;
    }

    boolean isKnownRecord() {
        return this.soyType.getKind() == SoyType.Kind.RECORD;
    }

    boolean isKnownBool() {
        return this.soyType.getKind() == SoyType.Kind.BOOL;
    }

    boolean isBoxed() {
        return SoyValue.class.isAssignableFrom(this.clazz);
    }

    final boolean isKnownNumber() {
        return SoyTypes.NUMBER_TYPE.isAssignableFrom(this.soyType);
    }

    SoyExpression box() {
        if (this.isBoxed()) {
            return this;
        }
        if (this.soyType.equals(NullType.getInstance())) {
            return this;
        }
        if (!this.delegate.isNonNullable()) {
            final Label end = new Label();
            return this.withSource(new Expression(this.resultType(), this.features()){

                @Override
                void doGen(CodeBuilder adapter) {
                    SoyExpression.this.delegate.gen(adapter);
                    adapter.dup();
                    adapter.ifNull(end);
                }
            }).asNonNullable().box().asNullable().labelEnd(end);
        }
        if (this.isKnownBool()) {
            return this.asBoxed(MethodRef.BOOLEAN_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.isKnownInt()) {
            return this.asBoxed(MethodRef.INTEGER_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.isKnownFloat()) {
            return this.asBoxed(MethodRef.FLOAT_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.isKnownSanitizedContent()) {
            return this.asBoxed(MethodRef.ORDAIN_AS_SAFE.invoke(this.delegate, FieldRef.enumReference(((SanitizedType)this.soyType).getContentKind()).accessor()));
        }
        if (this.isKnownString()) {
            return this.asBoxed(MethodRef.STRING_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.isKnownList()) {
            return this.asBoxed(MethodRef.LIST_IMPL_FOR_PROVIDER_LIST.invoke(this.delegate));
        }
        throw new IllegalStateException("cannot box soy expression of type " + this.soyType + " with runtime type " + this.clazz);
    }

    private DefaultBoxed asBoxed(Expression expr) {
        return new DefaultBoxed(this.soyType, this, expr, this.renderContext);
    }

    SoyExpression coerceToBoolean() {
        if (BytecodeUtils.isPrimitive(this.resultType())) {
            return this.coercePrimitiveToBoolean();
        }
        if (this.soyType.equals(NullType.getInstance())) {
            return FALSE;
        }
        if (this.delegate.isNonNullable()) {
            return this.coerceNonNullableReferenceTypeToBoolean();
        }
        final Label end = new Label();
        return this.withSource(new Expression(this.delegate.resultType(), this.delegate.features()){

            @Override
            void doGen(CodeBuilder adapter) {
                SoyExpression.this.delegate.gen(adapter);
                adapter.dup();
                Label nonNull = new Label();
                adapter.ifNonNull(nonNull);
                adapter.pop();
                adapter.pushBoolean(false);
                adapter.goTo(end);
                adapter.mark(nonNull);
            }
        }).asNonNullable().coerceToBoolean().labelEnd(end);
    }

    private SoyExpression coercePrimitiveToBoolean() {
        if (this.resultType().equals((Object)Type.BOOLEAN_TYPE)) {
            return this;
        }
        if (this.resultType().equals((Object)Type.DOUBLE_TYPE)) {
            return SoyExpression.forBool(MethodRef.RUNTIME_COERCE_DOUBLE_TO_BOOLEAN.invoke(this.delegate));
        }
        if (this.resultType().equals((Object)Type.LONG_TYPE)) {
            return SoyExpression.forBool(BytecodeUtils.compare(154, this.delegate, BytecodeUtils.constant(0L)));
        }
        throw new AssertionError((Object)("resultType(): " + this.resultType() + " is not a valid type for a SoyExpression"));
    }

    private SoyExpression coerceNonNullableReferenceTypeToBoolean() {
        if (this.isBoxed()) {
            return SoyExpression.forBool(this.delegate.invoke(MethodRef.SOY_VALUE_COERCE_TO_BOOLEAN, new Expression[0]));
        }
        if (this.clazz.equals(String.class)) {
            return SoyExpression.forBool(BytecodeUtils.logicalNot(this.delegate.invoke(MethodRef.STRING_IS_EMPTY, new Expression[0])));
        }
        return SoyExpression.forBool(new Expression(Type.BOOLEAN_TYPE, this.delegate.features()){

            @Override
            void doGen(CodeBuilder adapter) {
                SoyExpression.this.delegate.gen(adapter);
                adapter.pop();
                adapter.pushBoolean(true);
            }
        });
    }

    SoyExpression coerceToString() {
        if (this.clazz.equals(String.class)) {
            return this;
        }
        if (BytecodeUtils.isPrimitive(this.resultType())) {
            if (this.resultType().equals((Object)Type.BOOLEAN_TYPE)) {
                return SoyExpression.forString(MethodRef.BOOLEAN_TO_STRING.invoke(this.delegate));
            }
            if (this.resultType().equals((Object)Type.DOUBLE_TYPE)) {
                return SoyExpression.forString(MethodRef.DOUBLE_TO_STRING.invoke(this.delegate));
            }
            if (this.resultType().equals((Object)Type.LONG_TYPE)) {
                return SoyExpression.forString(MethodRef.LONG_TO_STRING.invoke(this.delegate));
            }
            throw new AssertionError((Object)("resultType(): " + this.resultType() + " is not a valid type for a SoyExpression"));
        }
        if (!this.isBoxed()) {
            return SoyExpression.forString(MethodRef.STRING_VALUE_OF.invoke(this.delegate));
        }
        return SoyExpression.forString(MethodRef.RUNTIME_COERCE_TO_STRING.invoke(this.delegate));
    }

    SoyExpression coerceToDouble() {
        if (this.clazz.equals(Double.TYPE)) {
            return this;
        }
        if (this.clazz.equals(Long.TYPE)) {
            return SoyExpression.forFloat(BytecodeUtils.numericConversion(this.delegate, Type.DOUBLE_TYPE));
        }
        if (!this.isBoxed()) {
            throw new UnsupportedOperationException("Can't convert " + this.resultType() + " to a double");
        }
        if (this.isKnownFloat()) {
            return SoyExpression.forFloat(this.delegate.invoke(MethodRef.SOY_VALUE_FLOAT_VALUE, new Expression[0]));
        }
        return SoyExpression.forFloat(this.delegate.invoke(MethodRef.SOY_VALUE_NUMBER_VALUE, new Expression[0]));
    }

    SoyExpression unboxAs(Class<?> asType) {
        Preconditions.checkArgument((!SoyValue.class.isAssignableFrom(asType) ? 1 : 0) != 0, (String)"Cannot use convert() to convert to a  SoyValue: %s, use .box() instead", (Object[])new Object[]{asType});
        if (asType.equals(this.clazz)) {
            return this;
        }
        if (!this.isBoxed()) {
            throw new IllegalStateException("Trying to unbox an unboxed value (" + this.clazz + ") doesn't make sense, " + "should you be using a type coercion? e.g. .coerceToBoolean()");
        }
        if (asType.equals(Boolean.TYPE)) {
            return SoyExpression.forBool(this.delegate.invoke(MethodRef.SOY_VALUE_BOOLEAN_VALUE, new Expression[0]));
        }
        if (asType.equals(Long.TYPE)) {
            return SoyExpression.forInt(this.delegate.invoke(MethodRef.SOY_VALUE_LONG_VALUE, new Expression[0]));
        }
        if (asType.equals(Double.TYPE)) {
            return SoyExpression.forFloat(this.delegate.invoke(MethodRef.SOY_VALUE_FLOAT_VALUE, new Expression[0]));
        }
        if (this.delegate.isNonNullable()) {
            if (asType.equals(String.class)) {
                Expression unboxedString = this.delegate.invoke(MethodRef.SOY_VALUE_STRING_VALUE, new Expression[0]);
                return this.isKnownSanitizedContent() ? SoyExpression.forSanitizedString(unboxedString, ((SanitizedType)this.soyType).getContentKind()) : SoyExpression.forString(unboxedString);
            }
            if (asType.equals(List.class)) {
                return this.unboxAsList();
            }
        } else {
            final Label ifNull = new Label();
            Expression nonNullDelegate = new Expression(this.resultType(), this.features()){

                @Override
                void doGen(CodeBuilder adapter) {
                    SoyExpression.this.delegate.gen(adapter);
                    adapter.dup();
                    adapter.ifNull(ifNull);
                }
            };
            final SoyExpression unboxAs = this.withSource(nonNullDelegate).asNonNullable().unboxAs(asType);
            return unboxAs.withSource(new Expression(unboxAs.resultType(), this.features()){

                @Override
                void doGen(CodeBuilder adapter) {
                    unboxAs.gen(adapter);
                    adapter.mark(ifNull);
                    adapter.checkCast(unboxAs.resultType());
                }
            });
        }
        throw new UnsupportedOperationException("Can't unbox " + this.clazz + " as " + asType);
    }

    private SoyExpression unboxAsList() {
        ListType asListType;
        if (this.isKnownList()) {
            asListType = (ListType)this.soyType;
        } else {
            SoyType.Kind kind = this.soyType.getKind();
            if (kind == SoyType.Kind.UNKNOWN) {
                asListType = ListType.of(UnknownType.getInstance());
            } else {
                throw new UnsupportedOperationException("Cannot convert " + this.soyType + " to List");
            }
        }
        return SoyExpression.forList(asListType, this.delegate.cast(BytecodeUtils.SOY_LIST_TYPE).invoke(MethodRef.SOY_LIST_AS_JAVA_LIST, new Expression[0]));
    }

    Optional<SoyExpression> tryUnbox() {
        if (!this.isBoxed()) {
            return Optional.of((Object)this);
        }
        switch (this.soyType.getKind()) {
            case OBJECT: 
            case RECORD: 
            case UNKNOWN: 
            case ANY: 
            case MAP: {
                return Optional.absent();
            }
            case CSS: 
            case ATTRIBUTES: 
            case HTML: 
            case JS: 
            case URI: 
            case STRING: {
                return Optional.of((Object)this.unboxAs(String.class));
            }
            case BOOL: {
                return Optional.of((Object)this.unboxAs(Boolean.TYPE));
            }
            case ENUM: 
            case INT: {
                return Optional.of((Object)this.unboxAs(Long.TYPE));
            }
            case UNION: {
                return Optional.absent();
            }
            case FLOAT: {
                return Optional.of((Object)this.unboxAs(Double.TYPE));
            }
            case LIST: {
                return Optional.of((Object)this.unboxAs(List.class));
            }
            case NULL: {
                return Optional.of((Object)NULL);
            }
        }
        throw new AssertionError();
    }

    SoyExpression withSource(Expression expr) {
        return new SoyExpression(this.soyType, this.clazz, expr, this.renderContext);
    }

    SoyExpression applyPrintDirective(Expression renderContext, String directive) {
        return this.applyPrintDirective(renderContext, directive, MethodRef.IMMUTABLE_LIST_OF.invoke(new Expression[0]));
    }

    SoyExpression applyPrintDirective(Expression renderContext, String directive, Expression argsList) {
        return SoyExpression.forSoyValue(UnknownType.getInstance(), MethodRef.RUNTIME_APPLY_PRINT_DIRECTIVE.invoke(renderContext.invoke(MethodRef.RENDER_CONTEXT_GET_PRINT_DIRECTIVE, BytecodeUtils.constant(directive)), this.box(), argsList));
    }

    @Override
    SoyExpression asCheap() {
        return this.withSource(this.delegate.asCheap());
    }

    @Override
    SoyExpression asNonNullable() {
        return new SoyExpression(SoyTypes.removeNull(this.soyType), this.clazz, this.delegate.asNonNullable(), this.renderContext);
    }

    @Override
    public SoyExpression asNullable() {
        return new SoyExpression(SoyTypes.makeNullable(this.soyType), this.clazz, this.delegate.asNullable(), this.renderContext);
    }

    @Override
    SoyExpression labelStart(Label label) {
        return this.withSource(this.delegate.labelStart(label));
    }

    @Override
    SoyExpression labelEnd(Label label) {
        return this.withSource(this.delegate.labelEnd(label));
    }

    private static final class DefaultBoxed
    extends SoyExpression {
        private final SoyExpression unboxed;

        DefaultBoxed(SoyType soyType, SoyExpression unboxed, Expression delegate, Optional<Expression> expr) {
            super(soyType, soyType.javaType(), delegate, expr);
            this.unboxed = unboxed;
        }

        @Override
        final SoyExpression unboxAs(Class<?> asType) {
            return this.unboxed.unboxAs(asType);
        }

        @Override
        Optional<SoyExpression> tryUnbox() {
            return Optional.of((Object)this.unboxed);
        }

        @Override
        SoyExpression coerceToBoolean() {
            return this.unboxed.coerceToBoolean();
        }

        @Override
        SoyExpression coerceToString() {
            return this.unboxed.coerceToString();
        }

        @Override
        SoyExpression coerceToDouble() {
            return this.unboxed.coerceToDouble();
        }

        @Override
        final SoyExpression box() {
            return this;
        }
    }
}

