/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.jbcsrc.AbstractMemoryClassLoader;
import com.google.template.soy.jbcsrc.ClassData;

final class MemoryClassLoader
extends AbstractMemoryClassLoader {
    private final ImmutableMap<String, ClassData> classesByName;

    MemoryClassLoader(Iterable<ClassData> classes) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ClassData classData : classes) {
            builder.put((Object)classData.type().className(), (Object)classData);
        }
        this.classesByName = builder.build();
    }

    @Override
    ClassData getClassData(String name) {
        return (ClassData)this.classesByName.get((Object)name);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

