/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bidifunctions;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
class BidiEndEdgeFunction
implements SoyJavaFunction,
SoyJsSrcFunction,
SoyPySrcFunction {
    private final Provider<BidiGlobalDir> bidiGlobalDirProvider;

    @Inject
    BidiEndEdgeFunction(Provider<BidiGlobalDir> bidiGlobalDirProvider) {
        this.bidiGlobalDirProvider = bidiGlobalDirProvider;
    }

    @Override
    public String getName() {
        return "bidiEndEdge";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        return StringData.forValue(((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getStaticValue() < 0 ? "left" : "right");
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        BidiGlobalDir bidiGlobalDir = (BidiGlobalDir)this.bidiGlobalDirProvider.get();
        if (bidiGlobalDir.isStaticValue()) {
            return new JsExpr(bidiGlobalDir.getStaticValue() < 0 ? "'left'" : "'right'", Integer.MAX_VALUE);
        }
        return new JsExpr("(" + bidiGlobalDir.getCodeSnippet() + ") < 0 ? 'left' : 'right'", Operator.CONDITIONAL.getPrecedence());
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        BidiGlobalDir bidiGlobalDir = (BidiGlobalDir)this.bidiGlobalDirProvider.get();
        return new PyExpr("'left' if (" + bidiGlobalDir.getCodeSnippet() + ") < 0 else 'right'", PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL));
    }
}

