/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.data.internalutils.InternalValueUtils;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.error.ExplodingErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.VarRefNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;

public final class SoyUtils {
    private static final Pattern COMPILE_TIME_GLOBAL_LINE = Pattern.compile("([a-zA-Z_][a-zA-Z_0-9.]*) \\s* = \\s* (.+)", 4);

    private SoyUtils() {
    }

    public static void generateCompileTimeGlobalsFile(Map<String, ?> compileTimeGlobalsMap, Appendable output) throws IOException {
        ImmutableMap<String, PrimitiveData> compileTimeGlobals = InternalValueUtils.convertCompileTimeGlobalsMap(compileTimeGlobalsMap);
        for (Map.Entry entry : compileTimeGlobals.entrySet()) {
            String valueSrcStr = InternalValueUtils.convertPrimitiveDataToExpr((PrimitiveData)entry.getValue()).toSourceString();
            output.append((CharSequence)entry.getKey()).append(" = ").append(valueSrcStr).append("\n");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static ImmutableMap<String, PrimitiveData> parseCompileTimeGlobals(CharSource inputSource) throws IOException {
        compileTimeGlobalsBuilder = ImmutableMap.builder();
        errorReporter = ExplodingErrorReporter.get();
        reader = new BufferedReader(inputSource.openStream());
        var4_4 = null;
        try {
            lineNum = 1;
            line = reader.readLine();
            while (line != null) {
                block22: {
                    block23: {
                        if (line.startsWith("//") || line.trim().length() == 0) break block22;
                        sourceLocation = new SourceLocation("globals", lineNum, 1, lineNum, 1);
                        matcher = SoyUtils.COMPILE_TIME_GLOBAL_LINE.matcher(line);
                        if (matcher.matches()) break block23;
                        errorReporter.report(sourceLocation, CompileTimeGlobalsFileErrors.INVALID_FORMAT, new Object[]{line});
                        break block22;
                    }
                    name = matcher.group(1);
                    valueText = matcher.group(2).trim();
                    valueExpr = new ExpressionParser(valueText, sourceLocation, errorReporter).parseExpression();
                    if (!(valueExpr instanceof OperatorNodes.NegativeOpNode)) ** GOTO lbl-1000
                    childExpr = ((OperatorNodes.NegativeOpNode)valueExpr).getChild(0);
                    if (childExpr instanceof IntegerNode) {
                        compileTimeGlobalsBuilder.put((Object)name, (Object)IntegerData.forValue(-((IntegerNode)childExpr).getValue()));
                    } else if (childExpr instanceof FloatNode) {
                        compileTimeGlobalsBuilder.put((Object)name, (Object)FloatData.forValue(-((FloatNode)childExpr).getValue()));
                    } else if (!(valueExpr instanceof ExprNode.PrimitiveNode)) {
                        if (valueExpr instanceof GlobalNode || valueExpr instanceof VarRefNode) {
                            errorReporter.report(sourceLocation, CompileTimeGlobalsFileErrors.INVALID_VALUE, new Object[]{line});
                        } else {
                            errorReporter.report(sourceLocation, CompileTimeGlobalsFileErrors.NON_PRIMITIVE_VALUE, new Object[]{line});
                        }
                    } else {
                        compileTimeGlobalsBuilder.put((Object)name, (Object)InternalValueUtils.convertPrimitiveExprToData((ExprNode.PrimitiveNode)valueExpr));
                    }
                }
                line = reader.readLine();
                ++lineNum;
            }
        }
        catch (Throwable var5_7) {
            var4_4 = var5_7;
            throw var5_7;
        }
        finally {
            if (reader != null) {
                if (var4_4 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable var5_6) {
                        var4_4.addSuppressed(var5_6);
                    }
                } else {
                    reader.close();
                }
            }
        }
        return compileTimeGlobalsBuilder.build();
    }

    private static final class CompileTimeGlobalsFileErrors {
        static final SoyErrorKind INVALID_FORMAT = SoyErrorKind.of("Invalid line format: {0}");
        static final SoyErrorKind INVALID_VALUE = SoyErrorKind.of("Invalid value: {0}");
        static final SoyErrorKind NON_PRIMITIVE_VALUE = SoyErrorKind.of("Non-primitive value: {0}");

        private CompileTimeGlobalsFileErrors() {
        }
    }
}

