/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.TransitionalThrowingErrorReporter;
import com.google.template.soy.soytree.AbstractBlockNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class MsgHtmlTagNode
extends AbstractBlockNode
implements SoyNode.MsgPlaceholderInitialNode {
    private static final Pattern PHNAME_ATTR_PATTERN = Pattern.compile("\\s phname=\" ( [^\"]* ) \"", 4);
    private static final Pattern TAG_NAME_PATTERN = Pattern.compile("(?<= ^< ) /? [a-zA-Z0-9]+", 4);
    private static final Map<String, String> LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP = ImmutableMap.builder().put((Object)"a", (Object)"link").put((Object)"br", (Object)"break").put((Object)"b", (Object)"bold").put((Object)"i", (Object)"italic").put((Object)"li", (Object)"item").put((Object)"ol", (Object)"ordered_list").put((Object)"ul", (Object)"unordered_list").put((Object)"p", (Object)"paragraph").put((Object)"img", (Object)"image").put((Object)"em", (Object)"emphasis").build();
    private final String lcTagName;
    private final boolean isSelfEnding;
    private final boolean isOnlyRawText;
    @Nullable
    private final String fullTagText;
    @Nullable
    private final String userSuppliedPlaceholderName;

    private MsgHtmlTagNode(int id, String userSuppliedPlaceholderName, String lcTagName, boolean isSelfEnding, boolean isOnlyRawText, String fullTagText, List<SoyNode.StandaloneNode> children) {
        super(id);
        this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
        this.lcTagName = lcTagName;
        this.isSelfEnding = isSelfEnding;
        this.isOnlyRawText = isOnlyRawText;
        this.fullTagText = fullTagText;
        this.addChildren(children);
    }

    protected MsgHtmlTagNode(MsgHtmlTagNode orig) {
        super(orig);
        this.lcTagName = orig.lcTagName;
        this.isSelfEnding = orig.isSelfEnding;
        this.isOnlyRawText = orig.isOnlyRawText;
        this.fullTagText = orig.fullTagText;
        this.userSuppliedPlaceholderName = orig.userSuppliedPlaceholderName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_HTML_TAG_NODE;
    }

    public String getLcTagName() {
        return this.lcTagName;
    }

    @Nullable
    public String getFullTagText() {
        return this.fullTagText;
    }

    @Override
    public String getUserSuppliedPhName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    public String genBasePhName() {
        String basePlaceholderName;
        String baseLcTagName;
        boolean isEndTag;
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        if (this.lcTagName.startsWith("/")) {
            isEndTag = true;
            baseLcTagName = this.lcTagName.substring(1);
        } else {
            isEndTag = false;
            baseLcTagName = this.lcTagName;
        }
        String string = basePlaceholderName = LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP.containsKey(baseLcTagName) ? LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP.get(baseLcTagName) : baseLcTagName;
        if (isEndTag) {
            basePlaceholderName = "end_" + basePlaceholderName;
        } else if (!this.isSelfEnding) {
            basePlaceholderName = "start_" + basePlaceholderName;
        }
        return basePlaceholderName.toUpperCase();
    }

    @Override
    public Object genSamenessKey() {
        return this.isOnlyRawText ? Pair.of(this.userSuppliedPlaceholderName, this.fullTagText) : Integer.valueOf(this.getId());
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        this.appendSourceStringForChildren(sb);
        if (this.userSuppliedPlaceholderName != null) {
            int indexBeforeClose;
            if (this.isSelfEnding ? !sb.substring(indexBeforeClose = sb.length() - 2).equals("/>") : !sb.substring(indexBeforeClose = sb.length() - 1).equals(">")) {
                throw new AssertionError();
            }
            sb.insert(indexBeforeClose, " phname=\"" + this.userSuppliedPlaceholderName + "\"");
        }
        return sb.toString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public MsgHtmlTagNode clone() {
        return new MsgHtmlTagNode(this);
    }

    public static final class Builder {
        public static final MsgHtmlTagNode ERROR = new Builder(-1, (ImmutableList<SoyNode.StandaloneNode>)ImmutableList.of((Object)new RawTextNode(-1, "<body/>")), SourceLocation.UNKNOWN).buildAndThrowIfInvalid();
        private final int id;
        private ImmutableList<SoyNode.StandaloneNode> children;
        private final SourceLocation sourceLocation;

        public Builder(int id, ImmutableList<SoyNode.StandaloneNode> children, SourceLocation sourceLocation) {
            this.id = id;
            this.children = children;
            this.sourceLocation = sourceLocation;
        }

        public MsgHtmlTagNode build(ErrorReporter errorReporter) {
            ErrorReporter.Checkpoint checkpoint = errorReporter.checkpoint();
            String userSuppliedPlaceholderName = this.computePlaceholderName(errorReporter);
            String lcTagName = this.computeLcTagName(errorReporter);
            boolean selfEnding = this.isSelfEnding();
            boolean isOnlyRawText = this.children.size() == 1;
            String fullTagText = this.computeFullTagText();
            if (errorReporter.errorsSince(checkpoint)) {
                return ERROR;
            }
            MsgHtmlTagNode node = new MsgHtmlTagNode(this.id, userSuppliedPlaceholderName, lcTagName, selfEnding, isOnlyRawText, fullTagText, (List)this.children);
            node.setSourceLocation(this.sourceLocation);
            return node;
        }

        private boolean isSelfEnding() {
            int numChildren = this.children.size();
            String lastChildText = ((RawTextNode)this.children.get(numChildren - 1)).getRawText();
            return lastChildText.endsWith("/>");
        }

        private String computeFullTagText() {
            String fullTagText = null;
            if (this.children.size() == 1) {
                StringBuilder fullTagTextSb = new StringBuilder();
                for (SoyNode.StandaloneNode child : this.children) {
                    fullTagTextSb.append(child.toSourceString());
                }
                fullTagText = fullTagTextSb.toString();
            }
            return fullTagText;
        }

        private String computeLcTagName(ErrorReporter errorReporter) {
            String firstChildText = ((RawTextNode)this.children.get(0)).getRawText();
            Matcher matcher = TAG_NAME_PATTERN.matcher(firstChildText);
            if (!matcher.find()) {
                if (firstChildText.startsWith("<!--")) {
                    errorReporter.report(SoySyntaxException.createWithMetaInfo("Found HTML comment within 'msg' block: " + firstChildText, this.sourceLocation));
                } else {
                    errorReporter.report(SoySyntaxException.createWithMetaInfo("HTML tag within 'msg' block has no tag name: " + firstChildText, this.sourceLocation));
                }
            }
            return matcher.group().toLowerCase(Locale.ENGLISH);
        }

        @Nullable
        private String computePlaceholderName(ErrorReporter errorReporter) {
            ArrayList<String> names = new ArrayList<String>();
            ImmutableList.Builder transformedChildren = new ImmutableList.Builder();
            for (SoyNode.StandaloneNode child : this.children) {
                transformedChildren.add((Object)Builder.extractPlaceholderName(child, names));
            }
            this.children = transformedChildren.build();
            for (String name : names) {
                if (BaseUtils.isIdentifier(name)) continue;
                errorReporter.report(SoySyntaxException.createWithMetaInfo("'phname' attribute is not a valid identifier", this.sourceLocation));
            }
            if (names.size() > 1) {
                errorReporter.report(SoySyntaxException.createWithMetaInfo("Multiple 'phname' attributes in HTML tag.", this.sourceLocation));
            }
            return (String)Iterables.getFirst(names, null);
        }

        private static SoyNode.StandaloneNode extractPlaceholderName(SoyNode.StandaloneNode node, List<String> names) {
            if (!(node instanceof RawTextNode)) {
                return node;
            }
            String rawText = ((RawTextNode)node).getRawText();
            Matcher matcher = PHNAME_ATTR_PATTERN.matcher(rawText);
            if (matcher.find()) {
                StringBuffer sb = new StringBuffer(rawText.length());
                do {
                    String userSuppliedPlaceholderName = matcher.group(1);
                    names.add(userSuppliedPlaceholderName);
                    matcher.appendReplacement(sb, "");
                } while (matcher.find());
                String replacementText = matcher.appendTail(sb).toString();
                return new RawTextNode(node.getId(), replacementText);
            }
            return node;
        }

        private MsgHtmlTagNode buildAndThrowIfInvalid() {
            TransitionalThrowingErrorReporter errorReporter = new TransitionalThrowingErrorReporter();
            MsgHtmlTagNode node = this.build(errorReporter);
            errorReporter.throwIfErrorsPresent();
            return node;
        }
    }
}

