/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.exprparse.ExprParseUtils;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.TransitionalThrowingErrorReporter;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public final class CallDelegateNode
extends CallNode {
    private static final Pattern NONATTRIBUTE_CALLEE_NAME = Pattern.compile("^ (?! name=\") [.\\w]+ (?= \\s | $)", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("delcall", new CommandTextAttributesParser.Attribute("name", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("variant", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("data", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("allowemptydefault", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, null));
    private final String delCalleeName;
    @Nullable
    private final ExprRootNode<?> delCalleeVariantExpr;
    private Boolean allowsEmptyDefault;
    private ImmutableMap<TemplateDelegateNode, ImmutableList<TemplateParam>> paramsToRuntimeCheckByDelegate;

    private CallDelegateNode(int id, CommandTextInfo commandTextInfo, ImmutableList<String> escapingDirectiveNames) {
        super(id, "delcall", commandTextInfo, escapingDirectiveNames);
        this.delCalleeName = commandTextInfo.delCalleeName;
        this.delCalleeVariantExpr = commandTextInfo.delCalleeVariantExpr;
        this.allowsEmptyDefault = commandTextInfo.allowsEmptyDefault;
    }

    protected CallDelegateNode(CallDelegateNode orig) {
        super(orig);
        this.delCalleeName = orig.delCalleeName;
        this.delCalleeVariantExpr = orig.delCalleeVariantExpr != null ? orig.delCalleeVariantExpr.clone() : null;
        this.allowsEmptyDefault = orig.allowsEmptyDefault;
        this.paramsToRuntimeCheckByDelegate = orig.paramsToRuntimeCheckByDelegate;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_DELEGATE_NODE;
    }

    public String getDelCalleeName() {
        return this.delCalleeName;
    }

    @Nullable
    public ExprRootNode<?> getDelCalleeVariantExpr() {
        return this.delCalleeVariantExpr;
    }

    public void maybeSetAllowsEmptyDefault(boolean defaultValueForAllowsEmptyDefault) {
        if (this.allowsEmptyDefault == null) {
            this.allowsEmptyDefault = defaultValueForAllowsEmptyDefault;
        }
    }

    public void setParamsToRuntimeCheck(ImmutableMap<TemplateDelegateNode, ImmutableList<TemplateParam>> paramsToRuntimeCheck) {
        this.paramsToRuntimeCheckByDelegate = (ImmutableMap)Preconditions.checkNotNull(paramsToRuntimeCheck);
    }

    @Override
    public Collection<TemplateParam> getParamsToRuntimeCheck(TemplateNode callee) {
        if (this.paramsToRuntimeCheckByDelegate == null) {
            return callee.getParams();
        }
        ImmutableList params = (ImmutableList)this.paramsToRuntimeCheckByDelegate.get((Object)callee);
        if (params == null) {
            return callee.getParams();
        }
        return params;
    }

    public boolean allowsEmptyDefault() {
        Preconditions.checkState((this.allowsEmptyDefault != null ? 1 : 0) != 0);
        return this.allowsEmptyDefault;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        ArrayList allExprUnions = Lists.newArrayListWithCapacity((int)2);
        if (this.delCalleeVariantExpr != null) {
            allExprUnions.add(new ExprUnion(this.delCalleeVariantExpr));
        }
        allExprUnions.addAll(super.getAllExprUnions());
        return Collections.unmodifiableList(allExprUnions);
    }

    @Override
    public CallDelegateNode clone() {
        return new CallDelegateNode(this);
    }

    public static final class Builder {
        public static final CallDelegateNode ERROR = new Builder(-1, SourceLocation.UNKNOWN).commandText("error.error").buildAndThrowIfInvalid();
        private final int id;
        private final SourceLocation sourceLocation;
        private boolean allowEmptyDefault;
        private boolean isPassingData;
        private boolean isPassingAllData;
        private ImmutableList<String> escapingDirectiveNames = ImmutableList.of();
        @Nullable
        private String commandText;
        @Nullable
        private String delCalleeName;
        @Nullable
        private ExprRootNode<?> delCalleeVariantExpr;
        @Nullable
        private ExprRootNode<?> dataExpr;
        @Nullable
        private String userSuppliedPlaceholderName;

        public Builder(int id, SourceLocation sourceLocation) {
            this.id = id;
            this.sourceLocation = sourceLocation;
        }

        public Builder allowEmptyDefault(boolean allowEmptyDefault) {
            this.allowEmptyDefault = allowEmptyDefault;
            return this;
        }

        public Builder commandText(String commandText) {
            this.commandText = commandText;
            return this;
        }

        public Builder dataExpr(ExprRootNode<?> dataExpr) {
            this.dataExpr = dataExpr;
            return this;
        }

        public Builder delCalleeName(String delCalleeName) {
            this.delCalleeName = delCalleeName;
            return this;
        }

        public Builder delCalleeVariantExpr(ExprRootNode<?> delCalleeVariantExpr) {
            this.delCalleeVariantExpr = delCalleeVariantExpr;
            return this;
        }

        public Builder escapingDirectiveNames(ImmutableList<String> escapingDirectiveNames) {
            this.escapingDirectiveNames = escapingDirectiveNames;
            return this;
        }

        public Builder isPassingData(boolean isPassingData) {
            this.isPassingData = isPassingData;
            return this;
        }

        public Builder isPassingAllData(boolean isPassingAllData) {
            this.isPassingAllData = isPassingAllData;
            return this;
        }

        public Builder userSuppliedPlaceholderName(String userSuppliedPlaceholderName) {
            this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
            return this;
        }

        public CallDelegateNode build(ErrorReporter errorReporter) {
            CommandTextInfo commandTextInfo;
            ErrorReporter.Checkpoint checkpoint = errorReporter.checkpoint();
            CommandTextInfo commandTextInfo2 = commandTextInfo = this.commandText != null ? this.parseCommandText(errorReporter) : this.buildCommandText();
            if (errorReporter.errorsSince(checkpoint)) {
                return ERROR;
            }
            CallDelegateNode callDelegateNode = new CallDelegateNode(this.id, commandTextInfo, this.escapingDirectiveNames);
            callDelegateNode.setSourceLocation(this.sourceLocation);
            return callDelegateNode;
        }

        public CallDelegateNode buildAndThrowIfInvalid() {
            TransitionalThrowingErrorReporter errorManager = new TransitionalThrowingErrorReporter();
            CallDelegateNode node = this.build(errorManager);
            errorManager.throwIfErrorsPresent();
            return node;
        }

        private CommandTextInfo parseCommandText(ErrorReporter errorReporter) {
            ExprRootNode<?> delCalleeVariantExpr;
            String variantExprText;
            Map<String, String> attributes;
            String delCalleeName;
            String commandTextWithoutPhnameAttr = this.commandText;
            String commandText = commandTextWithoutPhnameAttr + (this.userSuppliedPlaceholderName != null ? " phname=\"" + this.userSuppliedPlaceholderName + "\"" : "");
            Matcher ncnMatcher = NONATTRIBUTE_CALLEE_NAME.matcher(commandTextWithoutPhnameAttr);
            if (ncnMatcher.find()) {
                commandTextWithoutPhnameAttr = ncnMatcher.replaceFirst("name=\"" + ncnMatcher.group() + "\"");
            }
            if ((delCalleeName = (attributes = ATTRIBUTES_PARSER.parse(commandTextWithoutPhnameAttr, errorReporter, this.sourceLocation)).get("name")) == null) {
                errorReporter.report(SoySyntaxException.createWithMetaInfo("The 'delcall' command text must contain the callee name (encountered command text \"" + commandTextWithoutPhnameAttr + "\").", this.sourceLocation));
            }
            if (!BaseUtils.isDottedIdentifier(delCalleeName)) {
                errorReporter.report(SoySyntaxException.createWithMetaInfo("Invalid delegate name \"" + delCalleeName + "\" for 'delcall' command.", this.sourceLocation));
            }
            if ((variantExprText = attributes.get("variant")) == null) {
                delCalleeVariantExpr = null;
            } else {
                String fixedVariantStr;
                delCalleeVariantExpr = ExprParseUtils.parseExprElseThrowSoySyntaxException(variantExprText, String.format("Invalid variant expression \"%s\" in 'delcall'.", variantExprText));
                if (delCalleeVariantExpr.getChild(0) instanceof StringNode && !BaseUtils.isIdentifier(fixedVariantStr = ((StringNode)delCalleeVariantExpr.getChild(0)).getValue())) {
                    errorReporter.report(SoySyntaxException.createWithMetaInfo("Invalid variant expression \"" + variantExprText + "\" in 'delcall'" + " (variant expression must evaluate to an identifier).", this.sourceLocation));
                }
            }
            Pair<Boolean, ExprRootNode<?>> dataAttrInfo = CallNode.parseDataAttributeHelper(attributes.get("data"), commandText);
            String allowemptydefaultAttr = attributes.get("allowemptydefault");
            Boolean allowsEmptyDefault = allowemptydefaultAttr == null ? null : Boolean.valueOf(allowemptydefaultAttr.equals("true"));
            return new CommandTextInfo(commandText, delCalleeName, delCalleeVariantExpr, allowsEmptyDefault, (Boolean)dataAttrInfo.first, (ExprRootNode)dataAttrInfo.second, this.userSuppliedPlaceholderName);
        }

        private CommandTextInfo buildCommandText() {
            Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(this.delCalleeName));
            if (this.isPassingAllData) {
                Preconditions.checkArgument((boolean)this.isPassingData);
            }
            if (this.dataExpr != null) {
                Preconditions.checkArgument((this.isPassingData && !this.isPassingAllData ? 1 : 0) != 0);
            }
            String commandText = "";
            commandText = commandText + this.delCalleeName;
            if (this.isPassingAllData) {
                commandText = commandText + " data=\"all\"";
            } else if (this.isPassingData) {
                assert (this.dataExpr != null);
                commandText = commandText + " data=\"" + this.dataExpr.toSourceString() + '\"';
            }
            if (this.userSuppliedPlaceholderName != null) {
                commandText = commandText + " phname=\"" + this.userSuppliedPlaceholderName + '\"';
            }
            return new CommandTextInfo(commandText, this.delCalleeName, this.delCalleeVariantExpr, this.allowEmptyDefault, this.isPassingData, this.dataExpr, this.userSuppliedPlaceholderName);
        }
    }

    @Immutable
    private static class CommandTextInfo
    extends CallNode.CommandTextInfo {
        public final String delCalleeName;
        @Nullable
        public final ExprRootNode<?> delCalleeVariantExpr;
        public final Boolean allowsEmptyDefault;

        public CommandTextInfo(String commandText, String delCalleeName, @Nullable ExprRootNode<?> delCalleeVariantExpr, Boolean allowsEmptyDefault, boolean isPassingData, @Nullable ExprRootNode<?> dataExpr, @Nullable String userSuppliedPlaceholderName) {
            super(commandText, isPassingData, dataExpr, userSuppliedPlaceholderName, null);
            this.delCalleeName = delCalleeName;
            this.delCalleeVariantExpr = delCalleeVariantExpr;
            this.allowsEmptyDefault = allowsEmptyDefault;
        }
    }
}

