/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.soyparse.Token;

final class SourceItemInfo<T> {
    private final T parsedContent;
    private final SourceLocation location;

    SourceItemInfo(String filePath, int lineOffset, T parsedContent, Token token) {
        this(filePath, parsedContent, lineOffset + token.beginLine, token.beginColumn, lineOffset + token.endLine, token.endColumn);
    }

    SourceItemInfo(T parsedContent, SourceItemInfo<?> begin, SourceItemInfo<?> end) {
        this(begin.location.getFilePath(), parsedContent, begin.location.getLineNumber(), begin.location.getBeginColumn(), end.location.getEndLine(), end.location.getEndColumn());
        Preconditions.checkArgument((boolean)begin.location.getFileName().equals(end.location.getFileName()));
    }

    SourceItemInfo(String filePath, T parsedContent, int lineNum, int columnNum, int lineNumEnd, int columnNumEnd) {
        this.location = new SourceLocation(filePath, lineNum, columnNum, lineNumEnd, columnNumEnd);
        this.parsedContent = parsedContent;
    }

    T parsedContent() {
        return this.parsedContent;
    }

    SourceLocation srcLocation() {
        return this.location;
    }
}

