/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoySyntaxExceptionUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.InjectedParam;
import com.google.template.soy.soytree.defn.LoopVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.UndeclaredVar;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ResolveNamesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private LocalVariables localVariables;
    private Map<String, InjectedParam> ijParams;
    private final SyntaxVersion declaredSyntaxVersion;
    private String currentTemplateName;

    public ResolveNamesVisitor(SyntaxVersion declaredSyntaxVersion) {
        this.declaredSyntaxVersion = declaredSyntaxVersion;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.currentTemplateName = node.getTemplateNameForUserMsgs();
        this.localVariables = new LocalVariables();
        this.localVariables.enterScope();
        this.ijParams = new HashMap<String, InjectedParam>();
        for (TemplateParam param : node.getAllParams()) {
            this.localVariables.define(param, (SoyNode)node);
        }
        this.visitSoyNode(node);
        this.localVariables.exitScope();
        this.localVariables.verify();
        node.setMaxLocalVariableTableSize(this.localVariables.nextSlotToClaim);
        this.localVariables = null;
        this.ijParams = null;
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.visitSoyNode(node);
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        this.visitExpressions(node);
        this.localVariables.define(node.getVar(), (SoyNode)node);
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.localVariables.enterLazyScope();
        this.visitChildren(node);
        this.localVariables.exitLazyScope();
        this.localVariables.define(node.getVar(), (SoyNode)node);
    }

    @Override
    protected void visitForNode(ForNode node) {
        this.visitExpressions(node);
        this.localVariables.enterScope();
        this.localVariables.define(node.getVar(), (SoyNode)node);
        this.visitChildren(node);
        this.localVariables.exitScope();
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
        this.visitExpressions(node.getParent());
        this.localVariables.enterScope();
        this.localVariables.define(node.getVar(), (SoyNode)node);
        this.visitChildren(node);
        this.localVariables.exitScope();
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ExprHolderNode) {
            this.visitExpressions((SoyNode.ExprHolderNode)node);
        }
        if (node instanceof SoyNode.ParentSoyNode) {
            if (node instanceof SoyNode.BlockNode) {
                this.localVariables.enterScope();
                this.visitChildren((SoyNode.BlockNode)node);
                this.localVariables.exitScope();
            } else {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }

    private void visitExpressions(SoyNode.ExprHolderNode node) {
        ResolveNamesExprVisitor exprVisitor = new ResolveNamesExprVisitor(node);
        for (ExprUnion exprUnion : node.getAllExprUnions()) {
            if (exprUnion.getExpr() == null) continue;
            exprVisitor.exec(exprUnion.getExpr());
        }
    }

    private class ResolveNamesExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final SoyNode.ExprHolderNode owningSoyNode;
        private ExprRootNode<?> currExprRootNode;

        public ResolveNamesExprVisitor(SoyNode.ExprHolderNode owningSoyNode) {
            this.owningSoyNode = owningSoyNode;
        }

        @Override
        public Void exec(ExprNode node) {
            Preconditions.checkArgument((boolean)(node instanceof ExprRootNode));
            this.currExprRootNode = (ExprRootNode)node;
            this.visit(node);
            this.currExprRootNode = null;
            return null;
        }

        @Override
        protected void visit(ExprNode node) {
            super.visit(node);
        }

        @Override
        protected void visitExprRootNode(ExprRootNode<?> node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        @Override
        protected void visitVarRefNode(VarRefNode varRef) {
            if (varRef.isInjected()) {
                InjectedParam ijParam = (InjectedParam)ResolveNamesVisitor.this.ijParams.get(varRef.getName());
                if (ijParam == null) {
                    ijParam = new InjectedParam(varRef.getName());
                    ResolveNamesVisitor.this.ijParams.put(varRef.getName(), ijParam);
                }
                varRef.setDefn(ijParam);
                return;
            }
            VarDefn varDefn = ResolveNamesVisitor.this.localVariables.lookup(varRef.getName());
            if (varDefn == null) {
                if (((ResolveNamesVisitor)ResolveNamesVisitor.this).declaredSyntaxVersion.num >= SyntaxVersion.V9_9.num) {
                    throw this.createExceptionForInvalidExpr("Undefined variable: " + varRef.getName());
                }
                varDefn = new UndeclaredVar(varRef.getName());
            }
            varRef.setDefn(varDefn);
        }

        private SoySyntaxException createExceptionForInvalidExpr(String errorMsg) {
            return SoySyntaxExceptionUtils.createWithNode("Invalid expression \"" + this.currExprRootNode.toSourceString() + "\": " + errorMsg, this.owningSoyNode);
        }
    }

    private final class LocalVariables {
        private final BitSet availableSlots = new BitSet();
        private final Deque<Map<String, VarDefn>> currentScope = new ArrayDeque<Map<String, VarDefn>>();
        private final BitSet slotsToRelease = new BitSet();
        private int nextSlotToClaim = 0;
        private int delayReleaseClaims = 0;

        private LocalVariables() {
        }

        void enterScope() {
            this.currentScope.push(new LinkedHashMap());
        }

        void enterLazyScope() {
            ++this.delayReleaseClaims;
            this.enterScope();
        }

        void exitLazyScope() {
            Preconditions.checkState((this.delayReleaseClaims > 0 ? 1 : 0) != 0, (Object)"Exiting a lazy scope when we aren't in one");
            this.exitScope();
            --this.delayReleaseClaims;
        }

        void exitScope() {
            Map<String, VarDefn> variablesGoingOutOfScope = this.currentScope.pop();
            for (VarDefn var : variablesGoingOutOfScope.values()) {
                if (var instanceof LoopVar) {
                    LoopVar loopVar = (LoopVar)var;
                    this.slotsToRelease.set(loopVar.currentLoopIndexIndex());
                    this.slotsToRelease.set(loopVar.isLastIteratorIndex());
                }
                this.slotsToRelease.set(var.localVariableIndex());
            }
            if (this.delayReleaseClaims == 0) {
                this.availableSlots.or(this.slotsToRelease);
                this.slotsToRelease.clear();
            }
        }

        VarDefn lookup(String name) {
            for (Map<String, VarDefn> scope : this.currentScope) {
                VarDefn defn = scope.get(name);
                if (defn == null) continue;
                return defn;
            }
            return null;
        }

        void define(LoopVar defn, SoyNode definingNode) {
            defn.setExtraLoopIndices(this.claimSlot(), this.claimSlot());
            this.define((VarDefn)defn, definingNode);
        }

        void define(VarDefn defn, SoyNode definingNode) {
            VarDefn preexisting = this.lookup(defn.name());
            if (preexisting != null) {
                throw SoySyntaxException.createWithMetaInfo("variable $" + defn.name() + " was already defined", definingNode.getSourceLocation(), null, ResolveNamesVisitor.this.currentTemplateName);
            }
            this.currentScope.peek().put(defn.name(), defn);
            defn.setLocalVariableIndex(this.claimSlot());
        }

        private int claimSlot() {
            int slotToUse;
            int nextSetBit = this.availableSlots.nextSetBit(0);
            if (nextSetBit != -1) {
                slotToUse = nextSetBit;
                this.availableSlots.clear(nextSetBit);
            } else {
                slotToUse = this.nextSlotToClaim++;
            }
            return slotToUse;
        }

        void verify() {
            Preconditions.checkState((this.delayReleaseClaims == 0 ? 1 : 0) != 0, (String)"%s lazy scope(s) are still active", (Object[])new Object[]{this.delayReleaseClaims});
            Preconditions.checkState((boolean)this.slotsToRelease.isEmpty(), (String)"%s slots are waiting to be released", (Object[])new Object[]{this.slotsToRelease});
            BitSet unavailableSlots = new BitSet(this.nextSlotToClaim);
            unavailableSlots.set(0, this.nextSlotToClaim);
            unavailableSlots.xor(this.availableSlots);
            Preconditions.checkState((boolean)unavailableSlots.isEmpty(), (String)"Expected all slots to be available: %s", (Object[])new Object[]{unavailableSlots});
        }
    }
}

