/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.restricted;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;

public final class TagWhitelist {
    private final ImmutableSet<String> safeTagNames;
    private static final Pattern VALID_TAG_NAME = Pattern.compile("^[A-Za-z][A-Za-z0-9]*(?:-[A-Za-z][A-Za-z0-9]*)*\\z");
    public static final TagWhitelist FORMATTING = new TagWhitelist("b", "br", "em", "i", "s", "sub", "sup", "u");

    TagWhitelist(Collection<? extends String> tagNames) {
        this.safeTagNames = ImmutableSet.copyOf(tagNames);
        assert (TagWhitelist.requireLowerCaseTagNames(this.safeTagNames));
    }

    TagWhitelist(String ... tagNames) {
        this(Arrays.asList(tagNames));
    }

    public TagWhitelist withOptionalSafeTags(Collection<? extends OptionalSafeTag> optionalSafeTags) {
        if (optionalSafeTags.isEmpty()) {
            return this;
        }
        ImmutableSet optionalSafeTagNames = FluentIterable.from(optionalSafeTags).transform(OptionalSafeTag.TO_TAG_NAME).toSet();
        return new TagWhitelist((Collection<? extends String>)Sets.union(this.safeTagNames, (Set)optionalSafeTagNames));
    }

    public boolean isSafeTag(String tagName) {
        return this.safeTagNames.contains((Object)tagName);
    }

    public Set<String> asSet() {
        return this.safeTagNames;
    }

    private static boolean requireLowerCaseTagNames(Iterable<? extends String> strs) {
        for (String string : strs) {
            assert (string.equals(string.toLowerCase(Locale.ENGLISH)) && VALID_TAG_NAME.matcher(string).matches()) : string;
        }
        return true;
    }

    public static enum OptionalSafeTag {
        LI("li"),
        OL("ol"),
        SPAN("span"),
        UL("ul");

        private final String tagName;
        public static final Function<String, OptionalSafeTag> FROM_TAG_NAME;
        public static final Function<OptionalSafeTag, String> TO_TAG_NAME;
        private static final ImmutableMap<String, OptionalSafeTag> OPTIONAL_SAFE_TAGS_BY_TAG_NAME;

        private OptionalSafeTag(String tagName) {
            this.tagName = tagName;
        }

        public String getTagName() {
            return this.tagName;
        }

        public static OptionalSafeTag fromTagName(String tagName) {
            OptionalSafeTag tag = (OptionalSafeTag)((Object)OPTIONAL_SAFE_TAGS_BY_TAG_NAME.get((Object)tagName));
            if (tag == null) {
                throw new IllegalArgumentException(String.format("%s is not a valid optional safe tag.", tagName));
            }
            return tag;
        }

        static {
            FROM_TAG_NAME = new Function<String, OptionalSafeTag>(){

                public OptionalSafeTag apply(String tagName) {
                    return OptionalSafeTag.fromTagName(tagName);
                }
            };
            TO_TAG_NAME = new Function<OptionalSafeTag, String>(){

                public String apply(OptionalSafeTag tag) {
                    return tag.getTagName();
                }
            };
            OPTIONAL_SAFE_TAGS_BY_TAG_NAME = Maps.uniqueIndex(EnumSet.allOf(OptionalSafeTag.class), TO_TAG_NAME);
        }
    }
}

