/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.shared.internal.CodeBuilder;
import java.util.List;

final class JsCodeBuilder
extends CodeBuilder<JsExpr> {
    private final SoyJsSrcOptions.CodeStyle codeStyle;

    public JsCodeBuilder(SoyJsSrcOptions.CodeStyle codeStyle) {
        this.codeStyle = codeStyle;
    }

    @Override
    public void initOutputVarIfNecessary() {
        if (this.getOutputVarIsInited()) {
            return;
        }
        if (this.codeStyle == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            this.appendLine("var ", this.getOutputVarName(), " = new soy.StringBuilder();");
        } else {
            this.appendLine("var ", this.getOutputVarName(), " = '';");
        }
        this.setOutputVarInited();
    }

    @Override
    public void addToOutputVar(List<? extends JsExpr> jsExprs) {
        if (this.codeStyle == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            StringBuilder commaSeparatedJsExprsSb = new StringBuilder();
            boolean isFirst = true;
            for (JsExpr jsExpr : jsExprs) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    commaSeparatedJsExprsSb.append(", ");
                }
                commaSeparatedJsExprsSb.append(jsExpr.getText());
            }
            if (this.getOutputVarIsInited()) {
                this.appendLine(this.getOutputVarName(), ".append(", commaSeparatedJsExprsSb.toString(), ");");
            } else {
                this.appendLine("var ", this.getOutputVarName(), " = new soy.StringBuilder(", commaSeparatedJsExprsSb.toString(), ");");
                this.setOutputVarInited();
            }
        } else if (this.getOutputVarIsInited()) {
            this.appendLine(this.getOutputVarName(), " += ", JsExprUtils.concatJsExprs(jsExprs).getText(), ";");
        } else {
            String contents = JsExprUtils.concatJsExprsForceString(jsExprs).getText();
            this.appendLine("var ", this.getOutputVarName(), " = ", contents, ";");
            this.setOutputVarInited();
        }
    }
}

