/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.restricted;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.internal.RenderableThunk;
import com.google.template.soy.data.restricted.PrimitiveData;
import java.io.IOException;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class StringData
extends PrimitiveData {
    public static final StringData EMPTY_STRING = new ConstantString("");

    private StringData() {
    }

    public static StringData forValue(String value) {
        return value.length() == 0 ? EMPTY_STRING : new ConstantString(value);
    }

    public static StringData forThunk(RenderableThunk thunk) {
        return new LazyString(thunk);
    }

    public abstract String getValue();

    @Override
    public String stringValue() {
        return this.getValue();
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    @Override
    @Deprecated
    public boolean toBoolean() {
        return this.getValue().length() > 0;
    }

    @Override
    public boolean equals(Object other) {
        return other != null && this.getValue().equals(other.toString());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    private static final class LazyString
    extends StringData {
        RenderableThunk thunk;
        String content;

        LazyString(RenderableThunk thunk) {
            this.thunk = thunk;
        }

        @Override
        public void render(Appendable appendable) throws IOException {
            if (this.content == null) {
                this.content = this.thunk.renderAndSave(appendable);
                this.thunk = null;
            } else {
                appendable.append(this.content);
            }
        }

        @Override
        public String getValue() {
            if (this.content == null) {
                this.content = this.thunk.renderAsString();
                this.thunk = null;
            }
            return this.content;
        }
    }

    private static final class ConstantString
    extends StringData {
        final String content;

        ConstantString(String content) {
            this.content = (String)Preconditions.checkNotNull((Object)content);
        }

        @Override
        public void render(Appendable appendable) throws IOException {
            appendable.append(this.content);
        }

        @Override
        public String getValue() {
            return this.content;
        }
    }
}

