/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import java.io.IOException;

public abstract class RenderableThunk {
    public abstract void render(Appendable var1) throws IOException;

    public final String renderAndSave(Appendable appendable) throws IOException {
        TeeAppendable tee = new TeeAppendable(appendable);
        this.render(tee);
        return tee.buffer.toString();
    }

    public final String renderAsString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.render(sb);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    private static final class TeeAppendable
    implements Appendable {
        final StringBuilder buffer = new StringBuilder();
        final Appendable delegate;

        TeeAppendable(Appendable delegate) {
            this.delegate = delegate;
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            this.delegate.append(csq);
            this.buffer.append(csq);
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            this.delegate.append(csq, start, end);
            this.buffer.append(csq, start, end);
            return this;
        }

        @Override
        public Appendable append(char c) throws IOException {
            this.delegate.append(c);
            this.buffer.append(c);
            return this;
        }
    }
}

