/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.base.internal.SoyFileSupplier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public final class ErrorPrettyPrinter {
    private final ImmutableMap<String, SoyFileSupplier> filePathsToSuppliers;
    private final PrintStream err;

    public ErrorPrettyPrinter(List<SoyFileSupplier> suppliers, PrintStream err) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (SoyFileSupplier supplier : suppliers) {
            builder.put((Object)supplier.getFilePath(), (Object)supplier);
        }
        this.filePathsToSuppliers = builder.build();
        this.err = err;
    }

    public void print(SoySyntaxException e) {
        String snippet;
        this.err.println(e.getMessage());
        SourceLocation sourceLocation = e.getSourceLocation();
        SoyFileSupplier supplier = (SoyFileSupplier)this.filePathsToSuppliers.get((Object)sourceLocation.getFilePath());
        if (supplier == null) {
            return;
        }
        try {
            snippet = this.getSnippet(supplier, sourceLocation);
        }
        catch (IOException ioe) {
            return;
        }
        this.err.println(snippet);
        int beginColumn = Math.max(e.getSourceLocation().getBeginColumn(), 1);
        String caretLine = Strings.repeat((String)" ", (int)(beginColumn - 1)) + "^";
        this.err.println(caretLine);
    }

    private String getSnippet(SoyFileSupplier supplier, SourceLocation sourceLocation) throws IOException {
        try (BufferedReader reader = new BufferedReader(supplier.open());){
            for (int linenum = 1; linenum < sourceLocation.getLineNumber(); ++linenum) {
                reader.readLine();
            }
            String string = reader.readLine();
            return string;
        }
    }
}

