/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.RenderVisitor;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.tofu.internal.TofuEvalVisitorFactory;
import com.google.template.soy.tofu.restricted.SoyTofuPrintDirective;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class TofuRenderVisitor
extends RenderVisitor {
    private final Map<String, SoyTofuPrintDirective> soyTofuDirectivesMap;

    protected TofuRenderVisitor(Map<String, SoyTofuPrintDirective> soyTofuDirectivesMap, TofuEvalVisitorFactory tofuEvalVisitorFactory, Appendable outputBuf, @Nullable TemplateRegistry templateRegistry, SoyMapData data, @Nullable SoyMapData ijData, @Nullable Deque<Map<String, SoyData>> env, @Nullable Set<String> activeDelPackageNames, @Nullable SoyMsgBundle msgBundle, @Nullable SoyCssRenamingMap cssRenamingMap) {
        super(null, tofuEvalVisitorFactory, outputBuf, templateRegistry, data, ijData, env, activeDelPackageNames, msgBundle, cssRenamingMap);
        this.soyTofuDirectivesMap = soyTofuDirectivesMap;
    }

    @Override
    protected TofuRenderVisitor createHelperInstance(Appendable outputBuf, SoyMapData data) {
        return new TofuRenderVisitor(this.soyTofuDirectivesMap, (TofuEvalVisitorFactory)this.evalVisitorFactory, outputBuf, this.templateRegistry, data, this.ijData, null, (Set<String>)this.activeDelPackageNames, this.msgBundle, this.cssRenamingMap);
    }

    @Override
    protected SoyData applyDirective(String directiveName, SoyData value, List<SoyData> args, SoyNode node) {
        SoyTofuPrintDirective directive = this.soyTofuDirectivesMap.get(directiveName);
        if (directive == null) {
            throw new RenderException("Failed to find Soy print directive with name '" + directiveName + "'" + " (tag " + node.toSourceString() + ")");
        }
        if (!directive.getValidArgsSizes().contains(args.size())) {
            throw new RenderException("Print directive '" + directiveName + "' used with the wrong number of" + " arguments (tag " + node.toSourceString() + ").");
        }
        return directive.applyForTofu(value, args);
    }
}

