/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.InsertMsgsVisitor;
import com.google.template.soy.parseinfo.SoyTemplateInfo;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.FindIjParamsVisitor;
import com.google.template.soy.sharedpasses.MarkLocalVarDataRefsVisitor;
import com.google.template.soy.sharedpasses.RenameCssVisitor;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.SoyTofuException;
import com.google.template.soy.tofu.internal.MarkParentNodesNeedingEnvFramesVisitor;
import com.google.template.soy.tofu.internal.NamespacedTofu;
import com.google.template.soy.tofu.internal.TofuRenderVisitor;
import com.google.template.soy.tofu.internal.TofuRenderVisitorFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class BaseTofu
implements SoyTofu {
    private final GuiceSimpleScope apiCallScope;
    private final TofuRenderVisitorFactory tofuRenderVisitorFactory;
    private final SimplifyVisitor simplifyVisitor;
    private final SoyFileSetNode soyTree;
    private final boolean isCaching;
    private final Map<Pair<SoyMsgBundle, SoyCssRenamingMap>, TemplateRegistry> cachedTemplateRegistries;
    private final TemplateRegistry templateRegistryForNoCaching;
    private final ImmutableMap<TemplateNode, FindIjParamsVisitor.IjParamsInfo> templateToIjParamsInfoMap;

    @AssistedInject
    public BaseTofu(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope apiCallScope, TofuRenderVisitorFactory tofuRenderVisitorFactory, SimplifyVisitor simplifyVisitor, @Assisted SoyFileSetNode soyTree, @Assisted boolean isCaching) {
        this.apiCallScope = apiCallScope;
        this.tofuRenderVisitorFactory = tofuRenderVisitorFactory;
        this.simplifyVisitor = simplifyVisitor;
        this.soyTree = soyTree;
        this.isCaching = isCaching;
        if (isCaching) {
            this.cachedTemplateRegistries = Maps.newHashMap();
            this.addToCache(null, null);
        } else {
            this.cachedTemplateRegistries = null;
        }
        SoyFileSetNode soyTreeForNoCaching = soyTree.clone();
        this.templateRegistryForNoCaching = this.buildTemplateRegistry(soyTreeForNoCaching);
        this.templateToIjParamsInfoMap = new FindIjParamsVisitor(this.templateRegistryForNoCaching).execForAllTemplates(soyTreeForNoCaching);
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public SoyTofu forNamespace(@Nullable String namespace) {
        return namespace == null ? this : new NamespacedTofu(this, namespace);
    }

    @Override
    public boolean isCaching() {
        return this.isCaching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToCache(@Nullable SoyMsgBundle msgBundle, @Nullable SoyCssRenamingMap cssRenamingMap) {
        if (!this.isCaching) {
            throw new SoyTofuException("Cannot addToCache() when isCaching is false.");
        }
        this.apiCallScope.enter();
        try {
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, msgBundle, 0);
            this.getCachedTemplateRegistry(Pair.of(msgBundle, cssRenamingMap), true);
        }
        finally {
            this.apiCallScope.exit();
        }
    }

    @Override
    public SoyTofu.Renderer newRenderer(SoyTemplateInfo templateInfo) {
        return new RendererImpl(this, templateInfo.getName());
    }

    @Override
    public SoyTofu.Renderer newRenderer(String templateName) {
        return new RendererImpl(this, templateName);
    }

    @Override
    public ImmutableSortedSet<String> getUsedIjParamsForTemplate(SoyTemplateInfo templateInfo) {
        return this.getUsedIjParamsForTemplate(templateInfo.getName());
    }

    @Override
    public ImmutableSortedSet<String> getUsedIjParamsForTemplate(String templateName) {
        TemplateBasicNode template = this.templateRegistryForNoCaching.getBasicTemplate(templateName);
        if (template == null) {
            throw new SoyTofuException("Template '" + templateName + "' not found.");
        }
        FindIjParamsVisitor.IjParamsInfo ijParamsInfo = (FindIjParamsVisitor.IjParamsInfo)this.templateToIjParamsInfoMap.get((Object)template);
        return ijParamsInfo.ijParamSet;
    }

    private TemplateRegistry buildTemplateRegistry(SoyFileSetNode soyTree) {
        new MarkParentNodesNeedingEnvFramesVisitor().exec(soyTree);
        new MarkLocalVarDataRefsVisitor().exec(soyTree);
        return new TemplateRegistry(soyTree);
    }

    private TemplateRegistry getCachedTemplateRegistry(Pair<SoyMsgBundle, SoyCssRenamingMap> key, boolean doAddToCache) {
        Preconditions.checkState((boolean)this.apiCallScope.isActive());
        TemplateRegistry templateRegistry = this.cachedTemplateRegistries.get(key);
        if (templateRegistry == null) {
            if (!doAddToCache) {
                return null;
            }
            SoyFileSetNode soyTreeClone = this.soyTree.clone();
            new InsertMsgsVisitor((SoyMsgBundle)key.first, true).exec(soyTreeClone);
            new RenameCssVisitor((SoyCssRenamingMap)key.second).exec(soyTreeClone);
            this.simplifyVisitor.exec(soyTreeClone);
            templateRegistry = this.buildTemplateRegistry(soyTreeClone);
            this.cachedTemplateRegistries.put(key, templateRegistry);
        }
        return templateRegistry;
    }

    private String renderMain(String templateName, @Nullable SoyMapData data, @Nullable SoyMapData ijData, @Nullable Set<String> activeDelPackageNames, @Nullable SoyMsgBundle msgBundle, @Nullable SoyCssRenamingMap cssRenamingMap, boolean doAddToCache) {
        StringBuilder outputSb = new StringBuilder();
        this.renderMain(outputSb, templateName, data, ijData, activeDelPackageNames, msgBundle, cssRenamingMap, doAddToCache);
        return outputSb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMain(Appendable outputBuf, String templateName, @Nullable SoyMapData data, @Nullable SoyMapData ijData, @Nullable Set<String> activeDelPackageNames, @Nullable SoyMsgBundle msgBundle, @Nullable SoyCssRenamingMap cssRenamingMap, boolean doAddToCache) {
        if (activeDelPackageNames == null) {
            activeDelPackageNames = Collections.emptySet();
        }
        this.apiCallScope.enter();
        try {
            TemplateRegistry cachedTemplateRegistry;
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, msgBundle, 0);
            TemplateRegistry templateRegistry = cachedTemplateRegistry = this.isCaching ? this.getCachedTemplateRegistry(Pair.of(msgBundle, cssRenamingMap), doAddToCache) : null;
            if (cachedTemplateRegistry != null) {
                this.renderMainHelper(cachedTemplateRegistry, outputBuf, templateName, data, ijData, activeDelPackageNames, msgBundle, null);
            } else {
                this.renderMainHelper(this.templateRegistryForNoCaching, outputBuf, templateName, data, ijData, activeDelPackageNames, msgBundle, cssRenamingMap);
            }
        }
        finally {
            this.apiCallScope.exit();
        }
    }

    private void renderMainHelper(TemplateRegistry templateRegistry, Appendable outputBuf, String templateName, @Nullable SoyMapData data, @Nullable SoyMapData ijData, Set<String> activeDelPackageNames, @Nullable SoyMsgBundle msgBundle, @Nullable SoyCssRenamingMap cssRenamingMap) {
        TemplateBasicNode template = templateRegistry.getBasicTemplate(templateName);
        if (template == null) {
            throw new SoyTofuException("Attempting to render undefined template '" + templateName + "'.");
        }
        if (data == null) {
            data = new SoyMapData();
        }
        try {
            TofuRenderVisitor rv = this.tofuRenderVisitorFactory.create(outputBuf, templateRegistry, data, ijData, null, activeDelPackageNames, msgBundle, cssRenamingMap);
            rv.exec(template);
        }
        catch (RenderException re) {
            throw new SoyTofuException(re);
        }
    }

    @Override
    @Deprecated
    public String render(SoyTemplateInfo templateInfo, @Nullable Map<String, ?> data, @Nullable SoyMsgBundle msgBundle) {
        return this.renderMain(templateInfo.getName(), data == null ? null : new SoyMapData(data), null, null, msgBundle, null, true);
    }

    @Override
    @Deprecated
    public String render(SoyTemplateInfo templateInfo, @Nullable SoyMapData data, @Nullable SoyMsgBundle msgBundle) {
        return this.renderMain(templateInfo.getName(), data, null, null, msgBundle, null, true);
    }

    @Override
    @Deprecated
    public String render(String templateName, @Nullable Map<String, ?> data, @Nullable SoyMsgBundle msgBundle) {
        return this.renderMain(templateName, data == null ? null : new SoyMapData(data), null, null, msgBundle, null, true);
    }

    @Override
    @Deprecated
    public String render(String templateName, @Nullable SoyMapData data, @Nullable SoyMsgBundle msgBundle) {
        return this.renderMain(templateName, data, null, null, msgBundle, null, true);
    }

    private static class RendererImpl
    implements SoyTofu.Renderer {
        private final BaseTofu baseTofu;
        private final String templateName;
        private SoyMapData data;
        private SoyMapData ijData;
        private SoyMsgBundle msgBundle;
        private SoyCssRenamingMap cssRenamingMap;
        private Set<String> activeDelPackageNames;
        private boolean doAddToCache;

        public RendererImpl(BaseTofu baseTofu, String templateName) {
            this.baseTofu = baseTofu;
            this.templateName = templateName;
            this.data = null;
            this.ijData = null;
            this.activeDelPackageNames = null;
            this.msgBundle = null;
            this.cssRenamingMap = null;
            this.doAddToCache = true;
        }

        @Override
        public SoyTofu.Renderer setData(Map<String, ?> data) {
            this.data = data == null ? null : new SoyMapData(data);
            return this;
        }

        @Override
        public SoyTofu.Renderer setData(SoyMapData data) {
            this.data = data;
            return this;
        }

        @Override
        public SoyTofu.Renderer setIjData(Map<String, ?> ijData) {
            this.ijData = ijData == null ? null : new SoyMapData(ijData);
            return this;
        }

        @Override
        public SoyTofu.Renderer setIjData(SoyMapData ijData) {
            this.ijData = ijData;
            return this;
        }

        @Override
        public SoyTofu.Renderer setActiveDelegatePackageNames(Set<String> activeDelegatePackageNames) {
            this.activeDelPackageNames = activeDelegatePackageNames;
            return this;
        }

        @Override
        public SoyTofu.Renderer setMsgBundle(SoyMsgBundle msgBundle) {
            this.msgBundle = msgBundle;
            return this;
        }

        @Override
        public SoyTofu.Renderer setCssRenamingMap(SoyCssRenamingMap cssRenamingMap) {
            this.cssRenamingMap = cssRenamingMap;
            return this;
        }

        @Override
        public SoyTofu.Renderer setDontAddToCache(boolean dontAddToCache) {
            this.doAddToCache = !dontAddToCache;
            return this;
        }

        @Override
        public String render() {
            return this.baseTofu.renderMain(this.templateName, this.data, this.ijData, this.activeDelPackageNames, this.msgBundle, this.cssRenamingMap, this.doAddToCache);
        }

        @Override
        public SanitizedContent renderAsSanitizedContent() {
            String resultString = this.render();
            SanitizedContent.ContentKind contentKind = this.baseTofu.templateRegistryForNoCaching.getBasicTemplate(this.templateName).getContentKind();
            Preconditions.checkArgument((contentKind != null ? 1 : 0) != 0, (Object)"renderAsSanitizedContent is only valid for templates with autoescape=\"strict\".");
            return UnsafeSanitizedContentOrdainer.ordainAsSafe(resultString, contentKind);
        }

        @Override
        public void render(Appendable out) {
            this.baseTofu.renderMain(out, this.templateName, this.data, this.ijData, this.activeDelPackageNames, this.msgBundle, this.cssRenamingMap, this.doAddToCache);
        }
    }

    public static interface BaseTofuFactory {
        public BaseTofu create(SoyFileSetNode var1, boolean var2);
    }
}

