/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree.jssrc;

import com.google.template.soy.soytree.AbstractMsgNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.SoyNode;

public class GoogMsgNode
extends AbstractMsgNode
implements SoyNode.LocalVarInlineNode {
    private final String sourceString;
    private final String googMsgVarName;
    private final String renderedGoogMsgVarName;

    public GoogMsgNode(int id, MsgNode origMsgNode, String googMsgVarName) {
        super(id, origMsgNode);
        this.addChildren(origMsgNode.getChildren());
        this.sourceString = "[GoogMsgNode " + this.getVarName() + " " + origMsgNode.toSourceString() + "]";
        this.googMsgVarName = googMsgVarName;
        this.renderedGoogMsgVarName = origMsgNode.isPlrselMsg() ? "rendered_" + googMsgVarName : googMsgVarName;
    }

    protected GoogMsgNode(GoogMsgNode orig) {
        super(orig);
        this.sourceString = orig.sourceString;
        this.googMsgVarName = orig.googMsgVarName;
        this.renderedGoogMsgVarName = orig.renderedGoogMsgVarName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.GOOG_MSG_NODE;
    }

    public String getGoogMsgVarName() {
        return this.googMsgVarName;
    }

    public String getRenderedGoogMsgVarName() {
        return this.renderedGoogMsgVarName;
    }

    @Override
    public String getVarName() {
        return this.renderedGoogMsgVarName;
    }

    @Override
    public String toSourceString() {
        return this.sourceString;
    }

    @Override
    public GoogMsgNode clone() {
        return new GoogMsgNode(this);
    }
}

