/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public abstract class TemplateNode
extends AbstractBlockCommandNode
implements SoyNode.RenderUnitNode {
    public static final int MAX_PRIORITY = 1;
    private static final Pattern NEWLINE = Pattern.compile("\\n|\\r\\n?");
    private static final Pattern SOY_DOC_START = Pattern.compile("^ [/][*][*] [\\ ]* \\r?\\n?", 4);
    private static final Pattern SOY_DOC_END = Pattern.compile("\\r?\\n? [\\ ]* [*][/] $", 4);
    private static final Pattern SOY_DOC_DECL_PATTERN = Pattern.compile("( @param[?]? ) \\s+ ( \\S+ )", 4);
    private static final Pattern SOY_DOC_PARAM_TEXT_PATTERN = Pattern.compile("[a-zA-Z_]\\w*", 4);
    private final SoyFileHeaderInfo soyFileHeaderInfo;
    private final String templateName;
    @Nullable
    private final String partialTemplateName;
    private final boolean isPrivate;
    private final AutoescapeMode autoescapeMode;
    @Nullable
    private final SanitizedContent.ContentKind contentKind;
    private String soyDoc;
    private String soyDocDesc;
    private ImmutableList<SoyDocParam> soyDocParams;
    private final ImmutableList<String> paramSrcsWithIncorrectSyntax;

    protected TemplateNode(int id, SoyFileHeaderInfo soyFileHeaderInfo, String commandName, CommandTextInfo commandTextInfo, @Nullable String soyDoc) {
        super(id, commandName, commandTextInfo.commandText);
        this.soyFileHeaderInfo = soyFileHeaderInfo;
        this.templateName = commandTextInfo.templateName;
        this.partialTemplateName = commandTextInfo.partialTemplateName;
        this.isPrivate = commandTextInfo.isPrivate;
        this.autoescapeMode = commandTextInfo.autoescapeMode;
        SanitizedContent.ContentKind contentKind = commandTextInfo.contentKind;
        if (contentKind == null && this.autoescapeMode == AutoescapeMode.STRICT) {
            contentKind = SanitizedContent.ContentKind.HTML;
        } else if (contentKind != null && this.autoescapeMode != AutoescapeMode.STRICT) {
            throw SoySyntaxException.createWithoutMetaInfo("kind=\"...\" attribute is only valid with autoescape=\"strict\".");
        }
        this.contentKind = contentKind;
        this.maybeSetSyntaxVersion(commandTextInfo.syntaxVersion);
        this.soyDoc = soyDoc;
        if (soyDoc != null) {
            Preconditions.checkArgument((soyDoc.startsWith("/**") && soyDoc.endsWith("*/") ? 1 : 0) != 0);
            String cleanedSoyDoc = TemplateNode.cleanSoyDocHelper(soyDoc);
            this.soyDocDesc = TemplateNode.parseSoyDocDescHelper(cleanedSoyDoc);
            Pair<List<SoyDocParam>, List<String>> soyDocParamsInfo = TemplateNode.parseSoyDocDeclsHelper(cleanedSoyDoc);
            this.soyDocParams = ImmutableList.copyOf((Collection)((Collection)soyDocParamsInfo.first));
            this.paramSrcsWithIncorrectSyntax = ImmutableList.copyOf((Collection)((Collection)soyDocParamsInfo.second));
            if (this.paramSrcsWithIncorrectSyntax.size() > 0) {
                this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
            }
        } else {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
            this.soyDocDesc = null;
            this.soyDocParams = null;
            this.paramSrcsWithIncorrectSyntax = null;
        }
        if (this.partialTemplateName != null) {
            if (!BaseUtils.isIdentifierWithLeadingDot(this.partialTemplateName)) {
                throw SoySyntaxException.createWithoutMetaInfo("Invalid template name \"" + this.partialTemplateName + "\".");
            }
        } else if (!BaseUtils.isDottedIdentifier(this.templateName)) {
            throw SoySyntaxException.createWithoutMetaInfo("Invalid template name \"" + this.templateName + "\".");
        }
    }

    private static String cleanSoyDocHelper(String soyDoc) {
        soyDoc = NEWLINE.matcher(soyDoc).replaceAll("\n");
        soyDoc = SOY_DOC_START.matcher(soyDoc).replaceFirst("");
        soyDoc = SOY_DOC_END.matcher(soyDoc).replaceFirst("");
        ArrayList lines = Lists.newArrayList((Iterable)Splitter.on((Pattern)NEWLINE).split((CharSequence)soyDoc));
        TemplateNode.removeCommonStartCharHelper(lines, ' ', true);
        if (TemplateNode.removeCommonStartCharHelper(lines, '*', false) == 1) {
            TemplateNode.removeCommonStartCharHelper(lines, ' ', true);
        }
        return Joiner.on((char)'\n').join((Iterable)lines);
    }

    private static int removeCommonStartCharHelper(List<String> lines, char charToRemove, boolean shouldRemoveMultiple) {
        int numCharsToRemove = 0;
        boolean isStillCounting = true;
        do {
            boolean areAllLinesEmpty = true;
            for (String line : lines) {
                if (line.length() == 0) continue;
                areAllLinesEmpty = false;
                if (line.length() > numCharsToRemove && line.charAt(numCharsToRemove) == charToRemove) continue;
                isStillCounting = false;
                break;
            }
            if (areAllLinesEmpty) {
                isStillCounting = false;
            }
            if (!isStillCounting) continue;
            ++numCharsToRemove;
        } while (isStillCounting && shouldRemoveMultiple);
        if (numCharsToRemove > 0) {
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (line.length() == 0) continue;
                lines.set(i, line.substring(numCharsToRemove));
            }
        }
        return numCharsToRemove;
    }

    private static String parseSoyDocDescHelper(String cleanedSoyDoc) {
        Matcher paramMatcher = SOY_DOC_DECL_PATTERN.matcher(cleanedSoyDoc);
        int endOfDescPos = paramMatcher.find() ? paramMatcher.start() : cleanedSoyDoc.length();
        String soyDocDesc = cleanedSoyDoc.substring(0, endOfDescPos);
        return CharMatcher.WHITESPACE.trimTrailingFrom((CharSequence)soyDocDesc);
    }

    private static Pair<List<SoyDocParam>, List<String>> parseSoyDocDeclsHelper(String cleanedSoyDoc) {
        ArrayList soyDocParams = Lists.newArrayList();
        ArrayList paramSrcsWithIncorrectSyntax = Lists.newArrayListWithCapacity((int)0);
        HashSet seenParamKeys = Sets.newHashSet();
        Matcher matcher = SOY_DOC_DECL_PATTERN.matcher(cleanedSoyDoc);
        boolean isFound = matcher.find();
        while (isFound) {
            String declKeyword = matcher.group(1);
            String declText = matcher.group(2);
            int descStart = matcher.end();
            isFound = matcher.find();
            int descEnd = isFound ? matcher.start() : cleanedSoyDoc.length();
            String desc = cleanedSoyDoc.substring(descStart, descEnd).trim();
            if (declKeyword.equals("@param") || declKeyword.equals("@param?")) {
                if (!SOY_DOC_PARAM_TEXT_PATTERN.matcher(declText).matches()) {
                    if (declText.startsWith("{")) {
                        paramSrcsWithIncorrectSyntax.add(declKeyword + " " + declText);
                        continue;
                    }
                    throw SoySyntaxException.createWithoutMetaInfo("Invalid SoyDoc declaration \"" + declKeyword + " " + declText + "\".");
                }
                if (declText.equals("ij")) {
                    throw SoySyntaxException.createWithoutMetaInfo("Invalid param name 'ij' ('ij' is for injected data ref).");
                }
                if (seenParamKeys.contains(declText)) {
                    throw SoySyntaxException.createWithoutMetaInfo("Duplicate declaration of param in SoyDoc: '" + declText + "'.");
                }
                seenParamKeys.add(declText);
                soyDocParams.add(new SoyDocParam(declText, declKeyword.equals("@param"), desc));
                continue;
            }
            throw new AssertionError();
        }
        return Pair.of(soyDocParams, paramSrcsWithIncorrectSyntax);
    }

    protected TemplateNode(TemplateNode orig) {
        super(orig);
        this.soyFileHeaderInfo = orig.soyFileHeaderInfo;
        this.templateName = orig.templateName;
        this.partialTemplateName = orig.partialTemplateName;
        this.isPrivate = orig.isPrivate;
        this.autoescapeMode = orig.autoescapeMode;
        this.contentKind = orig.contentKind;
        this.soyDoc = orig.soyDoc;
        this.soyDocDesc = orig.soyDocDesc;
        this.soyDocParams = orig.soyDocParams;
        this.paramSrcsWithIncorrectSyntax = orig.paramSrcsWithIncorrectSyntax;
    }

    public SoyFileHeaderInfo getSoyFileHeaderInfo() {
        return this.soyFileHeaderInfo;
    }

    public String getDelPackageName() {
        return this.soyFileHeaderInfo.delPackageName;
    }

    public abstract String getTemplateNameForUserMsgs();

    public String getTemplateName() {
        return this.templateName;
    }

    public String getPartialTemplateName() {
        return this.partialTemplateName;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public AutoescapeMode getAutoescapeMode() {
        return this.autoescapeMode;
    }

    @Override
    @Nullable
    public SanitizedContent.ContentKind getContentKind() {
        return this.contentKind;
    }

    public void clearSoyDocStrings() {
        this.soyDoc = null;
        this.soyDocDesc = null;
        ArrayList newSoyDocParams = Lists.newArrayListWithCapacity((int)this.soyDocParams.size());
        for (SoyDocParam origParam : this.soyDocParams) {
            newSoyDocParams.add(new SoyDocParam(origParam.key, origParam.isRequired, null));
        }
        this.soyDocParams = ImmutableList.copyOf((Collection)newSoyDocParams);
    }

    public String getSoyDoc() {
        return this.soyDoc;
    }

    public String getSoyDocDesc() {
        return this.soyDocDesc;
    }

    public List<SoyDocParam> getSoyDocParams() {
        return this.soyDocParams;
    }

    public ImmutableList<String> getParamSrcsWithIncorrectSyntax() {
        return this.paramSrcsWithIncorrectSyntax;
    }

    @Override
    public SoyFileNode getParent() {
        return (SoyFileNode)super.getParent();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        if (this.soyDoc != null) {
            sb.append(this.soyDoc).append("\n");
        }
        sb.append(this.getTagString()).append("\n");
        StringBuilder bodySb = new StringBuilder();
        this.appendSourceStringForChildren(bodySb);
        int bodyLen = bodySb.length();
        if (bodyLen != 0) {
            if (bodyLen != 1 && bodySb.charAt(bodyLen - 1) == ' ') {
                bodySb.replace(bodyLen - 1, bodyLen, "{sp}");
            }
            if (bodySb.charAt(0) == ' ') {
                bodySb.replace(0, 1, "{sp}");
            }
        }
        sb.append((CharSequence)bodySb);
        sb.append("\n");
        sb.append("{/").append(this.getCommandName()).append("}\n");
        return sb.toString();
    }

    @Immutable
    public static final class SoyDocParam
    extends SoyDocDecl {
        public final String key;
        public final boolean isRequired;

        public SoyDocParam(String key, boolean isRequired, @Nullable String desc) {
            super(desc);
            Preconditions.checkArgument((key != null ? 1 : 0) != 0);
            this.key = key;
            this.isRequired = isRequired;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SoyDocParam)) {
                return false;
            }
            SoyDocParam other = (SoyDocParam)o;
            return this.key.equals(other.key) && this.isRequired == other.isRequired;
        }

        public int hashCode() {
            return this.key.hashCode() + (this.isRequired ? 1 : 0);
        }
    }

    @Immutable
    private static abstract class SoyDocDecl {
        @Nullable
        public final String desc;

        private SoyDocDecl(@Nullable String desc) {
            this.desc = desc;
        }
    }

    @Immutable
    protected static class CommandTextInfo {
        public final String commandText;
        public final String templateName;
        @Nullable
        public final String partialTemplateName;
        public final boolean isPrivate;
        public final AutoescapeMode autoescapeMode;
        @Nullable
        public final SanitizedContent.ContentKind contentKind;
        public final SoyNode.SyntaxVersion syntaxVersion;

        public CommandTextInfo(String commandText, String templateName, @Nullable String partialTemplateName, boolean isPrivate, AutoescapeMode autoescapeMode, SanitizedContent.ContentKind contentKind, SoyNode.SyntaxVersion syntaxVersion) {
            Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(templateName));
            Preconditions.checkArgument((partialTemplateName == null || BaseUtils.isIdentifierWithLeadingDot(partialTemplateName) ? 1 : 0) != 0);
            this.commandText = commandText;
            this.templateName = templateName;
            this.partialTemplateName = partialTemplateName;
            this.isPrivate = isPrivate;
            this.autoescapeMode = autoescapeMode;
            this.contentKind = contentKind;
            this.syntaxVersion = syntaxVersion;
        }
    }

    @Immutable
    public static class SoyFileHeaderInfo {
        @Nullable
        public final String delPackageName;
        public final int defaultDelPriority;
        @Nullable
        public final String namespace;
        public final AutoescapeMode defaultAutoescapeMode;

        public SoyFileHeaderInfo(SoyFileNode soyFileNode) {
            this(soyFileNode.getDelPackageName(), soyFileNode.getNamespace(), soyFileNode.getDefaultAutoescapeMode());
        }

        public SoyFileHeaderInfo(String namespace) {
            this(null, namespace, AutoescapeMode.TRUE);
        }

        public SoyFileHeaderInfo(String delPackageName, String namespace, AutoescapeMode defaultAutoescapeMode) {
            this.delPackageName = delPackageName;
            this.defaultDelPriority = delPackageName == null ? 0 : 1;
            this.namespace = namespace;
            this.defaultAutoescapeMode = defaultAutoescapeMode;
        }
    }
}

