/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.exprparse.ExprParseUtils;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class TemplateDelegateNode
extends TemplateNode {
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("([.\\w]+) ( \\s .* | $ )", 36);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("deltemplate", new CommandTextAttributesParser.Attribute("variant", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("autoescape", AutoescapeMode.getAttributeValues(), null), new CommandTextAttributesParser.Attribute("kind", NodeContentKinds.getAttributeValues(), null));
    private final String delTemplateName;
    private final String delTemplateVariant;
    private final DelTemplateKey delTemplateKey;
    private final int delPriority;

    public TemplateDelegateNode(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String commandText, @Nullable String soyDoc) throws SoySyntaxException {
        this(id, soyFileHeaderInfo, TemplateDelegateNode.parseCommandTextHelper(id, soyFileHeaderInfo, commandText), soyDoc);
    }

    public TemplateDelegateNode(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String delTemplateName, String delTemplateVariant, int delPriority, AutoescapeMode autoescapeMode, SanitizedContent.ContentKind contentKind, @Nullable String soyDoc) {
        this(id, soyFileHeaderInfo, TemplateDelegateNode.buildCommandTextInfoHelper(id, soyFileHeaderInfo, null, delTemplateName, delTemplateVariant, delPriority, autoescapeMode, contentKind), soyDoc);
        Preconditions.checkState((this.getContentKind() != null == (this.getAutoescapeMode() == AutoescapeMode.STRICT) ? 1 : 0) != 0);
    }

    private static final CommandTextInfo parseCommandTextHelper(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String commandText) {
        String delTemplateVariant;
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(commandText);
        if (!matcher.matches()) {
            throw SoySyntaxException.createWithoutMetaInfo("Invalid 'deltemplate' command text \"" + commandText + "\".");
        }
        String delTemplateName = matcher.group(1);
        if (!BaseUtils.isDottedIdentifier(delTemplateName)) {
            throw SoySyntaxException.createWithoutMetaInfo("Invalid delegate template name \"" + delTemplateName + "\".");
        }
        Map<String, String> attributes = ATTRIBUTES_PARSER.parse(matcher.group(2).trim());
        int delPriority = soyFileHeaderInfo.defaultDelPriority;
        if (delPriority < 0 || delPriority > 1) {
            throw SoySyntaxException.createWithoutMetaInfo(String.format("Invalid delegate template priority %s (valid range is 0 to %s).", delPriority, 1));
        }
        String variantExprText = attributes.get("variant");
        if (variantExprText == null) {
            delTemplateVariant = "";
        } else {
            ExprRootNode<?> variantExpr = ExprParseUtils.parseExprElseThrowSoySyntaxException(variantExprText, String.format("Invalid variant expression \"%s\" in 'deltemplate'.", variantExprText));
            if (!(variantExpr.getChild(0) instanceof StringNode)) {
                throw SoySyntaxException.createWithoutMetaInfo("Invalid variant expression \"" + variantExprText + "\" in 'deltemplate'" + " (must be a string literal that contains an identifier).");
            }
            delTemplateVariant = ((StringNode)variantExpr.getChild(0)).getValue();
            if (delTemplateVariant.length() > 0 && !BaseUtils.isIdentifier(delTemplateVariant)) {
                throw SoySyntaxException.createWithoutMetaInfo("Invalid variant \"" + delTemplateVariant + "\" in 'deltemplate'" + " (must be an identifier).");
            }
        }
        String autoescapeModeStr = attributes.get("autoescape");
        AutoescapeMode autoescapeMode = autoescapeModeStr != null ? AutoescapeMode.forAttributeValue(autoescapeModeStr) : soyFileHeaderInfo.defaultAutoescapeMode;
        SanitizedContent.ContentKind contentKind = attributes.get("kind") != null ? NodeContentKinds.forAttributeValue(attributes.get("kind")) : null;
        return TemplateDelegateNode.buildCommandTextInfoHelper(id, soyFileHeaderInfo, commandText, delTemplateName, delTemplateVariant, delPriority, autoescapeMode, contentKind);
    }

    private static CommandTextInfo buildCommandTextInfoHelper(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, @Nullable String commandText, String delTemplateName, String delTemplateVariant, int delPriority, AutoescapeMode autoescapeMode, SanitizedContent.ContentKind contentKind) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(delTemplateName));
        Preconditions.checkArgument((delTemplateVariant.length() == 0 || BaseUtils.isIdentifier(delTemplateVariant) ? 1 : 0) != 0);
        Preconditions.checkArgument((0 <= delPriority && delPriority <= 1 ? 1 : 0) != 0);
        if (commandText == null) {
            commandText = delTemplateName + (delTemplateVariant.length() == 0 ? "" : " variant=\"" + delTemplateVariant + "\"") + " autoescape=\"" + autoescapeMode.getAttributeValue() + "\"";
            if (contentKind != null) {
                commandText = commandText + " kind=\"" + NodeContentKinds.toAttributeValue(contentKind) + '\"';
            }
        }
        String delPackageAndDelTemplateStr = (soyFileHeaderInfo.delPackageName == null ? "" : soyFileHeaderInfo.delPackageName) + "~" + delTemplateName + "~" + delTemplateVariant;
        String collisionPreventionStr = BaseUtils.computePartialSha1AsHexString(delPackageAndDelTemplateStr, 32);
        String generatedPartialTemplateName = ".__deltemplate_s" + id + "_" + collisionPreventionStr;
        String generatedTemplateName = soyFileHeaderInfo.namespace + generatedPartialTemplateName;
        return new CommandTextInfo(commandText, delTemplateName, delTemplateVariant, delPriority, generatedTemplateName, generatedPartialTemplateName, autoescapeMode, contentKind);
    }

    private TemplateDelegateNode(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, CommandTextInfo commandTextInfo, @Nullable String soyDoc) {
        super(id, soyFileHeaderInfo, "deltemplate", commandTextInfo, soyDoc);
        if (soyDoc == null) {
            throw SoySyntaxException.createWithoutMetaInfo("Encountered delegate template " + commandTextInfo.delTemplateName + " without SoyDoc.");
        }
        this.delTemplateName = commandTextInfo.delTemplateName;
        this.delTemplateVariant = commandTextInfo.delTemplateVariant;
        this.delTemplateKey = new DelTemplateKey(this.delTemplateName, this.delTemplateVariant);
        this.delPriority = commandTextInfo.delPriority;
    }

    protected TemplateDelegateNode(TemplateDelegateNode orig) {
        super(orig);
        this.delTemplateName = orig.delTemplateName;
        this.delTemplateVariant = orig.delTemplateVariant;
        this.delTemplateKey = orig.delTemplateKey;
        this.delPriority = orig.delPriority;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_DELEGATE_NODE;
    }

    @Override
    public String getTemplateNameForUserMsgs() {
        return this.delTemplateKey.toString();
    }

    public String getDelTemplateName() {
        return this.delTemplateName;
    }

    public String getDelTemplateVariant() {
        return this.delTemplateVariant;
    }

    public DelTemplateKey getDelTemplateKey() {
        return this.delTemplateKey;
    }

    public int getDelPriority() {
        return this.delPriority;
    }

    @Override
    public TemplateDelegateNode clone() {
        return new TemplateDelegateNode(this);
    }

    @Immutable
    private static class CommandTextInfo
    extends TemplateNode.CommandTextInfo {
        public final String delTemplateName;
        public final String delTemplateVariant;
        public final int delPriority;

        public CommandTextInfo(String commandText, String delTemplateName, String delTemplateVariant, int delPriority, String templateName, @Nullable String partialTemplateName, AutoescapeMode autoescapeMode, SanitizedContent.ContentKind contentKind) {
            super(commandText, templateName, partialTemplateName, false, autoescapeMode, contentKind, SoyNode.SyntaxVersion.V2);
            this.delTemplateName = delTemplateName;
            this.delTemplateVariant = delTemplateVariant;
            this.delPriority = delPriority;
        }
    }

    public static final class DelTemplateKey {
        public final String name;
        public final String variant;

        public DelTemplateKey(String name, String variant) {
            this.name = name;
            this.variant = variant;
        }

        public boolean equals(Object other) {
            if (!(other instanceof DelTemplateKey)) {
                return false;
            }
            DelTemplateKey otherKey = (DelTemplateKey)other;
            return this.name.equals(otherKey.name) && this.variant.equals(otherKey.variant);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.variant});
        }

        public String toString() {
            return this.name + (this.variant.length() == 0 ? "" : ":" + this.variant);
        }
    }
}

