/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class TemplateBasicNode
extends TemplateNode {
    private static final Pattern NONATTRIBUTE_TEMPLATE_NAME = Pattern.compile("^ (?! name=\") [.\\w]+ (?= \\s | $)", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("template", new CommandTextAttributesParser.Attribute("name", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("private", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, "false"), new CommandTextAttributesParser.Attribute("override", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, null), new CommandTextAttributesParser.Attribute("autoescape", AutoescapeMode.getAttributeValues(), null), new CommandTextAttributesParser.Attribute("kind", NodeContentKinds.getAttributeValues(), null));
    private final boolean isOverride;

    public TemplateBasicNode(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String commandText, @Nullable String soyDoc) throws SoySyntaxException {
        this(id, soyFileHeaderInfo, TemplateBasicNode.parseCommandTextHelper(soyFileHeaderInfo, commandText), soyDoc);
    }

    private static final CommandTextInfo parseCommandTextHelper(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String commandText) {
        boolean isOverride;
        String templateName;
        String partialTemplateName;
        SoyNode.SyntaxVersion syntaxVersion = SoyNode.SyntaxVersion.V2;
        String commandTextForParsing = commandText;
        String nameAttr = null;
        Matcher ntnMatcher = NONATTRIBUTE_TEMPLATE_NAME.matcher(commandTextForParsing);
        if (ntnMatcher.find()) {
            nameAttr = ntnMatcher.group();
            commandTextForParsing = commandTextForParsing.substring(ntnMatcher.end()).trim();
        }
        Map<String, String> attributes = ATTRIBUTES_PARSER.parse(commandTextForParsing);
        if (nameAttr == null) {
            nameAttr = attributes.get("name");
            if (nameAttr == null) {
                throw SoySyntaxException.createWithoutMetaInfo("Invalid 'template' command missing template name: {template " + commandText + "}.");
            }
        } else if (attributes.get("name") != null) {
            throw SoySyntaxException.createWithoutMetaInfo("Invalid 'template' command with template name declared multiple times (" + nameAttr + ", " + attributes.get("name") + ").");
        }
        if (BaseUtils.isIdentifierWithLeadingDot(nameAttr)) {
            if (soyFileHeaderInfo.namespace == null) {
                throw SoySyntaxException.createWithoutMetaInfo("Missing namespace in Soy file containing 'template' with namespace-relative name ({template " + commandText + "}).");
            }
            partialTemplateName = nameAttr;
            templateName = soyFileHeaderInfo.namespace + partialTemplateName;
        } else if (BaseUtils.isDottedIdentifier(nameAttr)) {
            syntaxVersion = SoyNode.SyntaxVersion.V1;
            templateName = nameAttr;
            partialTemplateName = null;
        } else {
            throw SoySyntaxException.createWithoutMetaInfo("Invalid template name \"" + nameAttr + "\".");
        }
        boolean isPrivate = attributes.get("private").equals("true");
        String overrideAttr = attributes.get("override");
        if (overrideAttr == null) {
            isOverride = false;
        } else {
            syntaxVersion = SoyNode.SyntaxVersion.V1;
            isOverride = overrideAttr.equals("true");
        }
        String autoescapeModeStr = attributes.get("autoescape");
        AutoescapeMode autoescapeMode = autoescapeModeStr != null ? AutoescapeMode.forAttributeValue(autoescapeModeStr) : soyFileHeaderInfo.defaultAutoescapeMode;
        SanitizedContent.ContentKind contentKind = attributes.get("kind") != null ? NodeContentKinds.forAttributeValue(attributes.get("kind")) : null;
        return new CommandTextInfo(commandText, templateName, partialTemplateName, isOverride, isPrivate, autoescapeMode, contentKind, syntaxVersion);
    }

    public TemplateBasicNode(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String templateName, @Nullable String partialTemplateName, boolean useAttrStyleForName, boolean isOverride, boolean isPrivate, AutoescapeMode autoescapeMode, SanitizedContent.ContentKind contentKind, @Nullable String soyDoc, SoyNode.SyntaxVersion syntaxVersion) {
        this(id, soyFileHeaderInfo, TemplateBasicNode.buildCommandTextInfoHelper(templateName, partialTemplateName, useAttrStyleForName, isOverride, isPrivate, autoescapeMode, contentKind, syntaxVersion), soyDoc);
    }

    private static final CommandTextInfo buildCommandTextInfoHelper(String templateName, @Nullable String partialTemplateName, boolean useAttrStyleForName, boolean isOverride, boolean isPrivate, AutoescapeMode autoescapeMode, SanitizedContent.ContentKind contentKind, SoyNode.SyntaxVersion syntaxVersion) {
        String templateNameInCommandText;
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(templateName));
        Preconditions.checkArgument((partialTemplateName == null || BaseUtils.isIdentifierWithLeadingDot(partialTemplateName) ? 1 : 0) != 0);
        Preconditions.checkArgument((contentKind != null == (autoescapeMode == AutoescapeMode.STRICT) ? 1 : 0) != 0);
        StringBuilder commandText = new StringBuilder();
        String string = templateNameInCommandText = partialTemplateName != null ? partialTemplateName : templateName;
        if (useAttrStyleForName) {
            commandText.append("name=\"").append(templateNameInCommandText).append('\"');
        } else {
            commandText.append(templateNameInCommandText);
        }
        commandText.append(" autoescape=\"").append(autoescapeMode.getAttributeValue()).append('\"');
        if (contentKind != null) {
            commandText.append(" kind=\"" + NodeContentKinds.toAttributeValue(contentKind) + '\"');
        }
        if (isOverride) {
            commandText.append(" override=\"true\"");
        }
        if (isPrivate) {
            commandText.append(" private=\"true\"");
        }
        return new CommandTextInfo(commandText.toString(), templateName, partialTemplateName, isOverride, isPrivate, autoescapeMode, contentKind, syntaxVersion);
    }

    private TemplateBasicNode(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, CommandTextInfo commandTextInfo, @Nullable String soyDoc) {
        super(id, soyFileHeaderInfo, "template", commandTextInfo, soyDoc);
        this.isOverride = commandTextInfo.isOverride;
    }

    protected TemplateBasicNode(TemplateBasicNode orig) {
        super(orig);
        this.isOverride = orig.isOverride;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_BASIC_NODE;
    }

    @Override
    public String getTemplateNameForUserMsgs() {
        return this.getTemplateName();
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    @Override
    public TemplateBasicNode clone() {
        return new TemplateBasicNode(this);
    }

    @Immutable
    private static class CommandTextInfo
    extends TemplateNode.CommandTextInfo {
        public final boolean isOverride;

        public CommandTextInfo(String commandText, String templateName, @Nullable String partialTemplateName, boolean isOverride, boolean isPrivate, AutoescapeMode autoescapeMode, SanitizedContent.ContentKind contentKind, SoyNode.SyntaxVersion syntaxVersion) {
            super(commandText, templateName, partialTemplateName, isPrivate, autoescapeMode, contentKind, syntaxVersion);
            this.isOverride = isOverride;
        }
    }
}

