/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoyFileKind;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SoyFileNode
extends AbstractParentSoyNode<TemplateNode>
implements SoyNode.SplitLevelTopNode<TemplateNode> {
    private static final Pattern CMD_TEXT_PATTERN = Pattern.compile("\\s* ([a-zA-Z_][a-zA-Z_0-9]*(?:[.][a-zA-Z_][a-zA-Z_0-9]*)*) (\\s .*)?", 4);
    private static final AutoescapeMode DEFAULT_FILE_WIDE_DEFAULT_AUTOESCAPE_MODE = AutoescapeMode.TRUE;
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("namespace", new CommandTextAttributesParser.Attribute("autoescape", AutoescapeMode.getAttributeValues(), DEFAULT_FILE_WIDE_DEFAULT_AUTOESCAPE_MODE.getAttributeValue()));
    private final SoyFileKind soyFileKind;
    @Nullable
    private final String delPackageName;
    @Nullable
    private final String namespace;
    private final AutoescapeMode defaultAutoescapeMode;
    private final ImmutableMap<String, String> aliasToNamespaceMap;
    @Nullable
    private String fileName;

    public SoyFileNode(int id, SoyFileKind soyFileKind, @Nullable String delpackageCmdText, @Nullable String namespaceCmdText, @Nullable List<String> aliasCmdTexts) throws SoySyntaxException {
        super(id);
        this.soyFileKind = soyFileKind;
        if (delpackageCmdText != null) {
            this.delPackageName = delpackageCmdText.trim();
            if (!BaseUtils.isDottedIdentifier(this.delPackageName)) {
                throw SoySyntaxException.createWithoutMetaInfo("Invalid delegate package name \"" + this.delPackageName + "\".");
            }
        } else {
            this.delPackageName = null;
        }
        String namespace = null;
        AutoescapeMode defaultAutoescapeMode = DEFAULT_FILE_WIDE_DEFAULT_AUTOESCAPE_MODE;
        if (namespaceCmdText != null) {
            Matcher matcher = CMD_TEXT_PATTERN.matcher(namespaceCmdText);
            if (matcher.matches()) {
                Map<String, String> attributes;
                namespace = matcher.group(1);
                String attributeText = matcher.group(2);
                if (attributeText != null && (attributes = ATTRIBUTES_PARSER.parse(attributeText = attributeText.trim())).containsKey("autoescape")) {
                    defaultAutoescapeMode = AutoescapeMode.forAttributeValue(attributes.get("autoescape"));
                }
            } else {
                throw SoySyntaxException.createWithoutMetaInfo("Invalid namespace command text \"" + namespaceCmdText + "\".");
            }
        }
        this.namespace = namespace;
        this.defaultAutoescapeMode = defaultAutoescapeMode;
        if (namespace == null) {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
        } else if (!BaseUtils.isDottedIdentifier(namespace)) {
            throw SoySyntaxException.createWithoutMetaInfo("Invalid namespace name \"" + namespace + "\".");
        }
        if (aliasCmdTexts != null) {
            Preconditions.checkNotNull((Object)this.namespace);
            String aliasForFileNamespace = BaseUtils.extractPartAfterLastDot(this.namespace);
            LinkedHashMap tempAliasToNamespaceMap = Maps.newLinkedHashMap();
            for (String aliasCmdText : aliasCmdTexts) {
                String aliasNamespace = aliasCmdText.trim();
                Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(aliasNamespace));
                String alias = BaseUtils.extractPartAfterLastDot(aliasNamespace);
                if (alias.equals(aliasForFileNamespace) && !aliasNamespace.equals(this.namespace)) {
                    throw SoySyntaxException.createWithoutMetaInfo(String.format("Not allowed to alias the last part of the file's namespace to some other namespace (file's namespace is \"%s\", while aliased namespace is \"%s\").", this.namespace, aliasNamespace));
                }
                if (tempAliasToNamespaceMap.containsKey(alias)) {
                    throw SoySyntaxException.createWithoutMetaInfo(String.format("Found 2 namespaces with the same alias (\"%s\" and \"%s\").", tempAliasToNamespaceMap.get(alias), aliasNamespace));
                }
                tempAliasToNamespaceMap.put(alias, aliasNamespace);
            }
            this.aliasToNamespaceMap = ImmutableMap.copyOf((Map)tempAliasToNamespaceMap);
        } else {
            this.aliasToNamespaceMap = ImmutableMap.of();
        }
    }

    protected SoyFileNode(SoyFileNode orig) {
        super(orig);
        this.soyFileKind = orig.soyFileKind;
        this.delPackageName = orig.delPackageName;
        this.namespace = orig.namespace;
        this.defaultAutoescapeMode = orig.defaultAutoescapeMode;
        this.aliasToNamespaceMap = orig.aliasToNamespaceMap;
        this.fileName = orig.fileName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SOY_FILE_NODE;
    }

    public SoyFileKind getSoyFileKind() {
        return this.soyFileKind;
    }

    @Nullable
    public String getDelPackageName() {
        return this.delPackageName;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public AutoescapeMode getDefaultAutoescapeMode() {
        return this.defaultAutoescapeMode;
    }

    public ImmutableMap<String, String> getAliasToNamespaceMap() {
        return this.aliasToNamespaceMap;
    }

    @Override
    public void setSourceLocation(SourceLocation srcLoc) {
        super.setSourceLocation(srcLoc);
        String filePath = srcLoc.getFilePath();
        int lastSlashIndex = CharMatcher.anyOf((CharSequence)"/\\").lastIndexIn((CharSequence)filePath);
        this.fileName = lastSlashIndex != -1 && lastSlashIndex != filePath.length() - 1 ? filePath.substring(lastSlashIndex + 1) : filePath;
    }

    public void setFilePath(String filePath) {
        this.setSourceLocation(new SourceLocation(filePath, 0));
    }

    public String getFilePath() {
        return this.getSourceLocation().getFilePath();
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        if (this.delPackageName != null) {
            sb.append("{delpackage ").append(this.delPackageName).append("}\n");
        }
        if (this.namespace != null) {
            sb.append("{namespace ").append(this.namespace).append("}\n");
        }
        if (this.aliasToNamespaceMap.size() > 0) {
            sb.append("\n");
            for (String aliasNamespace : this.aliasToNamespaceMap.values()) {
                sb.append("{alias ").append(aliasNamespace).append("}\n");
            }
        }
        for (TemplateNode child : this.getChildren()) {
            sb.append("\n");
            sb.append(child.toSourceString());
        }
        return sb.toString();
    }

    @Override
    public SoyFileSetNode getParent() {
        return (SoyFileSetNode)super.getParent();
    }

    @Override
    public SoyFileNode clone() {
        return new SoyFileNode(this);
    }
}

