/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExprParseUtils;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MsgPluralNode
extends AbstractParentCommandNode<CaseOrDefaultNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<CaseOrDefaultNode>,
SoyNode.ExprHolderNode {
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("(.+?) ( \\s+ offset= .+ )?", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("plural", new CommandTextAttributesParser.Attribute("offset", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));
    private final int offset;
    private final ExprRootNode<?> pluralExpr;

    public MsgPluralNode(int id, String commandText) throws SoySyntaxException {
        block5: {
            super(id, "plural", commandText);
            Matcher matcher = COMMAND_TEXT_PATTERN.matcher(commandText);
            if (!matcher.matches()) {
                throw SoySyntaxException.createWithoutMetaInfo("Invalid 'plural' command text \"" + commandText + "\".");
            }
            this.pluralExpr = ExprParseUtils.parseExprElseThrowSoySyntaxException(matcher.group(1), "Invalid expression in 'plural' command text \"" + commandText + "\".");
            if (matcher.group(2) != null) {
                try {
                    Map<String, String> attributes = ATTRIBUTES_PARSER.parse(matcher.group(2).trim());
                    String offsetAttribute = attributes.get("offset");
                    this.offset = Integer.parseInt(offsetAttribute);
                    if (this.offset < 0) {
                        throw SoySyntaxException.createWithoutMetaInfo("The 'offset' for plural must be a nonnegative integer.");
                    }
                    break block5;
                }
                catch (NumberFormatException nfe) {
                    throw SoySyntaxException.createCausedWithoutMetaInfo("Invalid offset in 'plural' command text \"" + commandText + "\".", nfe);
                }
            }
            this.offset = 0;
        }
    }

    protected MsgPluralNode(MsgPluralNode orig) {
        super(orig);
        this.offset = orig.offset;
        this.pluralExpr = orig.pluralExpr.clone();
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_PLURAL_NODE;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getExprText() {
        return this.pluralExpr.toSourceString();
    }

    public ExprRootNode<?> getExpr() {
        return this.pluralExpr;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)new ExprUnion(this.pluralExpr));
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public MsgPluralNode clone() {
        return new MsgPluralNode(this);
    }
}

