/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExprParseUtils;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ForeachNode
extends AbstractParentCommandNode<SoyNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<SoyNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode {
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("( [$] \\w+ ) \\s+ in \\s+ (\\S .*)", 36);
    private final String varName;
    private final ExprRootNode<?> expr;

    public ForeachNode(int id, String commandText) throws SoySyntaxException {
        super(id, "foreach", commandText);
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(commandText);
        if (!matcher.matches()) {
            throw SoySyntaxException.createWithoutMetaInfo("Invalid 'foreach' command text \"" + commandText + "\".");
        }
        this.varName = ExprParseUtils.parseVarNameElseThrowSoySyntaxException(matcher.group(1), "Invalid variable name in 'foreach' command text \"" + commandText + "\".");
        this.expr = ExprParseUtils.parseExprElseThrowSoySyntaxException(matcher.group(2), "Invalid expression in 'foreach' command text \"" + commandText + "\".");
    }

    protected ForeachNode(ForeachNode orig) {
        super(orig);
        this.varName = orig.varName;
        this.expr = orig.expr.clone();
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.FOREACH_NODE;
    }

    public String getVarName() {
        return this.varName;
    }

    public String getExprText() {
        return this.expr.toSourceString();
    }

    public ExprRootNode<?> getExpr() {
        return this.expr;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)new ExprUnion(this.expr));
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public ForeachNode clone() {
        return new ForeachNode(this);
    }
}

