/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class CallBasicNode
extends CallNode {
    private static final Pattern NONATTRIBUTE_CALLEE_NAME = Pattern.compile("^ (?! name=\" | function=\") [.\\w]+ (?= \\s | $)", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("call", new CommandTextAttributesParser.Attribute("name", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("function", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("data", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));
    private final String srcCalleeName;
    private String calleeName;

    public CallBasicNode(int id, String commandTextWithoutPhnameAttr, @Nullable String userSuppliedPlaceholderName) throws SoySyntaxException {
        this(id, CallBasicNode.parseCommandTextHelper(commandTextWithoutPhnameAttr, userSuppliedPlaceholderName), (ImmutableList<String>)ImmutableList.of());
    }

    private static final CommandTextInfo parseCommandTextHelper(String commandTextWithoutPhnameAttr, @Nullable String userSuppliedPlaceholderName) {
        String functionAttribute;
        Map<String, String> attributes;
        String nameAttribute;
        String commandText = commandTextWithoutPhnameAttr + (userSuppliedPlaceholderName != null ? " phname=\"" + userSuppliedPlaceholderName + "\"" : "");
        SoyNode.SyntaxVersion syntaxVersion = SoyNode.SyntaxVersion.V2;
        Matcher ncnMatcher = NONATTRIBUTE_CALLEE_NAME.matcher(commandTextWithoutPhnameAttr);
        if (ncnMatcher.find()) {
            commandTextWithoutPhnameAttr = ncnMatcher.replaceFirst("name=\"" + ncnMatcher.group() + "\"");
        }
        if ((nameAttribute = (attributes = ATTRIBUTES_PARSER.parse(commandTextWithoutPhnameAttr)).get("name")) == null == ((functionAttribute = attributes.get("function")) == null)) {
            throw SoySyntaxException.createWithoutMetaInfo("The 'call' command text must contain the callee name (encountered command text \"" + commandTextWithoutPhnameAttr + "\").");
        }
        if (functionAttribute != null) {
            nameAttribute = functionAttribute;
            syntaxVersion = SoyNode.SyntaxVersion.V1;
        }
        if (!BaseUtils.isIdentifierWithLeadingDot(nameAttribute) && !BaseUtils.isDottedIdentifier(nameAttribute)) {
            throw SoySyntaxException.createWithoutMetaInfo("Invalid callee name \"" + nameAttribute + "\" for 'call' command.");
        }
        String srcCalleeName = nameAttribute;
        Pair<Boolean, ExprRootNode<?>> dataAttrInfo = CallBasicNode.parseDataAttributeHelper(attributes.get("data"), commandText);
        return new CommandTextInfo(commandText, srcCalleeName, (Boolean)dataAttrInfo.first, (ExprRootNode)dataAttrInfo.second, userSuppliedPlaceholderName, syntaxVersion);
    }

    public CallBasicNode(int id, String calleeName, String srcCalleeName, boolean useAttrStyleForCalleeName, boolean isPassingData, boolean isPassingAllData, @Nullable ExprRootNode<?> dataExpr, @Nullable String userSuppliedPlaceholderName, SoyNode.SyntaxVersion syntaxVersion, ImmutableList<String> escapingDirectiveNames) {
        this(id, CallBasicNode.buildCommandTextInfoHelper(srcCalleeName, useAttrStyleForCalleeName, isPassingData, isPassingAllData, dataExpr, userSuppliedPlaceholderName, syntaxVersion), escapingDirectiveNames);
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(calleeName));
        this.calleeName = calleeName;
    }

    private static final CommandTextInfo buildCommandTextInfoHelper(String srcCalleeName, boolean useAttrStyleForCalleeName, boolean isPassingData, boolean isPassingAllData, @Nullable ExprRootNode<?> dataExpr, @Nullable String userSuppliedPlaceholderName, SoyNode.SyntaxVersion syntaxVersion) {
        Preconditions.checkArgument((BaseUtils.isIdentifierWithLeadingDot(srcCalleeName) || BaseUtils.isDottedIdentifier(srcCalleeName) ? 1 : 0) != 0);
        if (isPassingAllData) {
            Preconditions.checkArgument((boolean)isPassingData);
        }
        if (dataExpr != null) {
            Preconditions.checkArgument((isPassingData && !isPassingAllData ? 1 : 0) != 0);
        }
        String commandText = "";
        commandText = syntaxVersion == SoyNode.SyntaxVersion.V1 ? commandText + "function=\"" + srcCalleeName + '\"' : (useAttrStyleForCalleeName ? commandText + "name=\"" + srcCalleeName + '\"' : commandText + srcCalleeName);
        if (isPassingAllData) {
            commandText = commandText + " data=\"all\"";
        } else if (isPassingData) {
            assert (dataExpr != null);
            commandText = commandText + " data=\"" + dataExpr.toSourceString() + '\"';
        }
        if (userSuppliedPlaceholderName != null) {
            commandText = commandText + " phname=\"" + userSuppliedPlaceholderName + '\"';
        }
        return new CommandTextInfo(commandText, srcCalleeName, isPassingData, dataExpr, userSuppliedPlaceholderName, syntaxVersion);
    }

    private CallBasicNode(int id, CommandTextInfo commandTextInfo, ImmutableList<String> escapingDirectiveNames) {
        super(id, "call", commandTextInfo, escapingDirectiveNames);
        this.srcCalleeName = commandTextInfo.srcCalleeName;
        this.calleeName = null;
    }

    protected CallBasicNode(CallBasicNode orig) {
        super(orig);
        this.srcCalleeName = orig.srcCalleeName;
        this.calleeName = orig.calleeName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_BASIC_NODE;
    }

    public String getSrcCalleeName() {
        return this.srcCalleeName;
    }

    public void setCalleeName(String calleeName) {
        Preconditions.checkState((this.calleeName == null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(calleeName));
        this.calleeName = calleeName;
    }

    public String getCalleeName() {
        return this.calleeName;
    }

    @Override
    public CallBasicNode clone() {
        return new CallBasicNode(this);
    }

    @Immutable
    protected static class CommandTextInfo
    extends CallNode.CommandTextInfo {
        private final String srcCalleeName;

        public CommandTextInfo(String commandText, String srcCalleeName, boolean isPassingData, @Nullable ExprRootNode<?> dataExpr, @Nullable String userSuppliedPlaceholderName, SoyNode.SyntaxVersion syntaxVersion) {
            super(commandText, isPassingData, dataExpr, userSuppliedPlaceholderName, syntaxVersion);
            Preconditions.checkArgument((BaseUtils.isIdentifierWithLeadingDot(srcCalleeName) || BaseUtils.isDottedIdentifier(srcCalleeName) ? 1 : 0) != 0);
            this.srcCalleeName = srcCalleeName;
        }
    }
}

