/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.collect.Maps;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralCaseSpec;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.RenderVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgPluralRemainderNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.SoyNode;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ULocale;
import java.util.Deque;
import java.util.List;
import java.util.Map;

class RenderVisitorAssistantForMsgs
extends AbstractSoyNodeVisitor<Void> {
    private final RenderVisitor master;
    private final Deque<Map<String, SoyData>> env;
    private final SoyMsgBundle msgBundle;
    private int currPluralRemainderValue;

    RenderVisitorAssistantForMsgs(RenderVisitor master, Deque<Map<String, SoyData>> env, SoyMsgBundle msgBundle) {
        this.master = master;
        this.env = env;
        this.msgBundle = msgBundle;
        this.currPluralRemainderValue = -1;
    }

    @Override
    public Void exec(SoyNode node) {
        throw new AssertionError();
    }

    void visitForUseByMaster(SoyNode node) {
        this.visit(node);
    }

    @Override
    protected void visitMsgNode(MsgNode node) {
        SoyMsg soyMsg;
        boolean doAddEnvFrame;
        boolean bl = doAddEnvFrame = node.needsEnvFrameDuringInterp() != Boolean.FALSE;
        if (doAddEnvFrame) {
            this.env.push(Maps.newHashMap());
        }
        if (this.msgBundle != null) {
            long msgId = MsgUtils.computeMsgIdForDualFormat(node);
            soyMsg = this.msgBundle.getMsg(msgId);
        } else {
            soyMsg = null;
        }
        if (soyMsg != null) {
            List<SoyMsgPart> msgParts = soyMsg.getParts();
            if (msgParts.size() > 0) {
                SoyMsgPart firstPart = msgParts.get(0);
                if (firstPart instanceof SoyMsgPluralPart) {
                    new PlrselMsgPartsVisitor(node, new ULocale(soyMsg.getLocaleString())).visitPart((SoyMsgPluralPart)firstPart);
                } else if (firstPart instanceof SoyMsgSelectPart) {
                    new PlrselMsgPartsVisitor(node, new ULocale(soyMsg.getLocaleString())).visitPart((SoyMsgSelectPart)firstPart);
                } else {
                    for (SoyMsgPart msgPart : msgParts) {
                        if (msgPart instanceof SoyMsgRawTextPart) {
                            RenderVisitor.append(this.master.getCurrOutputBufForUseByAssistants(), ((SoyMsgRawTextPart)msgPart).getRawText());
                            continue;
                        }
                        if (msgPart instanceof SoyMsgPlaceholderPart) {
                            String placeholderName = ((SoyMsgPlaceholderPart)msgPart).getPlaceholderName();
                            this.visit(node.getRepPlaceholderNode(placeholderName));
                            continue;
                        }
                        throw new AssertionError();
                    }
                }
            }
        } else {
            this.visitChildren(node);
        }
        if (doAddEnvFrame) {
            this.env.pop();
        }
    }

    @Override
    protected void visitMsgPluralNode(MsgPluralNode node) {
        int pluralValue;
        ExprRootNode<?> pluralExpr = node.getExpr();
        try {
            pluralValue = this.master.evalForUseByAssistants(pluralExpr).integerValue();
        }
        catch (SoyDataException e) {
            throw new RenderException(String.format("Plural expression \"%s\" doesn't evaluate to integer.", pluralExpr.toSourceString()));
        }
        this.currPluralRemainderValue = pluralValue - node.getOffset();
        for (CaseOrDefaultNode child : node.getChildren()) {
            if (child instanceof MsgPluralDefaultNode) {
                this.visitChildren(child);
                break;
            }
            if (((MsgPluralCaseNode)child).getCaseNumber() != pluralValue) continue;
            this.visitChildren(child);
            break;
        }
        this.currPluralRemainderValue = -1;
    }

    @Override
    protected void visitMsgPluralRemainderNode(MsgPluralRemainderNode node) {
        RenderVisitor.append(this.master.getCurrOutputBufForUseByAssistants(), Integer.toString(this.currPluralRemainderValue));
    }

    @Override
    protected void visitMsgSelectNode(MsgSelectNode node) {
        String selectValue;
        ExprRootNode<?> selectExpr = node.getExpr();
        try {
            selectValue = this.master.evalForUseByAssistants(selectExpr).stringValue();
        }
        catch (SoyDataException e) {
            throw new RenderException(String.format("Select expression \"%s\" doesn't evaluate to string.", selectExpr.toSourceString()));
        }
        for (CaseOrDefaultNode child : node.getChildren()) {
            if (child instanceof MsgSelectDefaultNode) {
                this.visitChildren(child);
                continue;
            }
            if (!((MsgSelectCaseNode)child).getCaseValue().equals(selectValue)) continue;
            this.visitChildren(child);
            return;
        }
    }

    @Override
    protected void visitMsgPlaceholderNode(MsgPlaceholderNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        this.master.visitForUseByAssistants(node);
    }

    private class PlrselMsgPartsVisitor {
        private final MsgNode msgNode;
        private final ULocale locale;
        private int currentPluralRemainderValue;

        public PlrselMsgPartsVisitor(MsgNode msgNode, ULocale locale) {
            this.msgNode = msgNode;
            this.locale = locale;
        }

        private void visitPart(SoyMsgSelectPart selectPart) {
            String correctSelectValue;
            String selectVarName = selectPart.getSelectVarName();
            MsgSelectNode repSelectNode = this.msgNode.getRepSelectNode(selectVarName);
            ExprRootNode<?> selectExpr = repSelectNode.getExpr();
            try {
                correctSelectValue = RenderVisitorAssistantForMsgs.this.master.evalForUseByAssistants(selectExpr).stringValue();
            }
            catch (SoyDataException e) {
                throw new RenderException(String.format("Select expression \"%s\" doesn't evaluate to string.", selectExpr.toSourceString()));
            }
            List caseParts = null;
            List defaultParts = null;
            for (Pair<String, List<SoyMsgPart>> case0 : selectPart.getCases()) {
                if (case0.first == null) {
                    defaultParts = (List)case0.second;
                    continue;
                }
                if (!((String)case0.first).equals(correctSelectValue)) continue;
                caseParts = (List)case0.second;
                break;
            }
            if (caseParts == null) {
                caseParts = defaultParts;
            }
            if (caseParts != null) {
                for (SoyMsgPart casePart : caseParts) {
                    if (casePart instanceof SoyMsgSelectPart) {
                        this.visitPart((SoyMsgSelectPart)casePart);
                        continue;
                    }
                    if (casePart instanceof SoyMsgPluralPart) {
                        this.visitPart((SoyMsgPluralPart)casePart);
                        continue;
                    }
                    if (casePart instanceof SoyMsgPlaceholderPart) {
                        this.visitPart((SoyMsgPlaceholderPart)casePart);
                        continue;
                    }
                    if (casePart instanceof SoyMsgRawTextPart) {
                        this.visitPart((SoyMsgRawTextPart)casePart);
                        continue;
                    }
                    throw new RenderException("Unsupported part of type " + casePart.getClass().getName() + " under a select case.");
                }
            }
        }

        private void visitPart(SoyMsgPluralPart pluralPart) {
            int correctPluralValue;
            MsgPluralNode repPluralNode = this.msgNode.getRepPluralNode(pluralPart.getPluralVarName());
            ExprRootNode<?> pluralExpr = repPluralNode.getExpr();
            try {
                correctPluralValue = RenderVisitorAssistantForMsgs.this.master.evalForUseByAssistants(pluralExpr).integerValue();
            }
            catch (SoyDataException e) {
                throw new RenderException(String.format("Plural expression \"%s\" doesn't evaluate to integer.", pluralExpr.toSourceString()));
            }
            this.currentPluralRemainderValue = correctPluralValue - repPluralNode.getOffset();
            List caseParts = null;
            boolean hasNonExplicitCases = false;
            List otherCaseParts = null;
            for (Pair<SoyMsgPluralCaseSpec, List<SoyMsgPart>> case0 : pluralPart.getCases()) {
                SoyMsgPluralCaseSpec pluralCaseSpec = (SoyMsgPluralCaseSpec)case0.first;
                SoyMsgPluralCaseSpec.Type caseType = pluralCaseSpec.getType();
                if (caseType == SoyMsgPluralCaseSpec.Type.EXPLICIT) {
                    if (pluralCaseSpec.getExplicitValue() != correctPluralValue) continue;
                    caseParts = (List)case0.second;
                    break;
                }
                if (caseType == SoyMsgPluralCaseSpec.Type.OTHER) {
                    otherCaseParts = (List)case0.second;
                    continue;
                }
                hasNonExplicitCases = true;
            }
            if (caseParts == null && !hasNonExplicitCases) {
                caseParts = otherCaseParts;
            }
            if (caseParts == null) {
                String pluralKeyword = PluralRules.forLocale((ULocale)this.locale).select((double)this.currentPluralRemainderValue);
                SoyMsgPluralCaseSpec.Type correctCaseType = new SoyMsgPluralCaseSpec(pluralKeyword).getType();
                for (Pair<SoyMsgPluralCaseSpec, List<SoyMsgPart>> case0 : pluralPart.getCases()) {
                    if (((SoyMsgPluralCaseSpec)case0.first).getType() != correctCaseType) continue;
                    caseParts = (List)case0.second;
                    break;
                }
            }
            if (caseParts != null) {
                for (SoyMsgPart casePart : caseParts) {
                    if (casePart instanceof SoyMsgPlaceholderPart) {
                        this.visitPart((SoyMsgPlaceholderPart)casePart);
                        continue;
                    }
                    if (casePart instanceof SoyMsgRawTextPart) {
                        this.visitPart((SoyMsgRawTextPart)casePart);
                        continue;
                    }
                    if (casePart instanceof SoyMsgPluralRemainderPart) {
                        this.visitPart((SoyMsgPluralRemainderPart)casePart);
                        continue;
                    }
                    throw new RenderException("Unsupported part of type " + casePart.getClass().getName() + " under a plural case.");
                }
            }
        }

        private void visitPart(SoyMsgPluralRemainderPart remainderPart) {
            RenderVisitor.append(RenderVisitorAssistantForMsgs.this.master.getCurrOutputBufForUseByAssistants(), Integer.toString(this.currentPluralRemainderValue));
        }

        private void visitPart(SoyMsgPlaceholderPart msgPlaceholderPart) {
            RenderVisitorAssistantForMsgs.this.visit(this.msgNode.getRepPlaceholderNode(msgPlaceholderPart.getPlaceholderName()));
        }

        private void visitPart(SoyMsgRawTextPart rawTextPart) {
            RenderVisitor.append(RenderVisitorAssistantForMsgs.this.master.getCurrOutputBufForUseByAssistants(), rawTextPart.getRawText());
        }
    }
}

