/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.internal.AugmentedSoyMapData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.restricted.SoyJavaRuntimePrintDirective;
import com.google.template.soy.sharedpasses.render.EvalVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.RenderVisitorAssistantForMsgs;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class RenderVisitor
extends AbstractSoyNodeVisitor<Void> {
    protected final Map<String, SoyJavaRuntimePrintDirective> soyJavaRuntimeDirectivesMap;
    protected final EvalVisitor.EvalVisitorFactory evalVisitorFactory;
    protected final TemplateRegistry templateRegistry;
    protected final SoyMapData data;
    protected final SoyMapData ijData;
    protected final Deque<Map<String, SoyData>> env;
    protected final Set<String> activeDelPackageNames;
    protected final SoyMsgBundle msgBundle;
    protected final SoyCssRenamingMap cssRenamingMap;
    private EvalVisitor evalVisitor;
    private RenderVisitorAssistantForMsgs assistantForMsgs;
    protected Deque<Appendable> outputBufStack;
    private Appendable currOutputBuf;

    protected RenderVisitor(@Nullable Map<String, SoyJavaRuntimePrintDirective> soyJavaRuntimeDirectivesMap, EvalVisitor.EvalVisitorFactory evalVisitorFactory, Appendable outputBuf, @Nullable TemplateRegistry templateRegistry, SoyMapData data, @Nullable SoyMapData ijData, @Nullable Deque<Map<String, SoyData>> env, @Nullable Set<String> activeDelPackageNames, @Nullable SoyMsgBundle msgBundle, @Nullable SoyCssRenamingMap cssRenamingMap) {
        Preconditions.checkNotNull((Object)data);
        this.soyJavaRuntimeDirectivesMap = soyJavaRuntimeDirectivesMap;
        this.evalVisitorFactory = evalVisitorFactory;
        this.templateRegistry = templateRegistry;
        this.data = data;
        this.ijData = ijData;
        this.env = env != null ? env : new ArrayDeque();
        this.activeDelPackageNames = activeDelPackageNames;
        this.msgBundle = msgBundle;
        this.cssRenamingMap = cssRenamingMap;
        this.evalVisitor = null;
        this.assistantForMsgs = null;
        this.outputBufStack = new ArrayDeque<Appendable>();
        this.pushOutputBuf(outputBuf);
    }

    protected RenderVisitor createHelperInstance(Appendable outputBuf, SoyMapData data) {
        return new RenderVisitor(this.soyJavaRuntimeDirectivesMap, this.evalVisitorFactory, outputBuf, this.templateRegistry, data, this.ijData, null, this.activeDelPackageNames, this.msgBundle, this.cssRenamingMap);
    }

    void visitForUseByAssistants(SoyNode node) {
        this.visit(node);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        try {
            this.visitBlockHelper(node);
        }
        catch (RenderException re) {
            throw re.getTemplateName() != null ? re : re.setTemplateName(node.getTemplateName());
        }
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        RenderVisitor.append(this.currOutputBuf, node.getRawText());
    }

    @Override
    protected void visitMsgNode(MsgNode node) {
        if (this.assistantForMsgs == null) {
            this.assistantForMsgs = new RenderVisitorAssistantForMsgs(this, this.env, this.msgBundle);
        }
        this.assistantForMsgs.visitForUseByMaster(node);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        SoyData result = this.eval(node.getExprUnion().getExpr());
        if (result instanceof UndefinedData) {
            throw new RenderException("In 'print' tag, expression \"" + node.getExprText() + "\" evaluates to undefined.");
        }
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            List<ExprRootNode<?>> argsExprs = directiveNode.getArgs();
            ArrayList argsSoyDatas = Lists.newArrayListWithCapacity((int)argsExprs.size());
            for (ExprRootNode<?> argExpr : argsExprs) {
                argsSoyDatas.add(this.evalVisitor.exec(argExpr));
            }
            result = this.applyDirective(directiveNode.getName(), result, argsSoyDatas, node);
        }
        RenderVisitor.append(this.currOutputBuf, result.toString());
    }

    @Override
    protected void visitCssNode(CssNode node) {
        String mappedText;
        ExprRootNode<?> componentNameExpr = node.getComponentNameExpr();
        if (componentNameExpr != null) {
            RenderVisitor.append(this.currOutputBuf, this.eval(componentNameExpr).toString());
            RenderVisitor.append(this.currOutputBuf, "-");
        }
        String selectorText = node.getSelectorText();
        if (this.cssRenamingMap != null && (mappedText = this.cssRenamingMap.get(selectorText)) != null) {
            selectorText = mappedText;
        }
        RenderVisitor.append(this.currOutputBuf, selectorText);
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        this.env.peek().put(node.getVarName(), this.eval(node.getValueExpr()));
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        SoyData renderedBlock = this.renderBlock(node);
        if (node.getContentKind() != null) {
            renderedBlock = UnsafeSanitizedContentOrdainer.ordainAsSafe(((SoyData)renderedBlock).stringValue(), node.getContentKind());
        }
        this.env.peek().put(node.getVarName(), renderedBlock);
    }

    @Override
    protected void visitIfNode(IfNode node) {
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                if (!this.eval(icn.getExprUnion().getExpr()).toBoolean()) continue;
                this.visit(icn);
                return;
            }
            if (child instanceof IfElseNode) {
                this.visit(child);
                return;
            }
            throw new AssertionError();
        }
    }

    @Override
    protected void visitSwitchNode(SwitchNode node) {
        SoyData switchValue = this.eval(node.getExpr());
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode scn = (SwitchCaseNode)child;
                for (ExprRootNode<?> caseExpr : scn.getExprList()) {
                    if (!switchValue.equals(this.eval(caseExpr))) continue;
                    this.visit(scn);
                    return;
                }
                continue;
            }
            if (child instanceof SwitchDefaultNode) {
                this.visit(child);
                return;
            }
            throw new AssertionError();
        }
    }

    @Override
    protected void visitForeachNode(ForeachNode node) {
        SoyData dataRefValue = this.eval(node.getExpr());
        if (!(dataRefValue instanceof SoyListData)) {
            throw new RenderException("In 'foreach' command " + node.toSourceString() + ", the data reference does not resolve to a SoyListData.");
        }
        SoyListData foreachList = (SoyListData)dataRefValue;
        if (foreachList.length() > 0) {
            String varName = node.getVarName();
            HashMap newEnvFrame = Maps.newHashMap();
            newEnvFrame.put(varName + "__lastIndex", IntegerData.forValue(foreachList.length() - 1));
            this.env.push(newEnvFrame);
            for (int i = 0; i < foreachList.length(); ++i) {
                newEnvFrame.put(varName + "__index", IntegerData.forValue(i));
                newEnvFrame.put(varName, foreachList.get(i));
                this.visitChildren((ForeachNonemptyNode)node.getChild(0));
            }
            this.env.pop();
        } else if (node.numChildren() == 2) {
            this.visit((SoyNode)node.getChild(1));
        }
    }

    @Override
    protected void visitForNode(ForNode node) {
        ArrayList rangeArgValues = Lists.newArrayList();
        for (ExprRootNode<?> rangeArg : node.getRangeArgs()) {
            SoyData rangeArgValue = this.eval(rangeArg);
            if (!(rangeArgValue instanceof IntegerData)) {
                throw new RenderException("In 'for' command " + node.toSourceString() + ", the expression \"" + rangeArg.toSourceString() + "\" does not resolve to an integer.");
            }
            rangeArgValues.add(((IntegerData)rangeArgValue).getValue());
        }
        int increment = rangeArgValues.size() == 3 ? (Integer)rangeArgValues.remove(2) : 1;
        int init = rangeArgValues.size() == 2 ? (Integer)rangeArgValues.remove(0) : 0;
        int limit = (Integer)rangeArgValues.get(0);
        String localVarName = node.getVarName();
        HashMap newEnvFrame = Maps.newHashMap();
        this.env.push(newEnvFrame);
        for (int i = init; i < limit; i += increment) {
            newEnvFrame.put(localVarName, IntegerData.forValue(i));
            this.visitChildren(node);
        }
        this.env.pop();
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        TemplateBasicNode callee = this.templateRegistry.getBasicTemplate(node.getCalleeName());
        if (callee == null) {
            throw new RenderException("Attempting to render undefined template '" + node.getCalleeName() + "'.");
        }
        this.visitCallNodeHelper(node, callee);
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode node) {
        TemplateDelegateNode callee;
        String variant;
        ExprRootNode<?> variantExpr = node.getDelCalleeVariantExpr();
        if (variantExpr == null) {
            variant = "";
        } else {
            try {
                variant = this.eval(variantExpr).stringValue();
            }
            catch (SoyDataException e) {
                throw new RenderException(String.format("Variant expression \"%s\" doesn't evaluate to a string.", variantExpr.toSourceString()));
            }
        }
        TemplateDelegateNode.DelTemplateKey delegateKey = new TemplateDelegateNode.DelTemplateKey(node.getDelCalleeName(), variant);
        try {
            callee = this.templateRegistry.selectDelTemplate(delegateKey, this.activeDelPackageNames);
        }
        catch (TemplateRegistry.DelegateTemplateConflictException e) {
            throw new RenderException(e.getMessage());
        }
        if (callee == null) {
            if (node.allowsEmptyDefault()) {
                return;
            }
            throw new RenderException("Found no active impl for delegate call to '" + node.getDelCalleeName() + "' (and no attribute allowemptydefault=\"true\").");
        }
        this.visitCallNodeHelper(node, callee);
    }

    private void visitCallNodeHelper(CallNode node, TemplateNode callee) {
        SoyMapData dataToPass;
        if (node.isPassingAllData()) {
            dataToPass = this.data;
        } else if (node.isPassingData()) {
            SoyData dataRefValue = this.eval(node.getDataExpr());
            if (!(dataRefValue instanceof SoyMapData)) {
                throw new RenderException("In 'call' command " + node.toSourceString() + ", the data reference does not resolve to a SoyMapData.");
            }
            dataToPass = (SoyMapData)dataRefValue;
        } else {
            dataToPass = null;
        }
        SoyMapData callData = !node.isPassingData() ? new SoyMapData() : (node.numChildren() == 0 ? dataToPass : new AugmentedSoyMapData(dataToPass));
        for (CallParamNode child : node.getChildren()) {
            if (child instanceof CallParamValueNode) {
                callData.putSingle(child.getKey(), this.eval(((CallParamValueNode)child).getValueExprUnion().getExpr()));
                continue;
            }
            if (child instanceof CallParamContentNode) {
                CallParamContentNode childCpcn = (CallParamContentNode)child;
                SoyData renderedBlock = this.renderBlock(childCpcn);
                if (childCpcn.getContentKind() != null) {
                    renderedBlock = UnsafeSanitizedContentOrdainer.ordainAsSafe(((SoyData)renderedBlock).stringValue(), childCpcn.getContentKind());
                }
                callData.putSingle(child.getKey(), renderedBlock);
                continue;
            }
            throw new AssertionError();
        }
        if (node.getEscapingDirectiveNames().isEmpty()) {
            RenderVisitor rv = this.createHelperInstance(this.currOutputBuf, callData);
            rv.exec(callee);
        } else {
            StringBuilder calleeBuilder = new StringBuilder();
            RenderVisitor rv = this.createHelperInstance(calleeBuilder, callData);
            rv.exec(callee);
            SoyData resultData = callee.getContentKind() != null ? UnsafeSanitizedContentOrdainer.ordainAsSafe(calleeBuilder.toString(), callee.getContentKind()) : StringData.forValue(calleeBuilder.toString());
            for (String directiveName : node.getEscapingDirectiveNames()) {
                resultData = this.applyDirective(directiveName, resultData, (List<SoyData>)ImmutableList.of(), node);
            }
            RenderVisitor.append(this.currOutputBuf, ((SoyData)resultData).toString());
        }
    }

    @Override
    protected void visitCallParamNode(CallParamNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitLogNode(LogNode node) {
        System.out.println(this.renderBlock(node));
    }

    @Override
    protected void visitDebuggerNode(DebuggerNode node) {
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            if (node instanceof SoyNode.BlockNode) {
                this.visitBlockHelper((SoyNode.BlockNode)node);
            } else {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }

    private void pushOutputBuf(Appendable outputBuf) {
        this.outputBufStack.push(outputBuf);
        this.currOutputBuf = outputBuf;
    }

    private Appendable popOutputBuf() {
        Appendable poppedOutputBuf = this.outputBufStack.pop();
        this.currOutputBuf = this.outputBufStack.peek();
        return poppedOutputBuf;
    }

    Appendable getCurrOutputBufForUseByAssistants() {
        return this.currOutputBuf;
    }

    private void visitBlockHelper(SoyNode.BlockNode node) {
        if (node.needsEnvFrameDuringInterp() != Boolean.FALSE) {
            this.env.push(Maps.newHashMap());
            this.visitChildren(node);
            this.env.pop();
        } else {
            this.visitChildren(node);
        }
    }

    private StringData renderBlock(SoyNode.BlockNode block) {
        this.pushOutputBuf(new StringBuilder());
        this.visitBlockHelper(block);
        Appendable outputBuf = this.popOutputBuf();
        return StringData.forValue(outputBuf.toString());
    }

    private SoyData eval(ExprNode expr) {
        if (expr == null) {
            throw new RenderException("Cannot evaluate expression in V1 syntax.");
        }
        if (this.evalVisitor == null) {
            this.evalVisitor = this.evalVisitorFactory.create(this.data, this.ijData, this.env);
        }
        try {
            return (SoyData)this.evalVisitor.exec(expr);
        }
        catch (Exception e) {
            Throwable cause = e instanceof RenderException ? e.getCause() : e;
            throw new RenderException("When evaluating \"" + expr.toSourceString() + "\": " + e.getMessage(), cause);
        }
    }

    SoyData evalForUseByAssistants(ExprNode expr) {
        return this.eval(expr);
    }

    static void append(Appendable outputBuf, CharSequence cs) {
        try {
            outputBuf.append(cs);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected SoyData applyDirective(String directiveName, SoyData value, List<SoyData> args, SoyNode node) {
        SoyJavaRuntimePrintDirective directive = this.soyJavaRuntimeDirectivesMap.get(directiveName);
        if (directive == null) {
            throw new RenderException("Failed to find Soy print directive with name '" + directiveName + "'" + " (tag " + node.toSourceString() + ")");
        }
        if (!directive.getValidArgsSizes().contains(args.size())) {
            throw new RenderException("Print directive '" + directiveName + "' used with the wrong number of" + " arguments (tag " + node.toSourceString() + ").");
        }
        try {
            return directive.apply(value, args);
        }
        catch (RuntimeException e) {
            throw new RenderException(String.format("Failed in applying directive '%s' in tag \"%s\" due to exception: %s", directiveName, node.toSourceString(), e.getMessage()));
        }
    }
}

