/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.annotations.VisibleForTesting;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.internalutils.DataUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoytreeUtils;
import java.util.Map;
import javax.annotation.Nullable;

public class SubstituteGlobalsVisitor {
    private Map<String, PrimitiveData> compileTimeGlobals;
    private final boolean shouldAssertNoUnboundGlobals;

    public SubstituteGlobalsVisitor(@Nullable Map<String, PrimitiveData> compileTimeGlobals, boolean shouldAssertNoUnboundGlobals) {
        this.compileTimeGlobals = compileTimeGlobals;
        this.shouldAssertNoUnboundGlobals = shouldAssertNoUnboundGlobals;
    }

    public void exec(SoyFileSetNode soyTree) {
        SoytreeUtils.execOnAllV2Exprs(soyTree, new SubstituteGlobalsInExprVisitor());
    }

    @VisibleForTesting
    class SubstituteGlobalsInExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        SubstituteGlobalsInExprVisitor() {
        }

        @Override
        protected void visitGlobalNode(GlobalNode node) {
            PrimitiveData value;
            PrimitiveData primitiveData = value = SubstituteGlobalsVisitor.this.compileTimeGlobals != null ? (PrimitiveData)SubstituteGlobalsVisitor.this.compileTimeGlobals.get(node.getName()) : null;
            if (value == null) {
                if (SubstituteGlobalsVisitor.this.shouldAssertNoUnboundGlobals) {
                    throw SoySyntaxException.createWithoutMetaInfo("Found unbound global '" + node.getName() + "'.");
                }
                return;
            }
            node.getParent().replaceChild(node, DataUtils.convertPrimitiveDataToExpr(value));
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildrenAllowingConcurrentModification((ExprNode.ParentExprNode)node);
            }
        }
    }
}

