/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.sharedpasses.MarkLocalVarDataRefsVisitor;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import java.util.List;

public class ShouldEnsureDataIsDefinedVisitor {
    public boolean exec(TemplateNode template) {
        List<TemplateNode.SoyDocParam> params = template.getSoyDocParams();
        if (params != null) {
            for (TemplateNode.SoyDocParam param : params) {
                if (!param.isRequired) continue;
                return false;
            }
        }
        new MarkLocalVarDataRefsVisitor().exec(template);
        ExistsRegDataRefInExprVisitor helperVisitor = new ExistsRegDataRefInExprVisitor();
        SoytreeUtils.execOnAllV2ExprsShortcircuitably(template, helperVisitor, new SoytreeUtils.Shortcircuiter<Void>(){

            @Override
            public boolean shouldShortcircuit(AbstractExprNodeVisitor<Void> exprNodeVisitor) {
                return ((ExistsRegDataRefInExprVisitor)exprNodeVisitor).foundRegDataRef();
            }
        });
        return helperVisitor.foundRegDataRef();
    }

    private static class ExistsRegDataRefInExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private boolean foundRegDataRef = false;

        private ExistsRegDataRefInExprVisitor() {
        }

        public boolean foundRegDataRef() {
            return this.foundRegDataRef;
        }

        @Override
        protected void visitDataRefNode(DataRefNode node) {
            if (!node.isIjDataRef() && !node.isLocalVarDataRef().booleanValue()) {
                this.foundRegDataRef = true;
            }
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }
    }
}

