/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RemoveHtmlCommentsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final Pattern HTML_COMMENT = Pattern.compile("<!--.*?-->");
    private IdGenerator nodeIdGen;

    @Override
    public Void exec(SoyNode node) {
        this.nodeIdGen = null;
        this.visit(node);
        return null;
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        Matcher matcher = HTML_COMMENT.matcher(node.getRawText());
        if (!matcher.find()) {
            return;
        }
        matcher.reset();
        StringBuffer newRawText = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(newRawText, "");
        }
        matcher.appendTail(newRawText);
        if (newRawText.length() > 0) {
            if (this.nodeIdGen == null) {
                this.nodeIdGen = node.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator();
            }
            RawTextNode newRawTextNode = new RawTextNode(this.nodeIdGen.genId(), newRawText.toString());
            node.getParent().replaceChild(node, newRawTextNode);
        } else {
            node.getParent().removeChild(node);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
        }
    }
}

