/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.template.soy.sharedpasses.FindIjParamsInExprHelperVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class FindIjParamsVisitor
extends AbstractSoyNodeVisitor<IjParamsInfo> {
    private TemplateRegistry templateRegistry;
    @VisibleForTesting
    Map<TemplateNode, IjParamsInfo> templateToFinishedInfoMap;
    private TemplateVisitInfo currTemplateVisitInfo;
    private Deque<TemplateVisitInfo> activeTemplateVisitInfoStack;
    private Set<TemplateNode> activeTemplateSet;
    private Map<TemplateNode, TemplateVisitInfo> visitedTemplateToInfoMap;

    public FindIjParamsVisitor(@Nullable TemplateRegistry templateRegistry) {
        this.templateRegistry = templateRegistry;
    }

    public ImmutableMap<TemplateNode, IjParamsInfo> execForAllTemplates(SoyFileSetNode soyTree) {
        for (SoyFileNode soyFile : soyTree.getChildren()) {
            for (TemplateNode template : soyFile.getChildren()) {
                this.exec(template);
            }
        }
        return ImmutableMap.copyOf(this.templateToFinishedInfoMap);
    }

    @Override
    public IjParamsInfo exec(SoyNode node) {
        Preconditions.checkArgument((boolean)(node instanceof TemplateNode));
        TemplateNode nodeAsTemplate = (TemplateNode)node;
        if (this.templateRegistry == null) {
            SoyFileSetNode soyTree = nodeAsTemplate.getParent().getParent();
            this.templateRegistry = new TemplateRegistry(soyTree);
        }
        if (this.templateToFinishedInfoMap == null) {
            this.templateToFinishedInfoMap = Maps.newHashMap();
        }
        if (this.templateToFinishedInfoMap.containsKey(nodeAsTemplate)) {
            return this.templateToFinishedInfoMap.get(nodeAsTemplate);
        }
        this.currTemplateVisitInfo = null;
        this.activeTemplateVisitInfoStack = new ArrayDeque<TemplateVisitInfo>();
        this.activeTemplateSet = Sets.newHashSet();
        this.visitedTemplateToInfoMap = Maps.newHashMap();
        this.visit(node);
        if (this.activeTemplateVisitInfoStack.size() != 0 || this.activeTemplateSet.size() != 0) {
            throw new AssertionError();
        }
        for (TemplateVisitInfo templateVisitInfo : this.visitedTemplateToInfoMap.values()) {
            this.templateToFinishedInfoMap.put(templateVisitInfo.template, templateVisitInfo.toFinishedInfo());
        }
        return this.templateToFinishedInfoMap.get(nodeAsTemplate);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        if (this.templateToFinishedInfoMap.containsKey(node)) {
            throw new AssertionError();
        }
        if (this.visitedTemplateToInfoMap.containsKey(node)) {
            throw new AssertionError();
        }
        this.currTemplateVisitInfo = new TemplateVisitInfo(node, this.visitedTemplateToInfoMap.size());
        this.visitedTemplateToInfoMap.put(node, this.currTemplateVisitInfo);
        FindIjParamsInExprHelperVisitor helperVisitor = new FindIjParamsInExprHelperVisitor();
        SoytreeUtils.execOnAllV2Exprs(node, helperVisitor);
        Set<String> localIjParams = helperVisitor.getResult();
        for (String param : localIjParams) {
            this.currTemplateVisitInfo.ijParamToCalleesMultimap.put((Object)param, (Object)node);
        }
        this.visitChildren(node);
        this.currTemplateVisitInfo = null;
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        this.visitChildren(node);
        TemplateBasicNode callee = this.templateRegistry.getBasicTemplate(node.getCalleeName());
        if (callee == null) {
            this.currTemplateVisitInfo.mayHaveIjParamsInExternalCalls = true;
            return;
        }
        this.processCalleeHelper(callee);
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode node) {
        this.visitChildren(node);
        this.currTemplateVisitInfo.mayHaveIjParamsInExternalDelCalls = true;
        Set<TemplateRegistry.DelegateTemplateDivision> delTemplateDivisions = this.templateRegistry.getDelTemplateDivisionsForAllVariants(node.getDelCalleeName());
        if (delTemplateDivisions != null) {
            for (TemplateRegistry.DelegateTemplateDivision division : delTemplateDivisions) {
                for (TemplateDelegateNode delCallee : division.delPackageNameToDelTemplateMap.values()) {
                    this.processCalleeHelper(delCallee);
                }
            }
        }
    }

    private void processCalleeHelper(TemplateNode callee) {
        if (this.templateToFinishedInfoMap.containsKey(callee)) {
            this.currTemplateVisitInfo.incorporateCalleeFinishedInfo(this.templateToFinishedInfoMap.get(callee));
        } else if (callee != this.currTemplateVisitInfo.template) {
            if (this.activeTemplateSet.contains(callee)) {
                this.currTemplateVisitInfo.maybeUpdateEarliestEquivalent(this.visitedTemplateToInfoMap.get(callee));
            } else if (this.visitedTemplateToInfoMap.containsKey(callee)) {
                this.currTemplateVisitInfo.incorporateCalleeVisitInfo(this.visitedTemplateToInfoMap.get(callee), this.activeTemplateSet);
            } else {
                this.activeTemplateVisitInfoStack.push(this.currTemplateVisitInfo);
                this.activeTemplateSet.add(this.currTemplateVisitInfo.template);
                this.visit(callee);
                this.currTemplateVisitInfo = this.activeTemplateVisitInfoStack.pop();
                this.activeTemplateSet.remove(this.currTemplateVisitInfo.template);
                this.currTemplateVisitInfo.incorporateCalleeVisitInfo(this.visitedTemplateToInfoMap.get(callee), this.activeTemplateSet);
            }
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private static class TemplateVisitInfo {
        public final TemplateNode template;
        public final int visitOrdinal;
        public TemplateVisitInfo visitInfoOfEarliestEquivalent;
        public Multimap<String, TemplateNode> ijParamToCalleesMultimap;
        public boolean mayHaveIjParamsInExternalCalls;
        public boolean mayHaveIjParamsInExternalDelCalls;
        private IjParamsInfo finishedInfo;

        public TemplateVisitInfo(TemplateNode template, int visitOrdinal) {
            this.template = template;
            this.visitOrdinal = visitOrdinal;
            this.visitInfoOfEarliestEquivalent = null;
            this.ijParamToCalleesMultimap = HashMultimap.create();
            this.mayHaveIjParamsInExternalCalls = false;
            this.mayHaveIjParamsInExternalDelCalls = false;
            this.finishedInfo = null;
        }

        public void maybeUpdateEarliestEquivalent(TemplateVisitInfo visitInfoOfNewEquivalent) {
            Preconditions.checkArgument((visitInfoOfNewEquivalent != this ? 1 : 0) != 0);
            if (this.visitInfoOfEarliestEquivalent == null || visitInfoOfNewEquivalent.visitOrdinal < this.visitInfoOfEarliestEquivalent.visitOrdinal) {
                this.visitInfoOfEarliestEquivalent = visitInfoOfNewEquivalent;
            }
        }

        public void incorporateCalleeFinishedInfo(IjParamsInfo calleeFinishedInfo) {
            this.ijParamToCalleesMultimap.putAll(calleeFinishedInfo.ijParamToCalleesMultimap);
            this.mayHaveIjParamsInExternalCalls |= calleeFinishedInfo.mayHaveIjParamsInExternalCalls;
            this.mayHaveIjParamsInExternalDelCalls |= calleeFinishedInfo.mayHaveIjParamsInExternalDelCalls;
        }

        public void incorporateCalleeVisitInfo(TemplateVisitInfo calleeVisitInfo, Set<TemplateNode> activeTemplateSet) {
            if (calleeVisitInfo.visitInfoOfEarliestEquivalent == null || calleeVisitInfo.visitInfoOfEarliestEquivalent == this) {
                this.incorporateCalleeVisitInfoHelper(calleeVisitInfo);
            } else if (activeTemplateSet.contains(calleeVisitInfo.visitInfoOfEarliestEquivalent.template)) {
                this.maybeUpdateEarliestEquivalent(calleeVisitInfo.visitInfoOfEarliestEquivalent);
                this.incorporateCalleeVisitInfoHelper(calleeVisitInfo);
            } else {
                this.incorporateCalleeVisitInfo(calleeVisitInfo.visitInfoOfEarliestEquivalent, activeTemplateSet);
            }
        }

        private void incorporateCalleeVisitInfoHelper(TemplateVisitInfo calleeVisitInfo) {
            this.ijParamToCalleesMultimap.putAll(calleeVisitInfo.ijParamToCalleesMultimap);
            this.mayHaveIjParamsInExternalCalls |= calleeVisitInfo.mayHaveIjParamsInExternalCalls;
            this.mayHaveIjParamsInExternalDelCalls |= calleeVisitInfo.mayHaveIjParamsInExternalDelCalls;
        }

        public IjParamsInfo toFinishedInfo() {
            if (this.finishedInfo == null) {
                this.finishedInfo = this.visitInfoOfEarliestEquivalent != null ? this.visitInfoOfEarliestEquivalent.toFinishedInfo() : new IjParamsInfo((ImmutableMultimap<String, TemplateNode>)ImmutableMultimap.copyOf(this.ijParamToCalleesMultimap), this.mayHaveIjParamsInExternalCalls, this.mayHaveIjParamsInExternalDelCalls);
            }
            return this.finishedInfo;
        }
    }

    public static class IjParamsInfo {
        public final ImmutableSortedSet<String> ijParamSet;
        public final ImmutableMultimap<String, TemplateNode> ijParamToCalleesMultimap;
        public final boolean mayHaveIjParamsInExternalCalls;
        public final boolean mayHaveIjParamsInExternalDelCalls;

        public IjParamsInfo(ImmutableMultimap<String, TemplateNode> ijParamToCalleesMultimap, boolean mayHaveIjParamsInExternalCalls, boolean mayHaveIjParamsInExternalDelCalls) {
            this.ijParamToCalleesMultimap = ijParamToCalleesMultimap;
            this.ijParamSet = ImmutableSortedSet.copyOf((Collection)ijParamToCalleesMultimap.keySet());
            this.mayHaveIjParamsInExternalCalls = mayHaveIjParamsInExternalCalls;
            this.mayHaveIjParamsInExternalDelCalls = mayHaveIjParamsInExternalDelCalls;
        }
    }
}

