/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.restricted;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.shared.restricted.EscapingConventions;
import com.google.template.soy.shared.restricted.TagWhitelist;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public final class Sanitizers {
    private static final Logger LOGGER = Logger.getLogger(Sanitizers.class.getName());
    private static final Set<String> HTML5_VOID_ELEMENTS = ImmutableSet.of((Object)"area", (Object)"base", (Object)"br", (Object)"col", (Object)"command", (Object)"embed", (Object[])new String[]{"hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"});

    private Sanitizers() {
    }

    public static String escapeHtml(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.HTML)) {
            return value.toString();
        }
        return Sanitizers.escapeHtml(value.toString());
    }

    public static String escapeHtml(String value) {
        return EscapingConventions.EscapeHtml.INSTANCE.escape(value);
    }

    public static String cleanHtml(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.HTML)) {
            return value.toString();
        }
        return Sanitizers.cleanHtml(value.toString());
    }

    public static String cleanHtml(String value) {
        return Sanitizers.stripHtmlTags(value, TagWhitelist.FORMATTING, true);
    }

    public static String escapeHtmlRcdata(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.HTML)) {
            return Sanitizers.normalizeHtml(value.toString());
        }
        return Sanitizers.escapeHtml(value.toString());
    }

    public static String escapeHtmlRcdata(String value) {
        return EscapingConventions.EscapeHtml.INSTANCE.escape(value);
    }

    public static String normalizeHtml(SoyData value) {
        return Sanitizers.normalizeHtml(value.toString());
    }

    public static String normalizeHtml(String value) {
        return EscapingConventions.NormalizeHtml.INSTANCE.escape(value);
    }

    public static String normalizeHtmlNospace(SoyData value) {
        return Sanitizers.normalizeHtmlNospace(value.toString());
    }

    public static String normalizeHtmlNospace(String value) {
        return EscapingConventions.NormalizeHtmlNospace.INSTANCE.escape(value);
    }

    public static String escapeHtmlAttribute(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.HTML)) {
            return Sanitizers.stripHtmlTags(value.toString(), null, true);
        }
        return Sanitizers.escapeHtmlAttribute(value.toString());
    }

    public static String escapeHtmlAttribute(String value) {
        return EscapingConventions.EscapeHtml.INSTANCE.escape(value);
    }

    public static String escapeHtmlAttributeNospace(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.HTML)) {
            return Sanitizers.stripHtmlTags(value.toString(), null, false);
        }
        return Sanitizers.escapeHtmlAttributeNospace(value.toString());
    }

    public static String escapeHtmlAttributeNospace(String value) {
        return EscapingConventions.EscapeHtmlNospace.INSTANCE.escape(value);
    }

    public static String escapeJsString(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.JS_STR_CHARS)) {
            return value.toString();
        }
        return Sanitizers.escapeJsString(value.toString());
    }

    public static String escapeJsString(String value) {
        return EscapingConventions.EscapeJsString.INSTANCE.escape(value);
    }

    public static String escapeJsValue(SoyData value) {
        if (NullData.INSTANCE == value) {
            return " null ";
        }
        if (value instanceof NumberData) {
            return " " + value.numberValue() + " ";
        }
        if (value instanceof BooleanData) {
            return " " + value.booleanValue() + " ";
        }
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.JS)) {
            return value.toString();
        }
        return Sanitizers.escapeJsValue(value.toString());
    }

    public static String escapeJsValue(String value) {
        return value != null ? "'" + Sanitizers.escapeJsString(value) + "'" : " null ";
    }

    public static String escapeJsRegex(SoyData value) {
        return Sanitizers.escapeJsRegex(value.toString());
    }

    public static String escapeJsRegex(String value) {
        return EscapingConventions.EscapeJsRegex.INSTANCE.escape(value);
    }

    public static String escapeCssString(SoyData value) {
        return Sanitizers.escapeCssString(value.toString());
    }

    public static String escapeCssString(String value) {
        return EscapingConventions.EscapeCssString.INSTANCE.escape(value);
    }

    public static String filterCssValue(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.CSS)) {
            return value.toString();
        }
        return NullData.INSTANCE == value ? "" : Sanitizers.filterCssValue(value.toString());
    }

    public static String filterCssValue(String value) {
        if (EscapingConventions.FilterCssValue.INSTANCE.getValueFilter().matcher(value).find()) {
            return value;
        }
        LOGGER.log(Level.WARNING, "|filterCssValue received bad value {0}", value);
        return "zSoyz";
    }

    public static String escapeUri(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.URI)) {
            return Sanitizers.normalizeUri(value);
        }
        return Sanitizers.escapeUri(value.toString());
    }

    public static String escapeUri(String value) {
        return CharEscapers.uriEscaper(false).escape(value);
    }

    public static String normalizeUri(SoyData value) {
        return Sanitizers.normalizeUri(value.toString());
    }

    public static String normalizeUri(String value) {
        return EscapingConventions.NormalizeUri.INSTANCE.escape(value);
    }

    public static String filterNormalizeUri(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.URI)) {
            return Sanitizers.normalizeUri(value);
        }
        return Sanitizers.filterNormalizeUri(value.toString());
    }

    public static String filterNormalizeUri(String value) {
        if (EscapingConventions.FilterNormalizeUri.INSTANCE.getValueFilter().matcher(value).find()) {
            return EscapingConventions.FilterNormalizeUri.INSTANCE.escape(value);
        }
        LOGGER.log(Level.WARNING, "|filterNormalizeUri received bad value {0}", value);
        return "#zSoyz";
    }

    public static String filterHtmlAttributes(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.ATTRIBUTES)) {
            char lastChar;
            String content = value.toString();
            if (content.length() > 0 && (lastChar = content.charAt(content.length() - 1)) != '\"' && lastChar != '\'' && !Character.isWhitespace(lastChar)) {
                content = content + ' ';
            }
            return content;
        }
        return Sanitizers.filterHtmlAttributes(value.toString());
    }

    public static String filterHtmlAttributes(String value) {
        if (EscapingConventions.FilterHtmlAttributes.INSTANCE.getValueFilter().matcher(value).find()) {
            return value;
        }
        LOGGER.log(Level.WARNING, "|filterHtmlAttributes received bad value {0}", value);
        return "zSoyz";
    }

    public static String filterHtmlElementName(SoyData value) {
        return Sanitizers.filterHtmlElementName(value.toString());
    }

    public static String filterHtmlElementName(String value) {
        if (EscapingConventions.FilterHtmlElementName.INSTANCE.getValueFilter().matcher(value).find()) {
            return value;
        }
        LOGGER.log(Level.WARNING, "|filterHtmlElementName received bad value {0}", value);
        return "zSoyz";
    }

    public static SoyData filterNoAutoescape(SoyData data) {
        if (Sanitizers.isSanitizedContentOfKind(data, SanitizedContent.ContentKind.TEXT)) {
            LOGGER.log(Level.WARNING, "|noAutoescape received data explicitly tagged as ContentKind.TEXT: {0}", data);
            return SoyData.createFromExistingData("zSoyz");
        }
        return data instanceof StringData ? data : SoyData.createFromExistingData(data.toString());
    }

    private static boolean isSanitizedContentOfKind(SoyData data, SanitizedContent.ContentKind kind) {
        return data instanceof SanitizedContent && kind == ((SanitizedContent)data).getContentKind();
    }

    @VisibleForTesting
    static String stripHtmlTags(String value, TagWhitelist safeTags, boolean rawSpacesAllowed) {
        EscapingConventions.CrossLanguageStringXform normalizer = rawSpacesAllowed ? EscapingConventions.NormalizeHtml.INSTANCE : EscapingConventions.NormalizeHtmlNospace.INSTANCE;
        Matcher matcher = EscapingConventions.HTML_TAG_CONTENT.matcher(value);
        if (!matcher.find()) {
            return normalizer.escape(value);
        }
        StringBuilder out = new StringBuilder(value.length() - matcher.end() + matcher.start());
        Appendable normalizedOut = normalizer.escape(out);
        List openTags = null;
        try {
            int pos = 0;
            do {
                int start;
                if (pos < (start = matcher.start())) {
                    normalizedOut.append(value, pos, start);
                    if (value.charAt(start - 1) == '&') {
                        out.append("amp;");
                    }
                }
                if (safeTags != null) {
                    int limit = matcher.end();
                    String tagName = matcher.group(1);
                    if (tagName != null && safeTags.isSafeTag(tagName = tagName.toLowerCase(Locale.ENGLISH))) {
                        boolean isClose;
                        boolean bl = isClose = value.charAt(start + 1) == '/';
                        if (isClose) {
                            int lastIdx;
                            if (openTags != null && (lastIdx = openTags.lastIndexOf(tagName)) >= 0) {
                                Sanitizers.closeTags(openTags.subList(lastIdx, openTags.size()), out);
                            }
                        } else {
                            out.append('<').append(tagName).append('>');
                            if (!HTML5_VOID_ELEMENTS.contains(tagName)) {
                                if (openTags == null) {
                                    openTags = Lists.newArrayList();
                                }
                                openTags.add(tagName);
                            }
                        }
                    }
                }
                pos = matcher.end();
            } while (matcher.find());
            normalizedOut.append(value, pos, value.length());
            if (openTags != null) {
                Sanitizers.closeTags(openTags, out);
            }
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
        return out.toString();
    }

    private static void closeTags(List<String> openTags, StringBuilder out) {
        int i = openTags.size();
        while (--i >= 0) {
            out.append("</").append(openTags.get(i)).append('>');
        }
        openTags.clear();
    }
}

