/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.template.soy.shared.internal.NonpluginFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ModuleUtils {
    private ModuleUtils() {
    }

    public static <T extends SoyFunction> Map<String, T> buildSpecificSoyFunctionsMap(Class<T> specificSoyFunctionType, Set<SoyFunction> soyFunctionsSet) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        HashSet seenFnNames = Sets.newHashSetWithExpectedSize((int)soyFunctionsSet.size());
        for (SoyFunction fn : soyFunctionsSet) {
            if (!specificSoyFunctionType.isAssignableFrom(fn.getClass())) continue;
            String fnName = fn.getName();
            if (seenFnNames.contains(fnName) || NonpluginFunction.forFunctionName(fnName) != null) {
                throw new IllegalStateException("Found two implementations of " + specificSoyFunctionType.getSimpleName() + " with the same function name '" + fnName + "'.");
            }
            seenFnNames.add(fnName);
            mapBuilder.put((Object)fnName, specificSoyFunctionType.cast(fn));
        }
        return mapBuilder.build();
    }

    public static <T extends SoyPrintDirective> Map<String, T> buildSpecificSoyDirectivesMap(Class<T> specificSoyDirectiveType, Set<SoyPrintDirective> soyDirectivesSet) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        HashSet seenDirectiveNames = Sets.newHashSetWithExpectedSize((int)soyDirectivesSet.size());
        for (SoyPrintDirective directive : soyDirectivesSet) {
            if (!specificSoyDirectiveType.isAssignableFrom(directive.getClass())) continue;
            String directiveName = directive.getName();
            if (seenDirectiveNames.contains(directiveName)) {
                throw new IllegalStateException("Found two implementations of " + specificSoyDirectiveType.getSimpleName() + " with the same directive name '" + directiveName + "'.");
            }
            seenDirectiveNames.add(directiveName);
            mapBuilder.put((Object)directiveName, specificSoyDirectiveType.cast(directive));
        }
        return mapBuilder.build();
    }
}

