/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.shared.internal.NonpluginFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoySyntaxExceptionUtils;
import java.util.Map;
import java.util.Set;

public class CheckFunctionCallsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final Map<String, SoyFunction> soyFunctionsByName;
    private boolean allowExternallyDefinedFunctions;

    @Inject
    public CheckFunctionCallsVisitor(Map<String, SoyFunction> soyFunctionsByName) {
        this.soyFunctionsByName = ImmutableMap.copyOf(soyFunctionsByName);
    }

    public void setAllowExternallyDefinedFunctions(boolean allow) {
        this.allowExternallyDefinedFunctions = allow;
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ExprHolderNode) {
            for (ExprUnion exprUnion : ((SoyNode.ExprHolderNode)node).getAllExprUnions()) {
                if (exprUnion.getExpr() == null) continue;
                try {
                    new CheckFunctionCallsExprVisitor((SoyNode.ExprHolderNode)node).exec(exprUnion.getExpr());
                }
                catch (SoySyntaxException ex) {
                    throw SoySyntaxExceptionUtils.associateNode(ex, node);
                }
            }
        }
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private final class CheckFunctionCallsExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final SoyNode.ExprHolderNode container;

        CheckFunctionCallsExprVisitor(SoyNode.ExprHolderNode container) {
            this.container = container;
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            block11: {
                int numArgs;
                String fnName;
                block10: {
                    fnName = node.getFunctionName();
                    numArgs = node.numChildren();
                    NonpluginFunction nonpluginFn = NonpluginFunction.forFunctionName(fnName);
                    if (nonpluginFn == null) break block10;
                    if (numArgs != nonpluginFn.getNumArgs()) {
                        throw SoySyntaxException.createWithoutMetaInfo("Function '" + fnName + "' called with the wrong number of arguments" + " (function call \"" + node.toSourceString() + "\").");
                    }
                    switch (nonpluginFn) {
                        case INDEX: 
                        case IS_FIRST: 
                        case IS_LAST: {
                            this.requireLoopVariableInScope(node, node.getChild(0));
                            break block11;
                        }
                        case QUOTE_KEYS_IF_JS: {
                            if (!(node.getChild(0) instanceof MapLiteralNode)) {
                                throw SoySyntaxException.createWithoutMetaInfo("Function quoteKeysIfJs() must have a map literal as its arg (encountered \"" + node.toSourceString() + "\").");
                            }
                            break block11;
                        }
                        default: {
                            throw new AssertionError((Object)("Unrecognized nonplugin fn " + (Object)((Object)nonpluginFn)));
                        }
                    }
                }
                SoyFunction signature = (SoyFunction)CheckFunctionCallsVisitor.this.soyFunctionsByName.get(fnName);
                if (signature != null) {
                    Set<Integer> arities = signature.getValidArgsSizes();
                    if (!arities.contains(numArgs)) {
                        throw SoySyntaxException.createWithoutMetaInfo("Function '" + fnName + "' called with the wrong number of arguments" + " (function call \"" + node.toSourceString() + "\").");
                    }
                } else if (!CheckFunctionCallsVisitor.this.allowExternallyDefinedFunctions) {
                    throw SoySyntaxException.createWithoutMetaInfo("Unrecognized function '" + fnName + "' (encountered function call \"" + node.toSourceString() + "\").");
                }
            }
            this.visitChildren(node);
        }

        private void requireLoopVariableInScope(FunctionNode fn, ExprNode loopVariable) {
            if (!this.isLoopVariableInScope(loopVariable)) {
                throw SoySyntaxException.createWithoutMetaInfo("Function '" + fn.getFunctionName() + "' must have a foreach loop variable as its" + " argument (encountered \"" + fn.toSourceString() + "\").");
            }
        }

        private boolean isLoopVariableInScope(ExprNode loopVariable) {
            if (!(loopVariable instanceof DataRefNode)) {
                return false;
            }
            DataRefNode loopVariableRef = (DataRefNode)loopVariable;
            if (loopVariableRef.isIjDataRef()) {
                return false;
            }
            if (loopVariableRef.numChildren() != 0) {
                return false;
            }
            String loopVariableName = loopVariableRef.getFirstKey();
            for (SoyNode.ParentSoyNode<?> ancestor = this.container.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                String iteratorVariableName;
                if (!(ancestor instanceof ForeachNonemptyNode) || !loopVariableName.equals(iteratorVariableName = ((ForeachNonemptyNode)ancestor).getVarName())) continue;
                return true;
            }
            return false;
        }
    }
}

