/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.internal;

import com.google.common.collect.Lists;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import javax.annotation.Nullable;

public class InsertMsgsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final SoyMsgBundle msgBundle;
    private final boolean dontErrorOnPlrselMsgs;
    private IdGenerator nodeIdGen;
    private List<SoyNode.StandaloneNode> currMsgReplacementNodes;

    public InsertMsgsVisitor(@Nullable SoyMsgBundle msgBundle, boolean dontErrorOnPlrselMsgs) {
        this.msgBundle = msgBundle;
        this.dontErrorOnPlrselMsgs = dontErrorOnPlrselMsgs;
    }

    @Override
    public Void exec(SoyNode node) {
        this.nodeIdGen = node.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator();
        super.exec(node);
        return null;
    }

    @Override
    protected void visitMsgNode(MsgNode node) {
        SoyMsg soyMsg;
        if (node.numChildren() == 1 && (node.getChild(0) instanceof MsgSelectNode || node.getChild(0) instanceof MsgPluralNode)) {
            if (this.dontErrorOnPlrselMsgs) {
                return;
            }
            throw new EncounteredPlrselMsgException(node);
        }
        this.currMsgReplacementNodes = Lists.newArrayList();
        long msgId = MsgUtils.computeMsgIdForDualFormat(node);
        SoyMsg soyMsg2 = soyMsg = this.msgBundle == null ? null : this.msgBundle.getMsg(msgId);
        if (soyMsg != null) {
            for (SoyMsgPart msgPart : soyMsg.getParts()) {
                if (msgPart instanceof SoyMsgRawTextPart) {
                    String rawText = ((SoyMsgRawTextPart)msgPart).getRawText();
                    this.currMsgReplacementNodes.add(new RawTextNode(this.nodeIdGen.genId(), rawText));
                    continue;
                }
                if (msgPart instanceof SoyMsgPlaceholderPart) {
                    String placeholderName = ((SoyMsgPlaceholderPart)msgPart).getPlaceholderName();
                    MsgPlaceholderNode placeholderNode = node.getRepPlaceholderNode(placeholderName);
                    for (SoyNode.StandaloneNode contentNode : placeholderNode.getChildren()) {
                        if (contentNode instanceof MsgHtmlTagNode) {
                            this.visit(contentNode);
                            continue;
                        }
                        this.currMsgReplacementNodes.add(contentNode);
                    }
                    continue;
                }
                throw new AssertionError();
            }
        } else {
            for (SoyNode.StandaloneNode child : node.getChildren()) {
                if (child instanceof RawTextNode) {
                    this.currMsgReplacementNodes.add(child);
                    continue;
                }
                if (child instanceof MsgPlaceholderNode) {
                    for (SoyNode.StandaloneNode contentNode : ((MsgPlaceholderNode)child).getChildren()) {
                        if (contentNode instanceof MsgHtmlTagNode) {
                            this.visit(contentNode);
                            continue;
                        }
                        this.currMsgReplacementNodes.add(contentNode);
                    }
                    continue;
                }
                throw new AssertionError();
            }
        }
        SoyNode.BlockNode parent = node.getParent();
        int indexInParent = parent.getChildIndex(node);
        parent.removeChild(indexInParent);
        parent.addChildren(indexInParent, this.currMsgReplacementNodes);
        this.currMsgReplacementNodes = null;
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        for (SoyNode.StandaloneNode child : node.getChildren()) {
            this.currMsgReplacementNodes.add(child);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
        }
    }

    public static class EncounteredPlrselMsgException
    extends RuntimeException {
        public final MsgNode msgNode;

        public EncounteredPlrselMsgException(MsgNode msgNode) {
            this.msgNode = msgNode;
        }
    }
}

