/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.Lists;
import com.google.template.soy.sharedpasses.BuildAllDependeesMapVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import java.util.List;
import java.util.Map;

class MoveGoogMsgNodesEarlierVisitor
extends AbstractSoyNodeVisitor<Void> {
    private List<GoogMsgNode> googMsgNodes;

    MoveGoogMsgNodesEarlierVisitor() {
    }

    @Override
    public Void exec(SoyNode node) {
        this.googMsgNodes = Lists.newArrayList();
        this.visit(node);
        return null;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        this.visitChildren(node);
        Map<SoyNode, List<SoyNode>> allDependeesMap = new BuildAllDependeesMapVisitor().exec(node);
        for (GoogMsgNode googMsgNode : this.googMsgNodes) {
            this.moveGoogMsgNodeEarlierHelper(googMsgNode, allDependeesMap.get(googMsgNode));
        }
    }

    @Override
    protected void visitGoogMsgNode(GoogMsgNode node) {
        this.googMsgNodes.add(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private void moveGoogMsgNodeEarlierHelper(GoogMsgNode googMsgNode, List<SoyNode> allDependees) {
        int indexUnderNewParent;
        SoyNode.BlockNode newParent;
        SoyNode nearestDependee = allDependees.get(0);
        if (nearestDependee instanceof SoyNode.LocalVarInlineNode) {
            newParent = (SoyNode.BlockNode)nearestDependee.getParent();
            indexUnderNewParent = newParent.getChildIndex((SoyNode.LocalVarInlineNode)nearestDependee) + 1;
        } else if (nearestDependee instanceof SoyNode.BlockNode) {
            newParent = (SoyNode.BlockNode)nearestDependee;
            indexUnderNewParent = 0;
        } else {
            throw new AssertionError();
        }
        List siblings = newParent.getChildren();
        while (indexUnderNewParent < siblings.size() && siblings.get(indexUnderNewParent) instanceof GoogMsgNode) {
            if (googMsgNode == siblings.get(indexUnderNewParent)) {
                return;
            }
            ++indexUnderNewParent;
        }
        googMsgNode.getParent().removeChild(googMsgNode);
        newParent.addChild(indexUnderNewParent, googMsgNode);
    }
}

