/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.template.soy.base.BaseUtils;
import java.io.File;
import javax.annotation.Nullable;

public class JsSrcUtils {
    public static String buildFilePath(String filePathFormat, @Nullable String locale, @Nullable String inputFilePath, String inputPathPrefix) {
        String path = filePathFormat;
        if (locale != null) {
            path = path.replace("{LOCALE}", locale);
            path = path.replace("{LOCALE_LOWER_CASE}", locale.toLowerCase().replace('-', '_'));
        }
        path = path.replace("{INPUT_PREFIX}", inputPathPrefix);
        if (inputFilePath != null) {
            inputFilePath = inputFilePath.substring(inputPathPrefix.length());
            int lastSlashIndex = inputFilePath.lastIndexOf(File.separatorChar);
            String directory = inputFilePath.substring(0, lastSlashIndex + 1);
            String fileName = inputFilePath.substring(lastSlashIndex + 1);
            int lastDotIndex = fileName.lastIndexOf(46);
            if (lastDotIndex == -1) {
                lastDotIndex = fileName.length();
            }
            String fileNameNoExt = fileName.substring(0, lastDotIndex);
            path = path.replace("{INPUT_DIRECTORY}", directory);
            path = path.replace("{INPUT_FILE_NAME}", fileName);
            path = path.replace("{INPUT_FILE_NAME_NO_EXT}", fileNameNoExt);
        }
        return path;
    }

    public static String escapeUnicodeFormatChars(String str) {
        int codePoint;
        int len = str.length();
        boolean hasFormatChar = false;
        for (int i = 0; i < len; ++i) {
            if (Character.getType(str.charAt(i)) != 16) continue;
            hasFormatChar = true;
            break;
        }
        if (!hasFormatChar) {
            return str;
        }
        StringBuilder out = new StringBuilder(len * 4 / 3);
        for (int i = 0; i < len; i += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(i);
            if (Character.getType(codePoint) == 16) {
                BaseUtils.appendHexEscape(out, codePoint);
                continue;
            }
            out.appendCodePoint(codePoint);
        }
        return out.toString();
    }
}

