/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.template.soy.shared.restricted.EscapingConventions;
import com.google.template.soy.shared.restricted.TagWhitelist;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.tools.ant.Task;

@ParametersAreNonnullByDefault
public final class GenerateSoyUtilsEscapingDirectiveCode
extends Task {
    private List<FileRef> inputs = Lists.newArrayList();
    private FileRef output;
    private Predicate<String> availableJavaScript = new Predicate<String>(){

        public boolean apply(String javaScriptFunctionName) {
            return javaScriptFunctionName.indexOf(46) < 0;
        }
    };
    static final String GENERATED_CODE_START_MARKER = "// START GENERATED CODE FOR ESCAPERS.";
    static final String GENERATED_CODE_END_MARKER = "// END GENERATED CODE";
    private static final Pattern NAMED_CLASS = Pattern.compile("(?<!\\\\)(\\\\{2})*\\\\p\\{");

    public Predicate<String> getAvailableJavaScript() {
        return this.availableJavaScript;
    }

    public FileRef createInput() {
        FileRef ref = new FileRef(true);
        this.inputs.add(ref);
        return ref;
    }

    public FileRef createOutput() {
        if (this.output != null) {
            throw new IllegalStateException("Too many <output>s");
        }
        this.output = new FileRef(false);
        return this.output;
    }

    public void addConfiguredJsdefined(FunctionNamePredicate p) {
        final Pattern namePattern = p.namePattern;
        if (namePattern == null) {
            throw new IllegalStateException("Please specify a pattern attribute for <jsdefined>");
        }
        this.availableJavaScript = Predicates.or(this.availableJavaScript, (Predicate)new Predicate<String>(){

            public boolean apply(String javaScriptFunctionName) {
                return namePattern.matcher(javaScriptFunctionName).matches();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        super.execute();
        if (this.output == null) {
            System.err.println("Please add an <output> for the <" + this.getTaskName() + "> at " + this.getLocation());
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (FileRef input : this.inputs) {
            try {
                boolean inGeneratedCode = false;
                for (String line : Files.readLines((File)input.file, (Charset)Charsets.UTF_8)) {
                    if (inGeneratedCode) {
                        if (!GENERATED_CODE_END_MARKER.equals(line.trim())) continue;
                        inGeneratedCode = false;
                        continue;
                    }
                    if (GENERATED_CODE_START_MARKER.equals(line.trim())) {
                        inGeneratedCode = true;
                        continue;
                    }
                    sb.append(line).append('\n');
                }
                sb.append('\n');
            }
            catch (IOException ex) {
                System.err.println("Failed to read " + input.file);
                ex.printStackTrace();
                return;
            }
        }
        this.generateJavaScript(this.availableJavaScript, sb);
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.output.file), Charsets.UTF_8);
            try {
                ((Writer)out).append(sb);
            }
            finally {
                ((Writer)out).close();
            }
        }
        catch (IOException ex) {
            this.output.file.delete();
        }
    }

    @VisibleForTesting
    void generateJavaScript(Predicate<String> availableJavaScript, StringBuilder outputJs) {
        class DirectiveDigest {
            final String directiveName;
            final int escapesVar;
            final int matcherVar;
            final int filterVar;
            @Nullable
            final String nonAsciiPrefix;
            final String innocuousOutput;

            DirectiveDigest(String directiveName, int escapesVar, int matcherVar, @Nullable int filterVar, String nonAsciiPrefix, String innocuousOutput) {
                this.directiveName = directiveName;
                this.escapesVar = escapesVar;
                this.matcherVar = matcherVar;
                this.filterVar = filterVar;
                this.nonAsciiPrefix = nonAsciiPrefix;
                this.innocuousOutput = innocuousOutput;
            }
        }
        int i;
        outputJs.append('\n').append(GENERATED_CODE_START_MARKER).append('\n');
        ArrayList escapeMaps = Lists.newArrayList();
        ArrayList escapeMapNames = Lists.newArrayList();
        ArrayList matchers = Lists.newArrayList();
        ArrayList matcherNames = Lists.newArrayList();
        ArrayList filters = Lists.newArrayList();
        ArrayList filterNames = Lists.newArrayList();
        ArrayList digests = Lists.newArrayList();
        block0: for (EscapingConventions.CrossLanguageStringXform escaper : EscapingConventions.getAllEscapers()) {
            String escapeDirectiveIdent = escaper.getDirectiveName().substring(1);
            String escapeDirectiveUIdent = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, escapeDirectiveIdent);
            for (String existingFunction : escaper.getJsFunctionNames()) {
                if (!availableJavaScript.apply((Object)existingFunction)) continue;
                outputJs.append('\n').append("/**\n").append(" * @type {function (*) : string}\n").append(" */\n").append("soy.esc.$$").append(escapeDirectiveIdent).append("Helper = function(v) {\n").append("  return ").append(existingFunction).append("(String(v));\n").append("};\n");
                continue block0;
            }
            int escapesVar = -1;
            int matcherVar = -1;
            if (!escaper.getEscapes().isEmpty()) {
                LinkedHashMap escapeMap = Maps.newLinkedHashMap();
                StringBuilder matcherRegexBuf = new StringBuilder("/[");
                char lastCodeUnit = Integer.MIN_VALUE;
                int rangeStart = Integer.MIN_VALUE;
                for (EscapingConventions.Escape esc : escaper.getEscapes()) {
                    char ch = esc.getPlainText();
                    if (ch == lastCodeUnit) {
                        throw new IllegalStateException("Ambiguous escape " + esc.getEscaped() + " for " + escapeDirectiveIdent);
                    }
                    escapeMap.put(Character.valueOf(ch), esc.getEscaped());
                    if (ch != lastCodeUnit + '\u0001') {
                        if (rangeStart != Integer.MIN_VALUE) {
                            GenerateSoyUtilsEscapingDirectiveCode.escapeRegexpRangeOnto((char)rangeStart, lastCodeUnit, matcherRegexBuf);
                        }
                        rangeStart = ch;
                    }
                    lastCodeUnit = ch;
                }
                if (rangeStart < 0) {
                    throw new IllegalStateException();
                }
                GenerateSoyUtilsEscapingDirectiveCode.escapeRegexpRangeOnto((char)rangeStart, lastCodeUnit, matcherRegexBuf);
                matcherRegexBuf.append("]/g");
                int numEscapeMaps = escapeMaps.size();
                for (int i2 = 0; i2 < numEscapeMaps; ++i2) {
                    if (!GenerateSoyUtilsEscapingDirectiveCode.mapsHaveCompatibleOverlap((Map)escapeMaps.get(i2), escapeMap)) continue;
                    escapesVar = i2;
                    break;
                }
                if (escapesVar == -1) {
                    escapesVar = numEscapeMaps;
                    escapeMaps.add(escapeMap);
                    escapeMapNames.add(escapeDirectiveUIdent);
                } else {
                    ((Map)escapeMaps.get(escapesVar)).putAll(escapeMap);
                    escapeMapNames.set(escapesVar, (String)escapeMapNames.get(escapesVar) + "__AND__" + escapeDirectiveUIdent);
                }
                String matcherRegex = matcherRegexBuf.toString();
                matcherVar = matchers.indexOf(matcherRegex);
                if (matcherVar < 0) {
                    matcherVar = matchers.size();
                    matchers.add(matcherRegex);
                    matcherNames.add(escapeDirectiveUIdent);
                } else {
                    matcherNames.set(matcherVar, (String)matcherNames.get(matcherVar) + "__AND__" + escapeDirectiveUIdent);
                }
            }
            int filterVar = -1;
            Pattern filterPatternJava = escaper.getValueFilter();
            if (filterPatternJava != null) {
                String filterPattern = GenerateSoyUtilsEscapingDirectiveCode.javaRegexToJs(filterPatternJava);
                filterVar = filters.indexOf(filterPattern);
                if (filterVar == -1) {
                    filterVar = filters.size();
                    filters.add(filterPattern);
                    filterNames.add(escapeDirectiveUIdent);
                } else {
                    filterNames.set(filterVar, (String)filterNames.get(filterVar) + "__AND__" + escapeDirectiveUIdent);
                }
            }
            digests.add(new DirectiveDigest(escapeDirectiveIdent, escapesVar, matcherVar, filterVar, escaper.getNonAsciiPrefix(), escaper.getInnocuousOutput()));
        }
        for (i = 0; i < escapeMaps.size(); ++i) {
            Map escapeMap = (Map)escapeMaps.get(i);
            String escapeMapName = (String)escapeMapNames.get(i);
            outputJs.append('\n').append("/**\n").append(" * Maps charcters to the escaped versions for the named escape directives.\n").append(" * @type {Object.<string, string>}\n").append(" * @private\n").append(" */\n").append("soy.esc.$$ESCAPE_MAP_FOR_").append(escapeMapName).append("_ = {");
            boolean needsComma = false;
            for (Map.Entry e : escapeMap.entrySet()) {
                if (needsComma) {
                    outputJs.append(',');
                }
                outputJs.append("\n  ");
                GenerateSoyUtilsEscapingDirectiveCode.writeJsChar(((Character)e.getKey()).charValue(), outputJs);
                outputJs.append(": ");
                GenerateSoyUtilsEscapingDirectiveCode.writeJsString((String)e.getValue(), outputJs);
                needsComma = true;
            }
            outputJs.append("\n};\n");
            outputJs.append('\n').append("/**\n").append(" * A function that can be used with String.replace..\n").append(" * @param {string} ch A single character matched by a compatible matcher.\n").append(" * @return {string} A token in the output language.\n").append(" * @private\n").append(" */\n").append("soy.esc.$$REPLACER_FOR_").append(escapeMapName).append("_ = function(ch) {\n").append("  return soy.esc.$$ESCAPE_MAP_FOR_").append(escapeMapName).append("_[ch];\n").append("};\n");
        }
        for (i = 0; i < matchers.size(); ++i) {
            String matcher = (String)matchers.get(i);
            String matcherName = (String)matcherNames.get(i);
            outputJs.append('\n').append("/**\n").append(" * Matches characters that need to be escaped for the named directives.\n").append(" * @type RegExp\n").append(" * @private\n").append(" */\n").append("soy.esc.$$MATCHER_FOR_").append(matcherName).append("_ = ").append(matcher).append(";\n");
        }
        for (i = 0; i < filters.size(); ++i) {
            String filter = (String)filters.get(i);
            String filterName = (String)filterNames.get(i);
            outputJs.append('\n').append("/**\n").append(" * A pattern that vets values produced by the named directives.\n").append(" * @type RegExp\n").append(" * @private\n").append(" */\n").append("soy.esc.$$FILTER_FOR_").append(filterName).append("_ = ").append(filter).append(";\n");
        }
        for (DirectiveDigest digest : digests) {
            String name = digest.directiveName;
            outputJs.append('\n').append("/**\n").append(" * A helper for the Soy directive |").append(name).append('\n').append(" * @param {*} value Can be of any type but will be coerced to a string.\n").append(" * @return {string} The escaped text.\n").append(" */\n").append("soy.esc.$$").append(name).append("Helper = function(value) {\n").append("  var str = String(value);\n");
            if (digest.filterVar != -1) {
                String filterName = (String)filterNames.get(digest.filterVar);
                outputJs.append("  if (!soy.esc.$$FILTER_FOR_").append(filterName).append("_.test(str)) {\n");
                if (availableJavaScript.apply((Object)"goog.asserts.fail")) {
                    outputJs.append("    goog.asserts.fail('Bad value `%s` for |").append(name).append("', [str]);\n");
                }
                outputJs.append("    return '").append(digest.innocuousOutput).append("';\n").append("  }\n");
            }
            if (digest.nonAsciiPrefix != null) {
                throw new UnsupportedOperationException("Non ASCII prefix escapers not implemented yet.");
            }
            if (digest.escapesVar >= 0) {
                String escapeMapName = (String)escapeMapNames.get(digest.escapesVar);
                String matcherName = (String)matcherNames.get(digest.matcherVar);
                outputJs.append("  return str.replace(\n").append("      soy.esc.$$MATCHER_FOR_").append(matcherName).append("_,\n").append("      soy.esc.$$REPLACER_FOR_").append(escapeMapName).append("_);\n");
            } else {
                outputJs.append("  return str;\n");
            }
            outputJs.append("};\n");
        }
        outputJs.append('\n').append("/**\n").append(" * Matches all tags, HTML comments, and DOCTYPEs in tag soup HTML.\n").append(" * By removing these, and replacing any '<' or '>' characters with\n").append(" * entities we guarantee that the result can be embedded into a\n").append(" * an attribute without introducing a tag boundary.\n").append(" *\n").append(" * @type {RegExp}\n").append(" * @private\n").append(" */\n").append("soy.esc.$$HTML_TAG_REGEX_ = ").append(GenerateSoyUtilsEscapingDirectiveCode.javaRegexToJs(EscapingConventions.HTML_TAG_CONTENT)).append("g;\n").append("\n").append("/**\n").append(" * Matches all occurrences of '<'.\n").append(" *\n").append(" * @type {RegExp}\n").append(" * @private\n").append(" */\n").append("soy.esc.$$LT_REGEX_ = /</g;\n");
        outputJs.append('\n').append("/**\n").append(" * Maps lower-case names of innocuous tags to 1.\n").append(" *\n").append(" * @type {Object.<string,number>}\n").append(" * @private\n").append(" */\n").append("soy.esc.$$SAFE_TAG_WHITELIST_ = ").append(GenerateSoyUtilsEscapingDirectiveCode.toJsStringSet(TagWhitelist.FORMATTING.asSet())).append(";\n");
        outputJs.append('\n').append(GENERATED_CODE_END_MARKER).append('\n');
    }

    private static <K, V> boolean mapsHaveCompatibleOverlap(Map<K, V> a, Map<K, V> b) {
        if (b.size() < a.size()) {
            Map<K, V> t = a;
            a = b;
            b = t;
        }
        boolean overlap = false;
        for (Map.Entry<K, V> e : a.entrySet()) {
            V value = b.get(e.getKey());
            if (value != null) {
                if (!value.equals(e.getValue())) {
                    return false;
                }
                overlap = true;
                continue;
            }
            if (!b.containsKey(e.getKey())) continue;
            if (e.getValue() != null) {
                return false;
            }
            overlap = true;
        }
        return overlap;
    }

    private static void writeJsString(String value, StringBuilder out) {
        out.append('\'').append(EscapingConventions.EscapeJsString.INSTANCE.escape(value)).append('\'');
    }

    private static void writeJsChar(char value, StringBuilder out) {
        if (!GenerateSoyUtilsEscapingDirectiveCode.isPrintable(value)) {
            out.append(String.format(value >= '\u0100' ? "'\\u%04x'" : "'\\x%02x'", value));
        } else {
            out.append('\'').append(EscapingConventions.EscapeJsString.INSTANCE.escape(String.valueOf(value))).append('\'');
        }
    }

    private static void escapeRegexpRangeOnto(char start, char end, StringBuilder out) {
        if (!GenerateSoyUtilsEscapingDirectiveCode.isPrintable(start)) {
            out.append(String.format(start >= '\u0100' ? "\\u%04x" : "\\x%02x", start));
        } else {
            out.append(EscapingConventions.EscapeJsRegex.INSTANCE.escape(String.valueOf(start)));
        }
        if (start != end) {
            if (end - start > 1) {
                out.append('-');
            }
            if (!GenerateSoyUtilsEscapingDirectiveCode.isPrintable(end)) {
                out.append(String.format(end >= '\u0100' ? "\\u%04x" : "\\x%02x", end));
            } else {
                out.append(EscapingConventions.EscapeJsRegex.INSTANCE.escape(String.valueOf(end)));
            }
        }
    }

    private static boolean isPrintable(char ch) {
        return ' ' <= ch && ch <= '~';
    }

    private static String javaRegexToJs(Pattern p) {
        String body = p.pattern().replace("\r", "\\r").replace("\n", "\\n").replace("\u2028", "\\u2028").replace("\u2029", "\\u2029").replace("\\A", "^").replace("\\z", "$").replaceAll("(?<!\\\\)(?:\\\\{2})*/", "\\\\/");
        if (body.contains("(?<")) {
            throw new IllegalArgumentException("Pattern " + p + " uses lookbehind.");
        }
        if ((p.flags() & 0x20) != 0) {
            throw new IllegalArgumentException("Pattern " + p + " uses DOTALL.");
        }
        if (NAMED_CLASS.matcher(body).find()) {
            throw new IllegalArgumentException("Pattern " + p + " uses named characer classes.");
        }
        StringBuilder buffer = new StringBuilder(body.length() + 4);
        buffer.append('/').append(body).append('/');
        if ((p.flags() & 2) != 0) {
            buffer.append('i');
        }
        if ((p.flags() & 8) != 0) {
            buffer.append('m');
        }
        return buffer.toString();
    }

    private static String toJsStringSet(Iterable<? extends String> strings) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        sb.append('{');
        for (String string : strings) {
            if (!isFirst) {
                sb.append(", ");
            }
            isFirst = false;
            GenerateSoyUtilsEscapingDirectiveCode.writeJsString(string, sb);
            sb.append(": 1");
        }
        sb.append('}');
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        GenerateSoyUtilsEscapingDirectiveCode generator = new GenerateSoyUtilsEscapingDirectiveCode();
        for (String arg : args) {
            FileRef ref;
            if (arg.startsWith("--input=")) {
                ref = generator.createInput();
                ref.setPath(arg.substring(arg.indexOf(61) + 1));
                continue;
            }
            if (arg.startsWith("--output=")) {
                ref = generator.createOutput();
                ref.setPath(arg.substring(arg.indexOf(61) + 1));
                continue;
            }
            if (arg.startsWith("--jsdefined=")) {
                FunctionNamePredicate jsdefined = new FunctionNamePredicate();
                jsdefined.setPattern(arg.substring(arg.indexOf(61) + 1));
                generator.addConfiguredJsdefined(jsdefined);
                continue;
            }
            throw new IllegalArgumentException(arg);
        }
        generator.execute();
    }

    public static final class FunctionNamePredicate {
        private Pattern namePattern;

        public void setPattern(String s) {
            String regex = "\\Q" + s.replace("*", "\\E\\w+\\Q") + "\\E";
            this.namePattern = Pattern.compile(regex);
        }
    }

    public static final class FileRef {
        private final boolean isInput;
        private File file;

        public FileRef(boolean isInput) {
            this.isInput = isInput;
        }

        public void setPath(String path) throws IOException {
            this.file = new File(path);
            if (this.isInput) {
                if (!this.file.isFile() || !this.file.canRead()) {
                    throw new IOException("Missing input file " + path);
                }
            } else if (this.file.isDirectory() || !this.file.getParentFile().isDirectory()) {
                throw new IOException("Cannot write output file " + path);
            }
        }
    }
}

