/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.msgs.restricted.IcuSyntaxUtils;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgPluralRemainderNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoySyntaxExceptionUtils;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GenJsCodeVisitorAssistantForMsgs
extends AbstractSoyNodeVisitor<Void> {
    private static final Pattern UNDERSCORE_NUMBER_SUFFIX = Pattern.compile("_[0-9]+$");
    private final GenJsCodeVisitor master;
    private final JsExprTranslator jsExprTranslator;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitor genJsExprsVisitor;
    private final JsCodeBuilder jsCodeBuilder;
    private final Deque<Map<String, JsExpr>> localVarTranslations;

    GenJsCodeVisitorAssistantForMsgs(GenJsCodeVisitor master, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, JsCodeBuilder jsCodeBuilder, Deque<Map<String, JsExpr>> localVarTranslations, GenJsExprsVisitor genJsExprsVisitor) {
        this.master = master;
        this.jsExprTranslator = jsExprTranslator;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.jsCodeBuilder = jsCodeBuilder;
        this.localVarTranslations = localVarTranslations;
        this.genJsExprsVisitor = genJsExprsVisitor;
    }

    @Override
    public Void exec(SoyNode node) {
        throw new AssertionError();
    }

    void visitForUseByMaster(SoyNode node) {
        this.visit(node);
    }

    @Override
    protected void visitGoogMsgNode(GoogMsgNode node) {
        boolean isPlrselMsg = node.isPlrselMsg();
        GoogMsgCodeGenInfo googMsgCodeGenInfo = new GoogMsgCodeGenInfo(isPlrselMsg);
        this.genGoogMsgCodeForChildren(node, node, googMsgCodeGenInfo);
        String msgTextCode = BaseUtils.escapeToSoyString(googMsgCodeGenInfo.msgTextCodeSb.toString(), false);
        msgTextCode = JsSrcUtils.escapeUnicodeFormatChars(msgTextCode);
        this.jsCodeBuilder.indent().append("/** ");
        if (node.getMeaning() != null) {
            this.jsCodeBuilder.append("@meaning ", node.getMeaning(), "\n");
            this.jsCodeBuilder.indent().append(" *  ");
        }
        this.jsCodeBuilder.append("@desc ", node.getDesc());
        if (node.isHidden()) {
            this.jsCodeBuilder.append("\n");
            this.jsCodeBuilder.indent().append(" *  @hidden");
        }
        this.jsCodeBuilder.append(" */\n");
        this.jsCodeBuilder.indent().append("var ", node.getGoogMsgVarName(), " = goog.getMsg(");
        if (isPlrselMsg) {
            this.jsCodeBuilder.append(msgTextCode);
        } else if (googMsgCodeGenInfo.placeholderCodeBits.size() == 0) {
            this.jsCodeBuilder.append(msgTextCode);
        } else {
            this.jsCodeBuilder.append("\n");
            this.jsCodeBuilder.indent().append("    ", msgTextCode, ",");
            this.appendCodeBits(googMsgCodeGenInfo.placeholderCodeBits);
        }
        this.jsCodeBuilder.append(");\n");
        if (isPlrselMsg) {
            List<String> codeBitsForMfCall = googMsgCodeGenInfo.plrselVarCodeBits;
            codeBitsForMfCall.addAll(googMsgCodeGenInfo.placeholderCodeBits);
            this.jsCodeBuilder.indent().append("var ", node.getRenderedGoogMsgVarName(), " = (new goog.i18n.MessageFormat(", node.getGoogMsgVarName(), ")).formatIgnoringPound(");
            this.appendCodeBits(codeBitsForMfCall);
            this.jsCodeBuilder.append(");\n");
        }
    }

    private void appendCodeBits(List<String> codeBits) {
        boolean isFirst = true;
        for (String codeBit : codeBits) {
            if (isFirst) {
                this.jsCodeBuilder.append("\n");
                this.jsCodeBuilder.indent().append("    {");
                isFirst = false;
            } else {
                this.jsCodeBuilder.append(",\n");
                this.jsCodeBuilder.indent().append("     ");
            }
            this.jsCodeBuilder.append(codeBit);
        }
        this.jsCodeBuilder.append("}");
    }

    private void genGoogMsgCodeForChildren(SoyNode.BlockNode parentNode, GoogMsgNode googMsgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        StringBuilder msgTextCodeSb = googMsgCodeGenInfo.msgTextCodeSb;
        if (parentNode instanceof MsgPluralCaseNode) {
            msgTextCodeSb.append(IcuSyntaxUtils.getPluralCaseOpenString(((MsgPluralCaseNode)parentNode).getCaseNumber()));
        } else if (parentNode instanceof MsgPluralDefaultNode) {
            msgTextCodeSb.append(IcuSyntaxUtils.getPluralCaseOpenString(null));
        } else if (parentNode instanceof MsgSelectCaseNode) {
            msgTextCodeSb.append(IcuSyntaxUtils.getSelectCaseOpenString(((MsgSelectCaseNode)parentNode).getCaseValue()));
        } else if (parentNode instanceof MsgSelectDefaultNode) {
            msgTextCodeSb.append(IcuSyntaxUtils.getSelectCaseOpenString(null));
        }
        for (SoyNode.StandaloneNode child : parentNode.getChildren()) {
            if (child instanceof RawTextNode) {
                msgTextCodeSb.append(((RawTextNode)child).getRawText());
                continue;
            }
            if (child instanceof MsgPlaceholderNode) {
                this.genGoogMsgCodeForMsgPlaceholderNode((MsgPlaceholderNode)child, googMsgNode, googMsgCodeGenInfo);
                continue;
            }
            if (child instanceof MsgPluralNode) {
                this.genGoogMsgCodeForPluralNode((MsgPluralNode)child, googMsgNode, googMsgCodeGenInfo);
                continue;
            }
            if (child instanceof MsgSelectNode) {
                this.genGoogMsgCodeForSelectNode((MsgSelectNode)child, googMsgNode, googMsgCodeGenInfo);
                continue;
            }
            if (child instanceof MsgPluralRemainderNode) {
                msgTextCodeSb.append(IcuSyntaxUtils.getPluralRemainderString());
                continue;
            }
            String nodeStringForErrorMsg = child instanceof SoyNode.CommandNode ? "Tag " + ((SoyNode.CommandNode)((Object)child)).getTagString() : "Node " + child.toString();
            throw SoySyntaxExceptionUtils.createWithNode(nodeStringForErrorMsg + " is not allowed to be a direct child of a message.", child);
        }
        if (parentNode instanceof MsgPluralCaseNode || parentNode instanceof MsgPluralDefaultNode) {
            msgTextCodeSb.append(IcuSyntaxUtils.getPluralCaseCloseString());
        } else if (parentNode instanceof MsgSelectCaseNode || parentNode instanceof MsgSelectDefaultNode) {
            msgTextCodeSb.append(IcuSyntaxUtils.getSelectCaseCloseString());
        }
    }

    private void genGoogMsgCodeForPluralNode(MsgPluralNode pluralNode, GoogMsgNode googMsgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        String pluralVarName = googMsgNode.getPluralVarName(pluralNode);
        StringBuilder msgTextCodeSb = googMsgCodeGenInfo.msgTextCodeSb;
        msgTextCodeSb.append(IcuSyntaxUtils.getPluralOpenString(pluralVarName, pluralNode.getOffset()));
        GenJsCodeVisitorAssistantForMsgs.updatePlrselVarCodeBits(googMsgCodeGenInfo, pluralVarName, this.jsExprTranslator.translateToJsExpr(pluralNode.getExpr(), null, this.localVarTranslations).getText());
        for (CaseOrDefaultNode child : pluralNode.getChildren()) {
            this.genGoogMsgCodeForChildren(child, googMsgNode, googMsgCodeGenInfo);
        }
        msgTextCodeSb.append(IcuSyntaxUtils.getPluralCloseString());
    }

    private void genGoogMsgCodeForSelectNode(MsgSelectNode selectNode, GoogMsgNode googMsgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        String selectVarName = googMsgNode.getSelectVarName(selectNode);
        StringBuilder msgTextCodeSb = googMsgCodeGenInfo.msgTextCodeSb;
        msgTextCodeSb.append(IcuSyntaxUtils.getSelectOpenString(selectVarName));
        GenJsCodeVisitorAssistantForMsgs.updatePlrselVarCodeBits(googMsgCodeGenInfo, selectVarName, this.jsExprTranslator.translateToJsExpr(selectNode.getExpr(), null, this.localVarTranslations).getText());
        for (CaseOrDefaultNode child : selectNode.getChildren()) {
            this.genGoogMsgCodeForChildren(child, googMsgNode, googMsgCodeGenInfo);
        }
        msgTextCodeSb.append(IcuSyntaxUtils.getSelectCloseString());
    }

    private void genGoogMsgCodeForMsgPlaceholderNode(MsgPlaceholderNode node, GoogMsgNode googMsgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        String placeholderName = googMsgNode.getPlaceholderName(node);
        if (googMsgCodeGenInfo.doUseBracedPhs) {
            googMsgCodeGenInfo.msgTextCodeSb.append('{').append(placeholderName).append('}');
            GenJsCodeVisitorAssistantForMsgs.updatePlaceholderCodeBits(googMsgCodeGenInfo, placeholderName, placeholderName, this.genGoogMsgPlaceholderExpr(node).getText());
        } else {
            String googMsgPlaceholderName = GenJsCodeVisitorAssistantForMsgs.genGoogMsgPlaceholderName(placeholderName);
            googMsgCodeGenInfo.msgTextCodeSb.append("{$").append(googMsgPlaceholderName).append('}');
            GenJsCodeVisitorAssistantForMsgs.updatePlaceholderCodeBits(googMsgCodeGenInfo, placeholderName, googMsgPlaceholderName, this.genGoogMsgPlaceholderExpr(node).getText());
        }
    }

    private static void updatePlrselVarCodeBits(GoogMsgCodeGenInfo googMsgCodeGenInfo, String plrselVarName, String exprText) {
        if (googMsgCodeGenInfo.seenPlrselVarNames.contains(plrselVarName)) {
            return;
        }
        googMsgCodeGenInfo.seenPlrselVarNames.add(plrselVarName);
        String placeholderCodeBit = "'" + plrselVarName + "': " + exprText;
        googMsgCodeGenInfo.plrselVarCodeBits.add(placeholderCodeBit);
    }

    private static void updatePlaceholderCodeBits(GoogMsgCodeGenInfo googMsgCodeGenInfo, String placeholderName, String googMsgPlaceholderName, String exprText) {
        if (googMsgCodeGenInfo.seenPlaceholderNames.contains(placeholderName)) {
            return;
        }
        googMsgCodeGenInfo.seenPlaceholderNames.add(placeholderName);
        String placeholderCodeBit = "'" + googMsgPlaceholderName + "': " + exprText;
        googMsgCodeGenInfo.placeholderCodeBits.add(placeholderCodeBit);
    }

    private static String genGoogMsgPlaceholderName(String placeholderName) {
        Matcher suffixMatcher = UNDERSCORE_NUMBER_SUFFIX.matcher(placeholderName);
        if (suffixMatcher.find()) {
            String base = placeholderName.substring(0, suffixMatcher.start());
            String suffix = suffixMatcher.group();
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, base) + suffix;
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, placeholderName);
    }

    private JsExpr genGoogMsgPlaceholderExpr(MsgPlaceholderNode msgPhNode) {
        ArrayList contentJsExprs = Lists.newArrayList();
        for (SoyNode.StandaloneNode contentNode : msgPhNode.getChildren()) {
            if (contentNode instanceof MsgHtmlTagNode && !((Boolean)this.isComputableAsJsExprsVisitor.exec(contentNode)).booleanValue()) {
                this.visit(contentNode);
                contentJsExprs.add(new JsExpr("htmlTag" + contentNode.getId(), Integer.MAX_VALUE));
                continue;
            }
            if (contentNode instanceof CallNode) {
                CallNode callNode = (CallNode)contentNode;
                for (CallParamNode grandchild : callNode.getChildren()) {
                    if (!(grandchild instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(grandchild)).booleanValue()) continue;
                    this.visit(grandchild);
                }
                contentJsExprs.add(this.genCallCodeUtils.genCallExpr(callNode, this.localVarTranslations));
                continue;
            }
            contentJsExprs.addAll(this.genJsExprsVisitor.exec(contentNode));
        }
        return JsExprUtils.concatJsExprs(contentJsExprs);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'htmlTag<n>' when not computable as JS expressions.");
        }
        this.jsCodeBuilder.pushOutputVar("htmlTag" + node.getId());
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        this.master.visitForUseByAssistants(node);
    }

    private static class GoogMsgCodeGenInfo {
        public final boolean doUseBracedPhs;
        public StringBuilder msgTextCodeSb;
        public List<String> placeholderCodeBits;
        public Set<String> seenPlaceholderNames;
        public List<String> plrselVarCodeBits;
        public Set<String> seenPlrselVarNames;

        public GoogMsgCodeGenInfo(boolean doUseBracedPhs) {
            this.doUseBracedPhs = doUseBracedPhs;
            this.msgTextCodeSb = new StringBuilder();
            this.placeholderCodeBits = Lists.newArrayList();
            this.seenPlaceholderNames = Sets.newHashSet();
            this.plrselVarCodeBits = Lists.newArrayList();
            this.seenPlrselVarNames = Sets.newHashSet();
        }
    }
}

