/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.template.soy.base.SoyFileKind;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.FindCalleesNotInFileVisitor;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.HasPlrselMsgVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.ShouldEnsureDataIsDefinedVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoySyntaxExceptionUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GenJsCodeVisitor
extends AbstractSoyNodeVisitor<List<String>> {
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final Pattern INTEGER = Pattern.compile("-?\\d+");
    private static final String GOOG_IS_RTL_NAMESPACE = "goog.i18n.bidi";
    private static final String GOOG_MESSAGE_FORMAT_NAMESPACE = "goog.i18n.MessageFormat";
    private final SoyJsSrcOptions jsSrcOptions;
    private final boolean isUsingIjData;
    private final JsExprTranslator jsExprTranslator;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final CanInitOutputVarVisitor canInitOutputVarVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private List<String> jsFilesContents;
    @VisibleForTesting
    protected JsCodeBuilder jsCodeBuilder;
    @VisibleForTesting
    protected Deque<Map<String, JsExpr>> localVarTranslations;
    @VisibleForTesting
    protected GenJsExprsVisitor genJsExprsVisitor;
    @VisibleForTesting
    protected GenJsCodeVisitorAssistantForMsgs assistantForMsgs;

    @Inject
    GenJsCodeVisitor(SoyJsSrcOptions jsSrcOptions, @ApiCallScopeBindingAnnotations.IsUsingIjData boolean isUsingIjData, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory) {
        this.jsSrcOptions = jsSrcOptions;
        this.isUsingIjData = isUsingIjData;
        this.jsExprTranslator = jsExprTranslator;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.canInitOutputVarVisitor = canInitOutputVarVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
    }

    @Override
    public List<String> exec(SoyNode node) {
        this.jsFilesContents = Lists.newArrayList();
        this.jsCodeBuilder = null;
        this.localVarTranslations = null;
        this.genJsExprsVisitor = null;
        this.assistantForMsgs = null;
        this.visit(node);
        return this.jsFilesContents;
    }

    void visitForUseByAssistants(SoyNode node) {
        this.visit(node);
    }

    @Override
    @VisibleForTesting
    protected void visit(SoyNode node) {
        super.visit(node);
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        if (node.numChildren() == 0 || !((Boolean)this.canInitOutputVarVisitor.exec(node.getChild(0))).booleanValue()) {
            this.jsCodeBuilder.initOutputVarIfNecessary();
        }
        ArrayList consecChildrenJsExprs = Lists.newArrayList();
        for (SoyNode child : node.getChildren()) {
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) {
                consecChildrenJsExprs.addAll(this.genJsExprsVisitor.exec(child));
                continue;
            }
            if (consecChildrenJsExprs.size() > 0) {
                this.jsCodeBuilder.addToOutputVar(consecChildrenJsExprs);
                consecChildrenJsExprs.clear();
            }
            this.visit(child);
        }
        if (consecChildrenJsExprs.size() > 0) {
            this.jsCodeBuilder.addToOutputVar(consecChildrenJsExprs);
            consecChildrenJsExprs.clear();
        }
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            try {
                this.visit(soyFile);
            }
            catch (SoySyntaxException sse) {
                throw sse.associateMetaInfo(null, soyFile.getFilePath(), null);
            }
        }
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        if (node.getSoyFileKind() == SoyFileKind.DEP) {
            return;
        }
        this.jsCodeBuilder = new JsCodeBuilder(this.jsSrcOptions.getCodeStyle());
        this.jsCodeBuilder.appendLine("// This file was automatically generated from ", node.getFileName(), ".");
        this.jsCodeBuilder.appendLine("// Please don't edit this file by hand.");
        if (node.getDelPackageName() != null) {
            this.jsCodeBuilder.appendLine(new String[0]);
            this.jsCodeBuilder.appendLine("/**");
            this.jsCodeBuilder.appendLine(" * @modName {", node.getDelPackageName(), "}");
            this.jsCodeBuilder.appendLine(" */");
        }
        this.jsCodeBuilder.appendLine(new String[0]);
        if (this.jsSrcOptions.shouldProvideRequireSoyNamespaces()) {
            this.addCodeToProvideSoyNamespace(node);
            if (this.jsSrcOptions.shouldProvideBothSoyNamespacesAndJsFunctions()) {
                this.addCodeToProvideJsFunctions(node);
            }
            this.jsCodeBuilder.appendLine(new String[0]);
            this.addCodeToRequireGeneralDeps(node);
            this.addCodeToRequireSoyNamespaces(node);
        } else if (this.jsSrcOptions.shouldProvideRequireJsFunctions()) {
            if (this.jsSrcOptions.shouldProvideBothSoyNamespacesAndJsFunctions()) {
                this.addCodeToProvideSoyNamespace(node);
            }
            this.addCodeToProvideJsFunctions(node);
            this.jsCodeBuilder.appendLine(new String[0]);
            this.addCodeToRequireGeneralDeps(node);
            this.addCodeToRequireJsFunctions(node);
        } else {
            this.addCodeToDefineJsNamespaces(node);
        }
        for (TemplateNode template : node.getChildren()) {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            try {
                this.visit(template);
            }
            catch (SoySyntaxException sse) {
                throw sse.associateMetaInfo(null, null, template.getTemplateNameForUserMsgs());
            }
        }
        this.jsFilesContents.add(this.jsCodeBuilder.getCode());
        this.jsCodeBuilder = null;
    }

    private void addCodeToDefineJsNamespaces(SoyFileNode soyFile) {
        TreeSet jsNamespaces = Sets.newTreeSet();
        for (TemplateNode template : soyFile.getChildren()) {
            String templateName = template.getTemplateName();
            Matcher dotMatcher = DOT.matcher(templateName);
            while (dotMatcher.find()) {
                jsNamespaces.add(templateName.substring(0, dotMatcher.start()));
            }
        }
        for (String jsNamespace : jsNamespaces) {
            boolean hasDot;
            boolean bl = hasDot = jsNamespace.indexOf(46) >= 0;
            if (!this.jsSrcOptions.shouldDeclareTopLevelNamespaces() && !hasDot) continue;
            this.jsCodeBuilder.appendLine("if (typeof ", jsNamespace, " == 'undefined') { ", hasDot ? "" : "var ", jsNamespace, " = {}; }");
        }
    }

    private void addCodeToProvideSoyNamespace(SoyFileNode soyFile) {
        this.jsCodeBuilder.appendLine("goog.provide('", soyFile.getNamespace(), "');");
    }

    private void addCodeToProvideJsFunctions(SoyFileNode soyFile) {
        TreeSet templateNames = Sets.newTreeSet();
        for (TemplateNode template : soyFile.getChildren()) {
            if (template instanceof TemplateBasicNode && ((TemplateBasicNode)template).isOverride()) continue;
            templateNames.add(template.getTemplateName());
        }
        for (String templateName : templateNames) {
            this.jsCodeBuilder.appendLine("goog.provide('", templateName, "');");
        }
    }

    private void addCodeToRequireGeneralDeps(SoyFileNode soyFile) {
        this.jsCodeBuilder.appendLine("goog.require('soy');");
        this.jsCodeBuilder.appendLine("goog.require('soydata');");
        if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            this.jsCodeBuilder.appendLine("goog.require('soy.StringBuilder');");
        }
        if (this.jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir()) {
            this.jsCodeBuilder.appendLine("goog.require('", GOOG_IS_RTL_NAMESPACE, "');");
        }
        if (new HasPlrselMsgVisitor().exec(soyFile).booleanValue()) {
            this.jsCodeBuilder.appendLine("goog.require('", GOOG_MESSAGE_FORMAT_NAMESPACE, "');");
        }
    }

    private void addCodeToRequireSoyNamespaces(SoyFileNode soyFile) {
        String prevCalleeNamespace = null;
        for (String calleeNotInFile : new FindCalleesNotInFileVisitor().exec(soyFile)) {
            int lastDotIndex = calleeNotInFile.lastIndexOf(46);
            if (lastDotIndex == -1) {
                throw SoySyntaxExceptionUtils.createWithNode("When using the option to provide/require Soy namespaces, found a called template \"" + calleeNotInFile + "\" that does not reside in a namespace.", soyFile);
            }
            String calleeNamespace = calleeNotInFile.substring(0, lastDotIndex);
            if (calleeNamespace.length() <= 0 || calleeNamespace.equals(prevCalleeNamespace)) continue;
            this.jsCodeBuilder.appendLine("goog.require('", calleeNamespace, "');");
            prevCalleeNamespace = calleeNamespace;
        }
    }

    private void addCodeToRequireJsFunctions(SoyFileNode soyFile) {
        for (String calleeNotInFile : new FindCalleesNotInFileVisitor().exec(soyFile)) {
            this.jsCodeBuilder.appendLine("goog.require('", calleeNotInFile, "');");
        }
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        boolean isCodeStyleStringbuilder = this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER;
        this.localVarTranslations = new ArrayDeque<Map<String, JsExpr>>();
        this.genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.localVarTranslations);
        this.assistantForMsgs = null;
        if (this.jsSrcOptions.shouldGenerateJsdoc()) {
            this.jsCodeBuilder.appendLine("/**");
            this.jsCodeBuilder.appendLine(" * @param {Object.<string, *>=} opt_data");
            if (isCodeStyleStringbuilder) {
                this.jsCodeBuilder.appendLine(" * @param {soy.StringBuilder=} opt_sb");
            } else {
                this.jsCodeBuilder.appendLine(" * @param {(null|undefined)=} opt_ignored");
            }
            if (this.isUsingIjData) {
                this.jsCodeBuilder.appendLine(" * @param {Object.<string, *>=} opt_ijData");
            }
            String returnType = node.getContentKind() == null ? "string" : NodeContentKinds.toJsSanitizedContentTypeName(node.getContentKind());
            this.jsCodeBuilder.appendLine(" * @return {", returnType, "}");
            this.jsCodeBuilder.appendLine(" * @notypecheck");
            if (node instanceof TemplateBasicNode && ((TemplateBasicNode)node).isOverride()) {
                this.jsCodeBuilder.appendLine(" * @suppress {duplicate}");
            }
            this.jsCodeBuilder.appendLine(" */");
        }
        this.jsCodeBuilder.appendLine(node.getTemplateName(), " = function(opt_data", isCodeStyleStringbuilder ? ", opt_sb" : ", opt_ignored", this.isUsingIjData ? ", opt_ijData" : "", ") {");
        this.jsCodeBuilder.increaseIndent();
        this.generateFunctionBody(node);
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("};");
        if (node instanceof TemplateDelegateNode) {
            TemplateDelegateNode nodeAsDelTemplate = (TemplateDelegateNode)node;
            String delTemplateIdExprText = "soy.$$getDelTemplateId('" + nodeAsDelTemplate.getDelTemplateName() + "')";
            String delTemplateVariantExprText = "'" + nodeAsDelTemplate.getDelTemplateVariant() + "'";
            this.jsCodeBuilder.appendLine("soy.$$registerDelegateFn(", delTemplateIdExprText, ", ", delTemplateVariantExprText, ", ", Integer.toString(nodeAsDelTemplate.getDelPriority()), ", ", nodeAsDelTemplate.getTemplateName(), ");");
        }
    }

    private void generateFunctionBody(TemplateNode node) {
        JsExpr resultJsExpr;
        boolean isCodeStyleStringbuilder = this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER;
        this.localVarTranslations.push(Maps.newHashMap());
        if (new ShouldEnsureDataIsDefinedVisitor().exec(node)) {
            this.jsCodeBuilder.appendLine("opt_data = opt_data || {};");
        }
        if (!isCodeStyleStringbuilder && ((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            List<JsExpr> templateBodyJsExprs = this.genJsExprsVisitor.exec(node);
            resultJsExpr = JsExprUtils.concatJsExprs(templateBodyJsExprs);
        } else {
            this.jsCodeBuilder.pushOutputVar("output");
            if (isCodeStyleStringbuilder) {
                this.jsCodeBuilder.appendLine("var output = opt_sb || new soy.StringBuilder();");
                this.jsCodeBuilder.setOutputVarInited();
            }
            this.visitChildren(node);
            resultJsExpr = isCodeStyleStringbuilder ? new JsExpr("opt_sb ? '' : output.toString()", Integer.MAX_VALUE) : new JsExpr("output", Integer.MAX_VALUE);
            this.jsCodeBuilder.popOutputVar();
        }
        if (node.getContentKind() != null) {
            if (isCodeStyleStringbuilder) {
                throw SoySyntaxExceptionUtils.createWithNode("Soy's StringBuilder-based code generation mode does not currently support autoescape=\"strict\".", node);
            }
            resultJsExpr = JsExprUtils.maybeWrapAsSanitizedContent(node.getContentKind(), resultJsExpr);
        }
        this.jsCodeBuilder.appendLine("return ", resultJsExpr.getText(), ";");
        this.localVarTranslations.pop();
    }

    @Override
    protected void visitGoogMsgNode(GoogMsgNode node) {
        if (this.assistantForMsgs == null) {
            this.assistantForMsgs = new GenJsCodeVisitorAssistantForMsgs(this, this.jsExprTranslator, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.jsCodeBuilder, this.localVarTranslations, this.genJsExprsVisitor);
        }
        this.assistantForMsgs.visitForUseByMaster(node);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(node));
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        String generatedVarName = node.getUniqueVarName();
        JsExpr valueJsExpr = this.jsExprTranslator.translateToJsExpr(node.getValueExpr(), null, this.localVarTranslations);
        this.jsCodeBuilder.appendLine("var ", generatedVarName, " = ", valueJsExpr.getText(), ";");
        this.localVarTranslations.peek().put(node.getVarName(), new JsExpr(generatedVarName, Integer.MAX_VALUE));
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        String generatedVarName = node.getUniqueVarName();
        this.localVarTranslations.push(Maps.newHashMap());
        this.jsCodeBuilder.pushOutputVar(generatedVarName);
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
        if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            this.jsCodeBuilder.appendLine(generatedVarName, " = ", generatedVarName, ".toString();");
        }
        if (node.getContentKind() != null) {
            String sanitizedContentOrdainer = NodeContentKinds.toJsSanitizedContentOrdainer(node.getContentKind());
            this.jsCodeBuilder.appendLine(generatedVarName, " = ", sanitizedContentOrdainer, "(", generatedVarName, ");");
        }
        this.localVarTranslations.peek().put(node.getVarName(), new JsExpr(generatedVarName, Integer.MAX_VALUE));
    }

    @Override
    protected void visitIfNode(IfNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(node));
            return;
        }
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                JsExpr condJsExpr = this.jsExprTranslator.translateToJsExpr(icn.getExprUnion().getExpr(), icn.getExprText(), this.localVarTranslations);
                if (icn.getCommandName().equals("if")) {
                    this.jsCodeBuilder.appendLine("if (", condJsExpr.getText(), ") {");
                } else {
                    this.jsCodeBuilder.appendLine("} else if (", condJsExpr.getText(), ") {");
                }
                this.jsCodeBuilder.increaseIndent();
                this.visit(icn);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            if (child instanceof IfElseNode) {
                IfElseNode ien = (IfElseNode)child;
                this.jsCodeBuilder.appendLine("} else {");
                this.jsCodeBuilder.increaseIndent();
                this.visit(ien);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitSwitchNode(SwitchNode node) {
        JsExpr switchValueJsExpr = this.jsExprTranslator.translateToJsExpr(node.getExpr(), node.getExprText(), this.localVarTranslations);
        this.jsCodeBuilder.appendLine("switch (", switchValueJsExpr.getText(), ") {");
        this.jsCodeBuilder.increaseIndent();
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode scn = (SwitchCaseNode)child;
                for (ExprRootNode<?> caseExpr : scn.getExprList()) {
                    JsExpr caseJsExpr = this.jsExprTranslator.translateToJsExpr(caseExpr, null, this.localVarTranslations);
                    this.jsCodeBuilder.appendLine("case ", caseJsExpr.getText(), ":");
                }
                this.jsCodeBuilder.increaseIndent();
                this.visit(scn);
                this.jsCodeBuilder.appendLine("break;");
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            if (child instanceof SwitchDefaultNode) {
                SwitchDefaultNode sdn = (SwitchDefaultNode)child;
                this.jsCodeBuilder.appendLine("default:");
                this.jsCodeBuilder.increaseIndent();
                this.visit(sdn);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitForeachNode(ForeachNode node) {
        boolean hasIfemptyNode;
        String baseVarName = node.getVarName();
        String nodeId = Integer.toString(node.getId());
        String listVarName = baseVarName + "List" + nodeId;
        String listLenVarName = baseVarName + "ListLen" + nodeId;
        JsExpr dataRefJsExpr = this.jsExprTranslator.translateToJsExpr(node.getExpr(), node.getExprText(), this.localVarTranslations);
        this.jsCodeBuilder.appendLine("var ", listVarName, " = ", dataRefJsExpr.getText(), ";");
        this.jsCodeBuilder.appendLine("var ", listLenVarName, " = ", listVarName, ".length;");
        boolean bl = hasIfemptyNode = node.numChildren() == 2;
        if (hasIfemptyNode) {
            this.jsCodeBuilder.appendLine("if (", listLenVarName, " > 0) {");
            this.jsCodeBuilder.increaseIndent();
        }
        this.visit((SoyNode)node.getChild(0));
        if (hasIfemptyNode) {
            this.jsCodeBuilder.decreaseIndent();
            this.jsCodeBuilder.appendLine("} else {");
            this.jsCodeBuilder.increaseIndent();
            this.visit((SoyNode)node.getChild(1));
            this.jsCodeBuilder.decreaseIndent();
            this.jsCodeBuilder.appendLine("}");
        }
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
        String baseVarName = node.getVarName();
        String foreachNodeId = Integer.toString(node.getForeachNodeId());
        String listVarName = baseVarName + "List" + foreachNodeId;
        String listLenVarName = baseVarName + "ListLen" + foreachNodeId;
        String indexVarName = baseVarName + "Index" + foreachNodeId;
        String dataVarName = baseVarName + "Data" + foreachNodeId;
        this.jsCodeBuilder.appendLine("for (var ", indexVarName, " = 0; ", indexVarName, " < ", listLenVarName, "; ", indexVarName, "++) {");
        this.jsCodeBuilder.increaseIndent();
        this.jsCodeBuilder.appendLine("var ", dataVarName, " = ", listVarName, "[", indexVarName, "];");
        HashMap newLocalVarTranslationsFrame = Maps.newHashMap();
        newLocalVarTranslationsFrame.put(baseVarName, new JsExpr(dataVarName, Integer.MAX_VALUE));
        newLocalVarTranslationsFrame.put(baseVarName + "__isFirst", new JsExpr(indexVarName + " == 0", Operator.EQUAL.getPrecedence()));
        newLocalVarTranslationsFrame.put(baseVarName + "__isLast", new JsExpr(indexVarName + " == " + listLenVarName + " - 1", Operator.EQUAL.getPrecedence()));
        newLocalVarTranslationsFrame.put(baseVarName + "__index", new JsExpr(indexVarName, Integer.MAX_VALUE));
        this.localVarTranslations.push(newLocalVarTranslationsFrame);
        this.visitChildren(node);
        this.localVarTranslations.pop();
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitForNode(ForNode node) {
        String incrementCode;
        String limitCode;
        String initCode;
        String varName = node.getVarName();
        String nodeId = Integer.toString(node.getId());
        ArrayList rangeArgs = Lists.newArrayList(node.getRangeArgs());
        String incrementJsExprText = rangeArgs.size() == 3 ? this.jsExprTranslator.translateToJsExpr((ExprNode)rangeArgs.remove(2), null, this.localVarTranslations).getText() : "1";
        String initJsExprText = rangeArgs.size() == 2 ? this.jsExprTranslator.translateToJsExpr((ExprNode)rangeArgs.remove(0), null, this.localVarTranslations).getText() : "0";
        String limitJsExprText = this.jsExprTranslator.translateToJsExpr((ExprNode)rangeArgs.get(0), null, this.localVarTranslations).getText();
        if (INTEGER.matcher(initJsExprText).matches()) {
            initCode = initJsExprText;
        } else {
            initCode = varName + "Init" + nodeId;
            this.jsCodeBuilder.appendLine("var ", initCode, " = ", initJsExprText, ";");
        }
        if (INTEGER.matcher(limitJsExprText).matches()) {
            limitCode = limitJsExprText;
        } else {
            limitCode = varName + "Limit" + nodeId;
            this.jsCodeBuilder.appendLine("var ", limitCode, " = ", limitJsExprText, ";");
        }
        if (INTEGER.matcher(incrementJsExprText).matches()) {
            incrementCode = incrementJsExprText;
        } else {
            incrementCode = varName + "Increment" + nodeId;
            this.jsCodeBuilder.appendLine("var ", incrementCode, " = ", incrementJsExprText, ";");
        }
        String incrementStmt = incrementCode.equals("1") ? varName + nodeId + "++" : varName + nodeId + " += " + incrementCode;
        this.jsCodeBuilder.appendLine("for (var ", varName, nodeId, " = ", initCode, "; ", varName, nodeId, " < ", limitCode, "; ", incrementStmt, ") {");
        this.jsCodeBuilder.increaseIndent();
        HashMap newLocalVarTranslationsFrame = Maps.newHashMap();
        newLocalVarTranslationsFrame.put(varName, new JsExpr(varName + nodeId, Integer.MAX_VALUE));
        this.localVarTranslations.push(newLocalVarTranslationsFrame);
        this.visitChildren(node);
        this.localVarTranslations.pop();
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitCallNode(CallNode node) {
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            this.genCallCodeUtils.genAndAppendCallStmt(this.jsCodeBuilder, node, this.localVarTranslations);
        } else {
            JsExpr callExpr = this.genCallCodeUtils.genCallExpr(node, this.localVarTranslations);
            this.jsCodeBuilder.addToOutputVar((List<JsExpr>)ImmutableList.of((Object)callExpr));
        }
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'param<n>' when not computable as JS expressions.");
        }
        this.localVarTranslations.push(Maps.newHashMap());
        this.jsCodeBuilder.pushOutputVar("param" + node.getId());
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
    }

    @Override
    protected void visitLogNode(LogNode node) {
        if (this.isComputableAsJsExprsVisitor.execOnChildren(node).booleanValue()) {
            List<JsExpr> logMsgJsExprs = this.genJsExprsVisitor.execOnChildren(node);
            JsExpr logMsgJsExpr = JsExprUtils.concatJsExprs(logMsgJsExprs);
            this.jsCodeBuilder.appendLine("window.console.log(", logMsgJsExpr.getText(), ");");
        } else {
            this.localVarTranslations.push(Maps.newHashMap());
            this.jsCodeBuilder.pushOutputVar("logMsg_s" + node.getId());
            this.visitChildren(node);
            this.jsCodeBuilder.popOutputVar();
            this.localVarTranslations.pop();
            this.jsCodeBuilder.appendLine("window.console.log(logMsg_s", Integer.toString(node.getId()), ");");
        }
    }

    @Override
    protected void visitDebuggerNode(DebuggerNode node) {
        this.jsCodeBuilder.appendLine("debugger;");
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            if (node instanceof SoyNode.BlockNode) {
                this.localVarTranslations.push(Maps.newHashMap());
                this.visitChildren((SoyNode.BlockNode)node);
                this.localVarTranslations.pop();
            } else {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
            return;
        }
        if (!((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new UnsupportedOperationException();
        }
        this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(node));
    }
}

